/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.sdk.utilities.visualization.heatmap;

import android.graphics.Color;
import com.tencent.map.sdk.utilities.visualization.BaseOverlayProvider;
import com.tencent.map.sdk.utilities.visualization.datamodels.WeightedLatLng;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GradientVectorOverlayProvider
extends BaseOverlayProvider {
    public static final int DEFAULT_RADIUS = 30;
    public static final float DEFAULT_MAX_HEIGHT = 60.0f;
    public static final float DEFAULT_MIN_INTENSITY = 0.0f;
    public static final float DEFAULT_MAX_INTENSITY = 2000.0f;
    public static final float DEFAULT_OPACITY = 1.0f;
    private static final int[] DEFAULT_GRADIENT_COLORS = new int[]{Color.argb((int)255, (int)77, (int)111, (int)255), Color.argb((int)255, (int)0, (int)238, (int)227), Color.argb((int)255, (int)113, (int)236, (int)80), Color.argb((int)255, (int)255, (int)176, (int)0), Color.argb((int)255, (int)255, (int)72, (int)0)};
    private static final float[] DEFAULT_GRADIENT_START_POINTS = new float[]{0.1f, 0.185f, 0.3571f, 0.6142f, 1.0f};
    private static final int DEFAULT_COLOR_MAP_SIZE = 500;
    private static final int MIN_RADIUS = 18;
    private static final int MAX_RADIUS = 150;
    private static final boolean DEFAULT_DRAW_3D = false;
    private static final boolean DEFAULT_ANIMATE = false;
    private static final int DEFAULT_ANIMATE_TIME = 0;
    private List<WeightedLatLng> dataList = new ArrayList<WeightedLatLng>();
    private float maxHeight = 60.0f;
    private int radius = 30;
    private int[] colors = DEFAULT_GRADIENT_COLORS;
    private float[] colorPoints = DEFAULT_GRADIENT_START_POINTS;
    private int colorMapSize = 500;
    private boolean draw3D = false;
    private float maxIntensity = 2000.0f;
    private float minIntensity = 0.0f;
    private boolean intensityFlag = false;
    private boolean mAnimate = false;
    private int mAnimationDuration = 0;

    @Override
    public float getOpacity() {
        return super.getOpacity();
    }

    @Override
    public GradientVectorOverlayProvider opacity(float opacity) {
        super.opacity(opacity);
        return this;
    }

    @Override
    public int getZIndex() {
        return super.getZIndex();
    }

    @Override
    public GradientVectorOverlayProvider zIndex(int zIndex) {
        super.zIndex(zIndex);
        return this;
    }

    @Override
    public int getDisplayLevel() {
        return super.getDisplayLevel();
    }

    @Override
    public GradientVectorOverlayProvider displayLevel(int displayLevel) {
        super.displayLevel(displayLevel);
        return this;
    }

    @Override
    public boolean isVisibility() {
        return super.isVisibility();
    }

    @Override
    public GradientVectorOverlayProvider visibility(boolean visibility) {
        super.visibility(visibility);
        return this;
    }

    @Override
    public int getMinZoom() {
        return super.getMinZoom();
    }

    @Override
    public int getMaxZoom() {
        return super.getMaxZoom();
    }

    public GradientVectorOverlayProvider zoomRange(int minZoom, int maxZoom) {
        if (minZoom <= maxZoom) {
            super.minZoom(minZoom);
            super.maxZoom(maxZoom);
        }
        return this;
    }

    public GradientVectorOverlayProvider data(List<LatLng> val) {
        return this.weightedData(GradientVectorOverlayProvider.wrapData(val));
    }

    public GradientVectorOverlayProvider weightedData(List<WeightedLatLng> val) {
        if (val != null) {
            this.dataList = val;
        }
        return this;
    }

    public GradientVectorOverlayProvider gradient(int[] colors, float[] startPoints) {
        if (colors != null && startPoints != null && colors.length > 0 && startPoints.length > 0 && colors.length == startPoints.length) {
            boolean flag = true;
            for (int i2 = 1; i2 < startPoints.length; ++i2) {
                if (!(startPoints[i2 - 1] > startPoints[i2])) continue;
                flag = false;
                break;
            }
            if (flag && startPoints[0] >= 0.0f && startPoints[startPoints.length - 1] <= 1.0f) {
                this.colors = colors;
                this.colorPoints = startPoints;
            }
        }
        return this;
    }

    public GradientVectorOverlayProvider radius(int radius) {
        if (radius < 18 || radius > 150) {
            return this;
        }
        this.radius = radius;
        return this;
    }

    public GradientVectorOverlayProvider setIntensityRange(float minIntensity, float maxIntensity) {
        if (minIntensity < maxIntensity && minIntensity >= 0.0f) {
            this.maxIntensity = maxIntensity;
            this.minIntensity = minIntensity;
            this.intensityFlag = true;
        } else {
            this.intensityFlag = false;
        }
        return this;
    }

    public GradientVectorOverlayProvider setMaxHeight(float height) {
        if (height >= 0.0f) {
            this.maxHeight = height;
        }
        return this;
    }

    public GradientVectorOverlayProvider enable3D(boolean enable3D) {
        this.draw3D = enable3D;
        return this;
    }

    public GradientVectorOverlayProvider setAnimateDuration(int animateDuration) {
        if (animateDuration == 0) {
            this.mAnimate = false;
            this.mAnimationDuration = 0;
        } else if (animateDuration > 0) {
            this.mAnimationDuration = animateDuration;
            this.mAnimate = true;
        }
        return this;
    }

    public List<WeightedLatLng> getData() {
        return this.dataList;
    }

    public float getMaxHeight() {
        return this.maxHeight;
    }

    public float getMaxIntensity() {
        return this.maxIntensity;
    }

    public float getMinIntensity() {
        return this.minIntensity;
    }

    public boolean isIntensityFlag() {
        return this.intensityFlag;
    }

    public int getRadius() {
        return this.radius;
    }

    public int[] getColors() {
        return this.colors;
    }

    public float[] getColorPoints() {
        return this.colorPoints;
    }

    public int getColorMapSize() {
        return this.colorMapSize;
    }

    public boolean isEnable3D() {
        return this.draw3D;
    }

    public boolean isAnimate() {
        return this.mAnimate;
    }

    public int getAnimateDuration() {
        return this.mAnimationDuration;
    }

    private static List<WeightedLatLng> wrapData(List<LatLng> data) {
        ArrayList<WeightedLatLng> weightedData = new ArrayList<WeightedLatLng>();
        for (LatLng l2 : data) {
            weightedData.add(new WeightedLatLng(l2));
        }
        return weightedData;
    }

    @Override
    public String toString() {
        return "GradientVectorOverlayProvider{dataList=" + this.dataList.size() + ", maxHeight=" + this.maxHeight + ", radius=" + this.radius + ", colors=" + Arrays.toString(this.colors) + ", colorPoints=" + Arrays.toString(this.colorPoints) + ", colorMapSize=" + this.colorMapSize + ", draw3D=" + this.draw3D + ", maxIntensity=" + this.maxIntensity + ", minIntensity=" + this.minIntensity + ", intensityFlag=" + this.intensityFlag + ", mAnimate=" + this.mAnimate + ", mAnimationDuration=" + this.mAnimationDuration + ", mOpacity=" + this.mOpacity + ", mVisibility=" + this.mVisibility + ", mMinZoom=" + this.mMinZoom + ", mMaxZoom=" + this.mMaxZoom + ", mDisplayLevel=" + this.mDisplayLevel + ", mZIndex=" + this.mZIndex + '}';
    }
}

