/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.sdk.utilities.visualization.trails;

import android.graphics.Color;
import com.tencent.map.sdk.utilities.visualization.BaseOverlayProvider;
import com.tencent.map.sdk.utilities.visualization.datamodels.TrailLatLng;
import java.util.ArrayList;
import java.util.List;

public final class TrailOverlayProvider
extends BaseOverlayProvider {
    private int mType = 0;
    private List<TrailLatLng> dataList = new ArrayList<TrailLatLng>();
    private final float DEFAULT_WIDTH = 6.0f;
    private float mWidth = 6.0f;
    private final int DEFAULT_HIGHLIGHT_DURATION = 1000;
    private final int DEFAULT_ANIMATE_START_TIME = 0;
    private final int DEFAULT_ANIMATE_END_TIME = 2000;
    private int mHighLightDuration = 1000;
    private int mAnimationStartTime = 0;
    private int mAnimatationEndTime = 2000;
    private final float DEFAULT_PLAY_RATIO = 1.0f;
    private float mPlayRatio = 1.0f;
    private int[] mColors = DEFAULT_GRADIENT_COLORS;
    private float[] mColorPoints = DEFAULT_GRADIENT_START_POINTS;
    protected int mColorMapSize = 200;
    private static final int[] DEFAULT_GRADIENT_COLORS = new int[]{Color.argb((int)255, (int)0, (int)128, (int)255), Color.argb((int)0, (int)0, (int)128, (int)255)};
    private static final float[] DEFAULT_GRADIENT_START_POINTS = new float[]{0.0f, 1.0f};
    private static final int DEFAULT_COLOR_MAP_SIZE = 200;

    public final TrailOverlayProvider type(TrailOverlayType type) {
        this.mType = type.ordinal();
        return this;
    }

    final TrailOverlayType getOverlayType() {
        return TrailOverlayType.values()[this.mType];
    }

    public final int getType() {
        return this.getOverlayType().ordinal();
    }

    public final List<TrailLatLng> getData() {
        return this.dataList;
    }

    public final TrailOverlayProvider data(List<TrailLatLng> val) {
        if (val != null) {
            this.dataList = val;
        }
        return this;
    }

    @Override
    public final float getOpacity() {
        return super.getOpacity();
    }

    @Override
    public final TrailOverlayProvider opacity(float opacity) {
        super.opacity(opacity);
        return this;
    }

    @Override
    public final int getZIndex() {
        return super.getZIndex();
    }

    @Override
    public final TrailOverlayProvider zIndex(int zIndex) {
        super.zIndex(zIndex);
        return this;
    }

    @Override
    public final int getDisplayLevel() {
        return super.getDisplayLevel();
    }

    @Override
    public final TrailOverlayProvider displayLevel(int displayLevel) {
        super.displayLevel(displayLevel);
        return this;
    }

    @Override
    public final boolean isVisibility() {
        return super.isVisibility();
    }

    @Override
    public final TrailOverlayProvider visibility(boolean visibility) {
        super.visibility(visibility);
        return this;
    }

    @Override
    public final int getMinZoom() {
        return super.getMinZoom();
    }

    @Override
    public final int getMaxZoom() {
        return super.getMaxZoom();
    }

    public final TrailOverlayProvider zoomRange(int minZoom, int maxZoom) {
        if (minZoom <= maxZoom) {
            super.minZoom(minZoom);
            super.maxZoom(maxZoom);
        }
        return this;
    }

    public final TrailOverlayProvider gradient(int[] colors) {
        if (colors != null) {
            if (colors.length == 1) {
                this.mColors = new int[]{colors[0], colors[0], colors[0]};
                this.mColorPoints = new float[]{0.0f, 0.5f, 1.0f};
            } else if (colors.length == 2) {
                this.mColors = colors;
                this.mColorPoints = new float[]{0.0f, 1.0f};
            } else if (colors.length == 3) {
                this.mColors = colors;
                this.mColorPoints = new float[]{0.0f, 0.5f, 1.0f};
            }
        }
        return this;
    }

    public final int[] getColors() {
        return this.mColors;
    }

    public final float[] getColorPoints() {
        return this.mColorPoints;
    }

    public final int getColorMapSize() {
        return this.mColorMapSize;
    }

    public final float getWidth() {
        return this.mWidth;
    }

    public final TrailOverlayProvider width(float width) {
        if (width > 0.0f) {
            this.mWidth = width;
        }
        return this;
    }

    public final TrailOverlayProvider setHighlightDuration(int highlightDuration) {
        if (highlightDuration > 0) {
            this.mHighLightDuration = highlightDuration;
        }
        return this;
    }

    public final int getHighLightDuration() {
        return this.mHighLightDuration;
    }

    public final TrailOverlayProvider setAnimateStartTime(int startTime, int endTime) {
        if (startTime < endTime && startTime >= 0) {
            this.mAnimationStartTime = startTime;
            this.mAnimatationEndTime = endTime;
        }
        return this;
    }

    public final int getAnimateStartTime() {
        return this.mAnimationStartTime;
    }

    public final int getAnimateEndTime() {
        return this.mAnimatationEndTime;
    }

    public final TrailOverlayProvider setPlayRatio(float playRatio) {
        if (playRatio > 0.0f) {
            this.mPlayRatio = playRatio;
        }
        return this;
    }

    public final float getPlayRatio() {
        return this.mPlayRatio;
    }

    public static enum TrailOverlayType {
        Trail;

    }
}

