/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.tencent.map.tools.Callback;
import com.tencent.map.tools.Condition;
import com.tencent.map.tools.ReturnCallback;
import com.tencent.mapsdk.internal.tb;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class Util {
    private static final boolean DEBUG = false;
    private static final String TAG = "Util";
    private static final int DEFAUlT_GlEsVersion = 65537;
    public static final int SMALL_SCREEN_THRESHOLD = 400;
    public static final String META_NAME_API_KEY = "TencentMapSDK";
    private static final String SUID_FILE_NAME = "txlbs_suid";
    private static final String SUID_KEY = "txlbs_key_suid";
    private static final String DUID_FILE_NAME = "txlbs_duid";
    private static final String DUID_KEY = "txlbs_key_duid";

    public static float getDensity(Context context) {
        if (context == null) {
            return 1.0f;
        }
        return context.getResources().getDisplayMetrics().density;
    }

    public static int getWindowWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getWindowHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static int getOpenglesVersion(Context context) {
        ConfigurationInfo info = ((ActivityManager)context.getSystemService("activity")).getDeviceConfigurationInfo();
        if (info != null) {
            return info.reqGlEsVersion;
        }
        return 65537;
    }

    public static String getAppVersion(Context context) {
        if (context == null) {
            return "";
        }
        String version = "";
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            String versionName = packageInfo.versionName;
            int versionCode = packageInfo.versionCode;
            version = versionName + versionCode;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return version;
    }

    public static String getMetaKey(Context context, String metaName) {
        if (context == null) {
            return "";
        }
        String strPackagename = context.getPackageName();
        ApplicationInfo appInfo = null;
        try {
            appInfo = context.getPackageManager().getApplicationInfo(strPackagename, 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        if (appInfo == null) {
            return "";
        }
        if (appInfo.metaData == null) {
            return "";
        }
        return appInfo.metaData.getString(metaName);
    }

    public static String getDuid(Context context) {
        if (context == null) {
            return "";
        }
        return Util.getDuidFromSharePrerences(context);
    }

    private static String getDuidFromSharePrerences(Context context) {
        String duid = Util.getSharePreference(context, DUID_FILE_NAME, DUID_KEY);
        if (TextUtils.isEmpty((CharSequence)duid)) {
            duid = tb.a(context);
            Util.saveSharePreference(context, DUID_FILE_NAME, DUID_KEY, duid);
        }
        return duid;
    }

    @SuppressLint(value={"HardwareIds", "MissingPermission"})
    public static String getSuid(Context context) {
        if (context == null) {
            return "";
        }
        return Util.getSuidFromSharePrerences(context);
    }

    private static String getSuidFromSharePrerences(Context context) {
        String suid = Util.getSharePreference(context, SUID_FILE_NAME, SUID_KEY);
        if (TextUtils.isEmpty((CharSequence)suid)) {
            suid = Util.getUUID();
            Util.saveSharePreference(context, SUID_FILE_NAME, SUID_KEY, suid);
        }
        return suid;
    }

    public static String getUUID() {
        String uuid;
        try {
            uuid = UUID.randomUUID().toString();
        }
        catch (Exception exception) {
            uuid = "" + System.currentTimeMillis();
        }
        return uuid;
    }

    public static String getSharePreference(Context context, String fileName, String key) {
        if (context == null) {
            return "";
        }
        return context.getSharedPreferences(fileName, 0).getString(key, "");
    }

    public static void saveSharePreference(Context context, String fileName, String key, String value) {
        if (context == null) {
            return;
        }
        SharedPreferences.Editor editor = context.getSharedPreferences(fileName, 0).edit();
        editor.putString(key, value);
        editor.apply();
    }

    public static String getRawAppName(Context context) {
        if (context == null) {
            return "";
        }
        PackageManager packageManager = context.getPackageManager();
        ApplicationInfo appInfo = null;
        try {
            appInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        CharSequence appName = "can't find app name";
        if (appInfo != null) {
            appName = appInfo.loadLabel(packageManager);
        }
        return appName.toString();
    }

    public static String getAppName(Context context) {
        String resAppName = Util.getRawAppName(context);
        try {
            resAppName = URLEncoder.encode(resAppName, "utf-8");
        }
        catch (Exception exception) {}
        return resAppName;
    }

    public static String getResolution(Context context) {
        if (context == null) {
            return "";
        }
        String resolution = "";
        try {
            DisplayMetrics dm2 = context.getResources().getDisplayMetrics();
            resolution = dm2.widthPixels + "*" + dm2.heightPixels;
        }
        catch (Exception exception) {}
        return resolution;
    }

    public static String filterBuilder(String ... values) {
        String filter = "";
        if (values != null) {
            filter = "category=";
            for (int i2 = 0; i2 < values.length; ++i2) {
                filter = i2 == 0 ? filter + values[i2] : filter + "," + values[i2];
            }
        }
        return filter;
    }

    public static <T> T newInstance(Class<T> clz, Object ... paramsObj) {
        if (clz == null || clz.isEnum() || clz.isInterface() || clz.isAnnotation() || clz.isArray()) {
            return null;
        }
        Constructor<?>[] constructors = clz.getDeclaredConstructors();
        for (int i2 = 0; i2 < constructors.length; ++i2) {
            if (!Util.isMatchClassTypes(constructors[i2].getParameterTypes(), paramsObj)) continue;
            try {
                constructors[i2].setAccessible(true);
                return (T)constructors[i2].newInstance(paramsObj);
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (InvocationTargetException e2) {
                throw new RuntimeException(e2.getTargetException());
            }
        }
        try {
            return clz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException e3) {
            throw new RuntimeException(e3);
        }
        return null;
    }

    private static boolean isMatchClassTypes(Class<?>[] classes, Object[] objects) {
        if (classes.length != objects.length) {
            return false;
        }
        int matchedCount = 0;
        for (int i2 = 0; i2 < classes.length; ++i2) {
            if (classes[i2] != objects[i2].getClass() && !classes[i2].isAssignableFrom(objects[i2].getClass())) continue;
            ++matchedCount;
        }
        return matchedCount == classes.length;
    }

    public static void setField(Object object, String fieldName, Object value) {
        if (object == null) {
            return;
        }
        try {
            Field field = Util.findField(object.getClass(), fieldName);
            if (field != null) {
                field.setAccessible(true);
                field.set(object, value);
            }
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
    }

    public static Object getField(Object object, String fieldName) {
        if (object == null) {
            return null;
        }
        try {
            Field field;
            Class cls = object.getClass();
            if (object instanceof Class) {
                cls = (Class)object;
            }
            if ((field = Util.findField(cls, fieldName)) != null) {
                field.setAccessible(true);
                return field.get(object);
            }
        }
        catch (IllegalAccessException illegalAccessException) {}
        return null;
    }

    public static Object invokeMethod(Object object, String methodName, Object ... parameters) {
        if (object == null) {
            return null;
        }
        Class[] classes = new Class[parameters.length];
        for (int i2 = 0; i2 < classes.length; ++i2) {
            classes[i2] = parameters[i2].getClass();
        }
        try {
            Method method = Util.findMethod(object.getClass(), methodName, classes);
            if (method != null) {
                method.setAccessible(true);
                return method.invoke(object, parameters);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException e2) {
            throw new RuntimeException(e2.getTargetException());
        }
        return null;
    }

    public static Object invokeMethod(Object object, String methodName, Class[] classes, Object[] parameters) {
        if (object == null) {
            return null;
        }
        try {
            Method method = Util.findMethod(object.getClass(), methodName, classes);
            if (method != null) {
                method.setAccessible(true);
                return method.invoke(object, parameters);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException e2) {
            throw new RuntimeException(e2.getTargetException());
        }
        return null;
    }

    public static Object invokeStaticMethod(Class clazz, String methodName, Class[] classes, Object[] parameters) {
        if (clazz == null) {
            return null;
        }
        try {
            Method method = Util.findMethod(clazz, methodName, classes);
            if (method != null) {
                method.setAccessible(true);
                return method.invoke((Object)clazz, parameters);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException e2) {
            throw new RuntimeException(e2.getTargetException());
        }
        return null;
    }

    public static Method findMethod(Class clz, String methodName, Class[] paramTypes) {
        Method method;
        block2: {
            method = null;
            try {
                method = clz.getDeclaredMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (clz.getSuperclass() == Object.class) break block2;
                method = Util.findMethod(clz.getSuperclass(), methodName, paramTypes);
            }
        }
        return method;
    }

    public static Field findField(Class clz, String fieldName) {
        Field field;
        block2: {
            field = null;
            try {
                field = clz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (clz.getSuperclass() == Object.class) break block2;
                field = Util.findField(clz.getSuperclass(), fieldName);
            }
        }
        return field;
    }

    public static Class findClass(String classPath, ClassLoader classLoader) {
        try {
            return Class.forName(classPath, false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static <T> Class<? extends T> findClass(String classPath, Class<T> parentClz, ClassLoader classLoader) {
        try {
            Class<?> c2 = Class.forName(classPath, false, classLoader);
            if (parentClz.isAssignableFrom(c2)) {
                return c2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return null;
    }

    public static String getMD5String(String s2) {
        if (TextUtils.isEmpty((CharSequence)s2)) {
            return "";
        }
        return Util.getMD5String(s2.getBytes());
    }

    public static String getMD5String(byte[] source) {
        String s2 = null;
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest md2 = MessageDigest.getInstance("MD5");
            md2.update(source);
            byte[] tmp = md2.digest();
            char[] str = new char[32];
            int k2 = 0;
            for (int i2 = 0; i2 < 16; ++i2) {
                byte byte0 = tmp[i2];
                str[k2++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k2++] = hexDigits[byte0 & 0xF];
            }
            s2 = new String(str);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return s2;
    }

    public static boolean equals(Object a2, Object b2) {
        return a2 == b2 || a2 != null && a2.equals(b2);
    }

    public static int hash(Object ... values) {
        return Arrays.hashCode(values);
    }

    public static <T> void foreach(Iterable<T> list, Callback<T> callback) {
        if (list == null || callback == null) {
            return;
        }
        for (T data : list) {
            callback.callback(data);
        }
    }

    public static <T> void foreach(T[] list, Callback<T> callback) {
        if (list == null || callback == null) {
            return;
        }
        T[] TArray = list;
        int n2 = list.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            T data = TArray[i2];
            callback.callback(data);
        }
    }

    public static <T> T singleWhere(Iterable<T> list, Condition<T> condition) {
        if (list == null || condition == null) {
            return null;
        }
        for (T data : list) {
            if (!((Boolean)condition.callback((Object)data)).booleanValue()) continue;
            return data;
        }
        return null;
    }

    public static <T> List<T> listWhere(Iterable<T> list, Condition<T> condition) {
        List newList = Collections.emptyList();
        if (list == null || condition == null) {
            return newList;
        }
        for (T data : list) {
            if (!((Boolean)condition.callback((Object)data)).booleanValue()) continue;
            newList.add(data);
        }
        return newList;
    }

    public static <T> boolean where(Iterable<T> list, ReturnCallback<Boolean, T> callback) {
        if (list == null || callback == null) {
            return false;
        }
        for (T data : list) {
            if (!callback.callback(data).booleanValue()) continue;
            return true;
        }
        callback.callback(null);
        return false;
    }

    public static <T> boolean where(T[] list, ReturnCallback<Boolean, T> callback) {
        if (list == null || callback == null) {
            return false;
        }
        T[] TArray = list;
        int n2 = list.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            T data = TArray[i2];
            if (!callback.callback(data).booleanValue()) continue;
            return true;
        }
        callback.callback(null);
        return false;
    }

    /*
     * Loose catch block
     */
    public static String getProcessName(int pid) {
        BufferedReader reader = null;
        reader = new BufferedReader(new FileReader("/proc/" + pid + "/cmdline"));
        String processName = reader.readLine();
        if (!TextUtils.isEmpty((CharSequence)processName)) {
            processName = processName.trim();
        }
        String string = processName;
        try {
            reader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
        catch (Throwable throwable) {
            try {
                throwable.printStackTrace();
            }
            catch (Throwable throwable2) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable2;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }
}

