/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools.json;

import android.os.Build;
import android.text.TextUtils;
import com.tencent.map.tools.Util;
import com.tencent.map.tools.json.FieldNameStyle;
import com.tencent.map.tools.json.JsonEncoder;
import com.tencent.map.tools.json.JsonParser;
import com.tencent.map.tools.json.JsonUtils;
import com.tencent.map.tools.json.annotation.Json;
import com.tencent.map.tools.json.annotation.JsonType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class JsonComposer
implements JsonEncoder,
JsonParser {
    private static Map<Class, Map<Field, String>> sClassJsonMap = new ConcurrentHashMap<Class, Map<Field, String>>();
    private Map<Field, String> mJsonFields;
    private FieldNameStyle mFieldNameStyle = FieldNameStyle.HUMP;
    private boolean mAllowEmpty = true;
    private String mFieldNamePrefix;
    private Map<Field, JsonParser.Deserializer> mFieldDeserializer = new HashMap<Field, JsonParser.Deserializer>();
    private Map<Class, JsonParser.Deserializer> mClassDeserializer = new HashMap<Class, JsonParser.Deserializer>();

    @Override
    public JSONObject toJson() {
        this.checkJsonComposerElements();
        Set<Map.Entry<Field, String>> entries = this.mJsonFields.entrySet();
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<Field, String> entry : entries) {
            Field field = entry.getKey();
            field.setAccessible(true);
            Class<?> cls = field.getType();
            Object value = null;
            try {
                value = field.get(this);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            if (this.onEachItemToJson(jsonObject, entry.getValue(), value)) continue;
            if (Collection.class.isAssignableFrom(cls)) {
                try {
                    Collection collection = (Collection)field.get(this);
                    JSONArray array = new JSONArray();
                    if (collection != null && !collection.isEmpty()) {
                        for (Object o2 : collection) {
                            if (!(o2 instanceof JsonEncoder)) continue;
                            array.put((Object)JsonUtils.modelToJson(o2));
                        }
                    }
                    jsonObject.put(entry.getValue(), this.mAllowEmpty || collection != null && !collection.isEmpty() ? array : null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                continue;
            }
            try {
                Object o3 = field.get(this);
                if (o3 instanceof Double) {
                    jsonObject.put(entry.getValue(), ((Double)o3).doubleValue());
                    continue;
                }
                if (o3 instanceof Long) {
                    jsonObject.put(entry.getValue(), ((Long)o3).longValue());
                    continue;
                }
                if (o3 instanceof Integer) {
                    jsonObject.put(entry.getValue(), ((Integer)o3).intValue());
                    continue;
                }
                if (o3 instanceof Boolean) {
                    jsonObject.put(entry.getValue(), ((Boolean)o3).booleanValue());
                    continue;
                }
                if (o3 instanceof JsonEncoder) {
                    jsonObject.put(entry.getValue(), (Object)JsonUtils.modelToJson(o3));
                    continue;
                }
                if (o3 != null && o3.getClass().isArray()) {
                    if (Build.VERSION.SDK_INT >= 19) {
                        jsonObject.put(entry.getValue(), (Object)new JSONArray(o3));
                        continue;
                    }
                    int length = Array.getLength(o3);
                    JSONArray array = new JSONArray();
                    for (int i2 = 0; i2 < length; ++i2) {
                        array.put(i2, Array.get(o3, i2));
                    }
                    jsonObject.put(entry.getValue(), (Object)array);
                    continue;
                }
                jsonObject.put(entry.getValue(), o3 == null && this.mAllowEmpty ? new JSONObject() : o3);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return jsonObject;
    }

    protected boolean onEachItemToJson(JSONObject jsonObject, String key, Object value) {
        return false;
    }

    protected boolean onEachItemParse(String key, Object value) {
        return false;
    }

    @Override
    public void parse(JSONObject jsonObject) {
        this.checkJsonComposerElements();
        JsonParser.Deserializer classDeserializer = this.mClassDeserializer.get(this.getClass());
        if (classDeserializer != null) {
            try {
                JsonComposer jsonComposer = this;
                classDeserializer.deserialize(jsonComposer, jsonComposer.getClass().getName(), jsonObject);
                return;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        for (Map.Entry<Field, String> entry : this.mJsonFields.entrySet()) {
            Field field = entry.getKey();
            field.setAccessible(true);
            Class<?> fieldClass = field.getType();
            Object obj = jsonObject.opt(entry.getValue());
            JsonParser.Deserializer deserializer = this.mFieldDeserializer.get(field);
            if (deserializer != null) {
                try {
                    Object o2 = deserializer.deserialize(this, entry.getValue(), obj);
                    field.set(this, o2);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.onEachItemParse(entry.getValue(), obj)) continue;
            if (obj instanceof JSONArray) {
                Type type = field.getGenericType();
                if (type instanceof ParameterizedType) {
                    String nestClassName = this.pickString(type.toString());
                    try {
                        Class nestClass;
                        if (TextUtils.isEmpty((CharSequence)nestClassName) || (nestClass = Util.findClass(nestClassName, this.getClass().getClassLoader())) == null) continue;
                        AbstractCollection collection = null;
                        if (Set.class.isAssignableFrom(field.getType())) {
                            collection = JsonUtils.parseTo(HashSet.class, (JSONArray)obj, nestClass, new Object[0]);
                        } else if (List.class.isAssignableFrom(field.getType())) {
                            collection = JsonUtils.parseTo(ArrayList.class, (JSONArray)obj, nestClass, new Object[0]);
                        }
                        field.set(this, collection);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        illegalAccessException.printStackTrace();
                    }
                    continue;
                }
                if (!((Class)type).isArray()) continue;
                Class<?> arrayType = ((Class)type).getComponentType();
                Object classes = JsonUtils.parseToArray((JSONArray)obj, arrayType);
                try {
                    field.set(this, classes);
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                continue;
            }
            if (obj instanceof JSONObject) {
                Object value = JsonUtils.parseToModel((JSONObject)obj, field.getType(), new Object[0]);
                try {
                    field.set(this, value);
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                continue;
            }
            if (fieldClass == String.class) {
                try {
                    field.set(this, String.valueOf(obj));
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                continue;
            }
            try {
                if (fieldClass == Boolean.TYPE) {
                    if (obj instanceof Boolean) {
                        field.setBoolean(this, (Boolean)obj);
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    if (obj.equals("false")) {
                        field.setBoolean(this, false);
                        continue;
                    }
                    if (!obj.equals("true")) continue;
                    field.setBoolean(this, true);
                    continue;
                }
                if (fieldClass == Byte.TYPE) {
                    if (obj instanceof Byte) {
                        field.setByte(this, (Byte)obj);
                        continue;
                    }
                    if (!(obj instanceof Number)) continue;
                    field.setByte(this, ((Number)obj).byteValue());
                    continue;
                }
                if (fieldClass == Character.TYPE) {
                    if (obj instanceof Character) {
                        field.setChar(this, ((Character)obj).charValue());
                        continue;
                    }
                    if (!(obj instanceof Integer)) continue;
                    if (Character.isLetter((Integer)obj)) {
                        field.setChar(this, Character.toChars((Integer)obj)[0]);
                        continue;
                    }
                    if (10 <= (Integer)obj || (Integer)obj < 0) continue;
                    field.setChar(this, Character.forDigit((Integer)obj, 10));
                    continue;
                }
                if (fieldClass == Double.TYPE) {
                    if (obj instanceof Number) {
                        field.setDouble(this, ((Number)obj).doubleValue());
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    field.setDouble(this, Double.parseDouble((String)obj));
                    continue;
                }
                if (fieldClass == Float.TYPE) {
                    if (obj instanceof Number) {
                        field.setFloat(this, ((Number)obj).floatValue());
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    field.setFloat(this, Float.parseFloat((String)obj));
                    continue;
                }
                if (fieldClass == Integer.TYPE) {
                    if (obj instanceof Number) {
                        field.setInt(this, ((Number)obj).intValue());
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    field.setInt(this, Integer.parseInt((String)obj));
                    continue;
                }
                if (fieldClass == Long.TYPE) {
                    if (obj instanceof Number) {
                        field.setLong(this, ((Number)obj).longValue());
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    field.setLong(this, Long.parseLong((String)obj));
                    continue;
                }
                if (fieldClass == Short.TYPE) {
                    if (obj instanceof Number) {
                        field.setShort(this, ((Number)obj).shortValue());
                        continue;
                    }
                    if (!(obj instanceof String)) continue;
                    field.setShort(this, Short.parseShort((String)obj));
                    continue;
                }
                if (obj == null) continue;
                field.set(this, obj);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private String pickString(String target) {
        block4: {
            String className;
            while (true) {
                if (TextUtils.isEmpty((CharSequence)target)) {
                    return target;
                }
                String start = "<";
                String end = ">";
                int startIndex = target.indexOf(start);
                int endIndex = target.lastIndexOf(end);
                if (startIndex < 0) {
                    startIndex = 0;
                }
                if (endIndex < 0) {
                    endIndex = target.length();
                }
                if (endIndex <= startIndex) break block4;
                className = target.substring(startIndex + 1, endIndex);
                if (!className.contains(start) || !className.contains(end)) break;
                target = className;
            }
            return className;
        }
        return target;
    }

    private synchronized void checkJsonComposerElements() {
        JsonType jsonTypeAnnotation = this.getClass().getAnnotation(JsonType.class);
        if (jsonTypeAnnotation != null) {
            this.mAllowEmpty = jsonTypeAnnotation.allowEmpty();
            this.mFieldNameStyle = jsonTypeAnnotation.fieldNameStyle();
            this.mFieldNamePrefix = jsonTypeAnnotation.fieldNamePrefix();
            Class<? extends JsonParser.Deserializer> deserializerClass = jsonTypeAnnotation.deserializer();
            if (deserializerClass != JsonParser.Deserializer.class) {
                JsonParser.Deserializer deserializerObj = Util.newInstance(deserializerClass, new Object[0]);
                this.mClassDeserializer.put(this.getClass(), deserializerObj);
            }
        }
        this.mJsonFields = sClassJsonMap.get(this.getClass());
        Collection<Object> fields = new ArrayList();
        if (this.mJsonFields == null) {
            this.mJsonFields = new ConcurrentHashMap<Field, String>();
            for (Class<?> c2 = this.getClass(); c2 != JsonComposer.class; c2 = c2.getSuperclass()) {
                fields.addAll(Arrays.asList(c2.getDeclaredFields()));
            }
            sClassJsonMap.put(this.getClass(), this.mJsonFields);
        } else {
            fields = this.mJsonFields.keySet();
        }
        for (Field field : fields) {
            Json jsonAnnotation;
            Class<? extends JsonParser.Deserializer> deserializerClass;
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
            JsonType fieldJsonTypeAnnotation = field.getType().getAnnotation(JsonType.class);
            if (fieldJsonTypeAnnotation != null && (deserializerClass = fieldJsonTypeAnnotation.deserializer()) != JsonParser.Deserializer.class) {
                JsonParser.Deserializer deserializerObj = Util.newInstance(deserializerClass, new Object[0]);
                this.mFieldDeserializer.put(field, deserializerObj);
            }
            if ((jsonAnnotation = field.getAnnotation(Json.class)) != null) {
                Class<? extends JsonParser.Deserializer> deserializerClass2;
                if (!jsonAnnotation.ignore()) {
                    if (TextUtils.isEmpty((CharSequence)jsonAnnotation.name())) {
                        this.mJsonFields.put(field, this.translateFieldName(field.getName()));
                    } else {
                        this.mJsonFields.put(field, jsonAnnotation.name());
                    }
                }
                if ((deserializerClass2 = jsonAnnotation.deserializer()) == JsonParser.Deserializer.class) continue;
                JsonParser.Deserializer deserializerObj = Util.newInstance(deserializerClass2, new Object[0]);
                this.mFieldDeserializer.put(field, deserializerObj);
                continue;
            }
            if (field.getName().contains("this")) continue;
            this.mJsonFields.put(field, this.translateFieldName(field.getName()));
        }
    }

    private String translateFieldName(String name) {
        if (this.mFieldNamePrefix != null && name.startsWith(this.mFieldNamePrefix)) {
            String firstChar = name.substring(this.mFieldNamePrefix.length(), this.mFieldNamePrefix.length() + 1);
            String nextChars = name.substring(this.mFieldNamePrefix.length() + 1);
            name = firstChar.toLowerCase() + nextChars;
        }
        if (this.mFieldNameStyle == FieldNameStyle.UNDERLINE) {
            Matcher matcher = Pattern.compile("[A-Z]").matcher(name);
            StringBuffer sb2 = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb2, "_" + matcher.group(0).toLowerCase());
            }
            matcher.appendTail(sb2);
            return sb2.toString();
        }
        return name;
    }

    protected Object getFieldValueByJsonName(String param) throws IllegalAccessException {
        if (this.mJsonFields != null) {
            for (Map.Entry<Field, String> entry : this.mJsonFields.entrySet()) {
                if (!entry.getValue().equals(param)) continue;
                return entry.getKey().get(this);
            }
        }
        return null;
    }
}

