/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools.net;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.map.tools.net.AdapterType;
import com.tencent.map.tools.net.NetAdapter;
import com.tencent.map.tools.net.NetConfig;
import com.tencent.map.tools.net.NetRequest;
import com.tencent.map.tools.net.NetResponse;
import com.tencent.map.tools.net.adapter.URLNetImpl;
import com.tencent.map.tools.net.http.HttpCanceler;
import com.tencent.mapsdk.core.utils.log.LogUtil;
import com.tencent.mapsdk.internal.lr;
import com.tencent.mapsdk.internal.md;
import com.tencent.tencentmap.mapsdk.maps.model.LocationRegion;
import java.util.HashMap;
import java.util.HashSet;

public class NetManager {
    private NetAdapter mAdapter;
    private boolean mInited = false;
    private boolean mGlobalForceHttps = true;
    private String mGlobalSecretKey;
    private final HashMap<String, String> mGlobalNetFlowRuleList = new HashMap();
    private final HashSet<Class<? extends md>> mGlobalNetFlowProcessorClzList = new HashSet();
    private final LocationRegion.LocationRegionChangedListener thisRegionChangedListener = new LocationRegion.LocationRegionChangedListener(){

        @Override
        public final void onLocationRegionChanged(LocationRegion prev, LocationRegion cur) {
            LogUtil.b("LOCATOR", "onLocationRegionChanged prev:" + prev + " cur:" + cur);
            NetManager.this.thisLocationRegion = cur;
        }
    };
    private LocationRegion thisLocationRegion;
    private static NetManager sInstance;

    public static synchronized NetManager getInstance() {
        if (sInstance == null) {
            sInstance = new NetManager();
        }
        return sInstance;
    }

    private NetManager() {
    }

    static NetAdapter createAdapter(Context context, NetConfig config) {
        if (config == null) {
            config = NetConfig.create().setForceHttps(true).setAdapterType(AdapterType.URL);
        }
        config.getAdapterType().ordinal();
        lr netAdapter = new lr();
        netAdapter.initNet(context, config);
        return netAdapter;
    }

    public LocationRegion.LocationRegionChangedListener getRegionChangedListener() {
        return this.thisRegionChangedListener;
    }

    public boolean available() {
        return this.mAdapter != null && this.mInited;
    }

    public void setAdapter(Context context, NetAdapter adapter) {
        if (adapter instanceof URLNetImpl) {
            ((URLNetImpl)adapter).setProxyAdapter(NetManager.createAdapter(context, NetConfig.create()));
        }
        this.setAdapter(adapter);
    }

    void setAdapter(NetAdapter adapter) {
        if (adapter == null) {
            return;
        }
        if (this.mAdapter != adapter) {
            this.mInited = false;
            if (this.mAdapter != null) {
                adapter.getNetFlowRuleList().putAll(this.mAdapter.getNetFlowRuleList());
            }
            this.mAdapter = adapter;
            this.init();
        }
    }

    public static void init(Context context, NetConfig config) {
        NetAdapter adapter = NetManager.createAdapter(context, config);
        NetManager.getInstance().setAdapter(adapter);
    }

    private void init() {
        if (this.mInited || this.mAdapter == null) {
            return;
        }
        this.mInited = true;
        this.thisLocationRegion = null;
        this.mGlobalForceHttps = this.mAdapter.isForceHttps();
        this.mGlobalSecretKey = this.mAdapter.getSecretKey();
        this.mGlobalNetFlowRuleList.putAll(this.mAdapter.getNetFlowRuleList());
        this.mGlobalNetFlowProcessorClzList.addAll(this.mAdapter.getNetFlowProcessor());
    }

    public NetRequest.NetRequestBuilder builder() {
        return this.builder("");
    }

    public NetRequest.NetRequestBuilder builder(String secretKey) {
        if (TextUtils.isEmpty((CharSequence)secretKey)) {
            secretKey = this.mGlobalSecretKey;
        }
        NetRequest.NetRequestBuilder builder = new NetRequest.NetRequestBuilder(this.mAdapter, secretKey, this.thisLocationRegion);
        builder.forceHttps(this.mGlobalForceHttps);
        return builder;
    }

    private NetRequest.NetRequestBuilder builder(NetRequest request) {
        return new NetRequest.NetRequestBuilder(this.mAdapter, this.mGlobalSecretKey, this.thisLocationRegion, request);
    }

    public NetResponse doGet(String url, String userAgent, int retryMethod, int timeOut, HashMap<String, String> mapHeaders, HttpCanceler canceler) {
        return this.builder().url(url).retryNum(retryMethod).header(mapHeaders).userAgent(userAgent).timeOut(timeOut).canceler(canceler).doGet();
    }

    public NetResponse doPost(String url, String userAgent, byte[] postData, int retryMethod, int timeout, HashMap<String, String> mapHeaders, HttpCanceler canceler) {
        return this.builder().url(url).userAgent(userAgent).postData(postData).retryNum(retryMethod).header(mapHeaders).timeOut(timeout).canceler(canceler).doPost();
    }

    public NetResponse doRequest(NetRequest request) {
        return this.builder(request).doRequest();
    }

    public NetResponse doStream(NetRequest request) {
        return this.builder(request).doStream();
    }

    public void appendNetFlowRules(HashMap<String, String> rules) {
        if (this.mAdapter != null) {
            this.mAdapter.getNetFlowRuleList().putAll(rules);
        }
    }
}

