/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools.orientation;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.view.OrientationEventListener;
import com.tencent.map.tools.orientation.OrientationListener;
import java.util.ArrayList;
import java.util.List;

public class OrientationManager
extends OrientationEventListener
implements SensorEventListener {
    private List<OrientationListener> mListeners = new ArrayList<OrientationListener>();
    private int mOrientation;
    private float mLastAngle;
    private Context contextObj = null;
    private static final float THRESHOLD = 1.0E-6f;

    public OrientationManager(Context context) {
        super(context, 3);
        this.contextObj = context;
    }

    public void destroy() {
        this.mListeners.clear();
        try {
            this.disable();
            SensorManager sensorManager = (SensorManager)this.contextObj.getSystemService("sensor");
            if (!sensorManager.getSensorList(11).isEmpty()) {
                sensorManager.unregisterListener((SensorEventListener)this);
            }
        }
        catch (Exception exception) {}
        this.contextObj = null;
    }

    public void addOrientationListener(OrientationListener listener) {
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
            if (this.mListeners.size() == 1) {
                try {
                    this.enable();
                    SensorManager sensorManager = (SensorManager)this.contextObj.getSystemService("sensor");
                    List sensor = sensorManager.getSensorList(11);
                    if (!sensor.isEmpty()) {
                        sensorManager.registerListener((SensorEventListener)this, (Sensor)sensor.get(0), 2);
                    }
                    return;
                }
                catch (Exception exception) {}
            }
        }
    }

    public void removeOrientationListener(OrientationListener listener) {
        if (this.mListeners.contains(listener)) {
            this.mListeners.remove(listener);
            if (this.mListeners.isEmpty()) {
                try {
                    this.disable();
                    SensorManager sensorManager = (SensorManager)this.contextObj.getSystemService("sensor");
                    if (!sensorManager.getSensorList(11).isEmpty()) {
                        sensorManager.unregisterListener((SensorEventListener)this);
                    }
                    return;
                }
                catch (Exception exception) {}
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == 11) {
            float[] rotationMatrix = new float[16];
            float[] orientation = new float[3];
            SensorManager.getRotationMatrixFromVector((float[])rotationMatrix, (float[])event.values);
            SensorManager.getOrientation((float[])rotationMatrix, (float[])orientation);
            float a2 = (float)Math.toDegrees(orientation[0]);
            float y2 = (float)Math.toDegrees(orientation[1]);
            float z2 = (float)Math.toDegrees(orientation[2]);
            if (Math.abs(a2) <= 1.0E-6f) {
                return;
            }
            if (Math.abs(this.mLastAngle - a2) > 30.0f) {
                this.mLastAngle = a2;
                return;
            }
            this.mLastAngle = a2 = (a2 + this.mLastAngle) / 2.0f;
            boolean viewStat = false;
            try {
                if (this.contextObj.getResources().getConfiguration().orientation == 2) {
                    viewStat = true;
                }
            }
            catch (Exception exception) {
                viewStat = false;
            }
            int o2 = this.mOrientation;
            if (viewStat) {
                if (o2 > 45 && o2 <= 135) {
                    a2 = (a2 + 270.0f) % 360.0f;
                } else if (o2 > 135 && o2 <= 225) {
                    a2 = (a2 + 180.0f) % 360.0f;
                } else if (o2 > 225 && o2 < 315) {
                    a2 = (a2 + 90.0f) % 360.0f;
                }
            }
            try {
                ArrayList<OrientationListener> temp = new ArrayList<OrientationListener>();
                temp.addAll(this.mListeners);
                for (OrientationListener listener : temp) {
                    if (listener == null) continue;
                    listener.onOrientationChanged(a2, y2, z2);
                }
                return;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
    }

    public void onOrientationChanged(int orientation) {
        if (orientation >= 0) {
            this.mOrientation = orientation;
        }
    }
}

