/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps;

import android.graphics.Point;
import com.tencent.tencentmap.mapsdk.maps.CameraUpdate;
import com.tencent.tencentmap.mapsdk.maps.model.CamerParameter;
import com.tencent.tencentmap.mapsdk.maps.model.CameraPosition;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import com.tencent.tencentmap.mapsdk.maps.model.LatLngBounds;
import java.util.ArrayList;

public final class CameraUpdateFactory {
    private CameraUpdateFactory() {
    }

    public static CameraUpdate zoomIn() {
        CamerParameter camerPara = new CamerParameter();
        new CamerParameter().iCamerType = CamerParameter.ZOOMIN;
        return new CameraUpdate(camerPara);
    }

    public static CameraUpdate zoomOut() {
        CamerParameter camerPara = new CamerParameter();
        new CamerParameter().iCamerType = CamerParameter.ZOOMOUT;
        return new CameraUpdate(camerPara);
    }

    public static CameraUpdate scrollBy(float xPixel, float yPixel) {
        CamerParameter camerPara = new CamerParameter();
        new CamerParameter().iCamerType = CamerParameter.SCROLLBY;
        camerPara.scrollBy_xPixel = xPixel;
        camerPara.scrollBy_yPixel = yPixel;
        return new CameraUpdate(camerPara);
    }

    public static CameraUpdate zoomTo(float zoomLevel) {
        CamerParameter camerPara = new CamerParameter();
        new CamerParameter().iCamerType = CamerParameter.ZOOMTO;
        camerPara.zoomTo_zoom = zoomLevel;
        return new CameraUpdate(camerPara);
    }

    public static CameraUpdate zoomBy(float zoomLevelDelta) {
        CamerParameter camerPara = new CamerParameter();
        new CamerParameter().iCamerType = CamerParameter.ZOOMBY;
        camerPara.zoomBy_amount = zoomLevelDelta;
        return new CameraUpdate(camerPara);
    }

    public static CameraUpdate zoomBy(float zoomLevelDelta, Point point) {
        CamerParameter camerPara = new CamerParameter();
        new CamerParameter().iCamerType = CamerParameter.ZOOMBY_POINT;
        camerPara.zoomBy_Point_amount = zoomLevelDelta;
        camerPara.zoomBy_Point_focus = point;
        return new CameraUpdate(camerPara);
    }

    public static CameraUpdate newCameraPosition(CameraPosition cameraposition) {
        CamerParameter camerPara = new CamerParameter();
        new CamerParameter().iCamerType = CamerParameter.NEWCAMER_POSITION;
        camerPara.newCameraPosition_cameraPosition = cameraposition;
        return new CameraUpdate(camerPara);
    }

    public static CameraUpdate newLatLng(LatLng latlng) {
        CamerParameter camerPara = new CamerParameter();
        new CamerParameter().iCamerType = CamerParameter.NEWLATLNG;
        camerPara.newLatLng_latLng = latlng;
        return new CameraUpdate(camerPara);
    }

    public static CameraUpdate newLatLngZoom(LatLng latlng, float zoom) {
        CamerParameter camerPara = new CamerParameter();
        new CamerParameter().iCamerType = CamerParameter.NEWLATLNG_ZOOM;
        camerPara.newLatLngZoom_latLng = latlng;
        camerPara.newLatLngZoom_zoom = zoom;
        return new CameraUpdate(camerPara);
    }

    public static CameraUpdate newLatLngBounds(LatLngBounds latlngbounds, int padding) {
        CamerParameter camerPara = new CamerParameter();
        new CamerParameter().iCamerType = CamerParameter.NEWLATLNG_BOUNDS;
        camerPara.newLatLngBounds_bounds = latlngbounds;
        camerPara.newLatLngBounds_padding = padding;
        return new CameraUpdate(camerPara);
    }

    public static CameraUpdate newLatLngBoundsRect(LatLngBounds latlngbounds, int leftPadding, int rightPadding, int topPadding, int bottomPadding) {
        CamerParameter camerPara = new CamerParameter();
        new CamerParameter().iCamerType = CamerParameter.NEWLATLNG_BOUNDS_RECT;
        camerPara.newLatLngBounds_dimension_bounds = latlngbounds;
        camerPara.newLatLngBoundsRects_padLeft = leftPadding;
        camerPara.newLatLngBoundsRects_padRight = rightPadding;
        camerPara.newLatLngBoundsRects_padTop = topPadding;
        camerPara.newLatLngBoundsRects_padBom = bottomPadding;
        return new CameraUpdate(camerPara);
    }

    public static CameraUpdate rotateTo(float rotate, float skew) {
        CamerParameter camerPara = new CamerParameter();
        new CamerParameter().iCamerType = CamerParameter.ROTATETO;
        camerPara.rotateto_rotate = rotate;
        camerPara.rotateto_skew = skew;
        return new CameraUpdate(camerPara);
    }

    public static CameraUpdate newLatLngBoundsWithMapCenter(LatLngBounds latLngBounds, LatLng mapCenter, int padding) {
        if (latLngBounds == null) {
            return null;
        }
        LatLng northEast = latLngBounds.northeast;
        LatLng symmetricNorthEast = CameraUpdateFactory.getSymmetricPoint(mapCenter, northEast);
        LatLng southWest = latLngBounds.southwest;
        LatLng symmetricSouthWest = CameraUpdateFactory.getSymmetricPoint(mapCenter, southWest);
        ArrayList<LatLng> boundPoints = new ArrayList<LatLng>();
        boundPoints.add(northEast);
        boundPoints.add(symmetricNorthEast);
        boundPoints.add(southWest);
        boundPoints.add(symmetricSouthWest);
        return CameraUpdateFactory.newLatLngBounds(new LatLngBounds.Builder().include(boundPoints).build(), padding);
    }

    private static LatLng getSymmetricPoint(LatLng center, LatLng processPoint) {
        double symmetricLat = 2.0 * center.latitude - processPoint.latitude;
        double symmetricLon = 2.0 * center.longitude - processPoint.longitude;
        return new LatLng(symmetricLat, symmetricLon);
    }
}

