/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps;

import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import com.tencent.mapsdk.core.utils.log.LogUtil;
import com.tencent.tencentmap.mapsdk.maps.LocationSource;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class CustomLocationProvider {
    public static final String NAME = "_CustomAutoLocationProvider";
    private final Map<WeakReference<a>, Boolean> thisWeakRefLocationObservers = new ConcurrentHashMap<WeakReference<a>, Boolean>();
    private Location thisLatestLocation;
    private WeakReference<MyLocationSource> thisMyLocationSourceWeakReference;
    private Handler thisRequestHandler = new Handler(Looper.getMainLooper());
    private static CustomLocationProvider sGlobalLocationProvider;

    private CustomLocationProvider() {
    }

    public static CustomLocationProvider getInstance() {
        if (sGlobalLocationProvider == null) {
            sGlobalLocationProvider = new CustomLocationProvider();
        }
        return sGlobalLocationProvider;
    }

    public final LocationSource getLocationSource() {
        return new b(this);
    }

    public final void setMyLocationSource(MyLocationSource myLocationSource) {
        this.setMyLocationSource(null, myLocationSource);
    }

    public final void setMyLocationSource(Handler requestHandler, MyLocationSource myLocationSource) {
        LogUtil.c("LOCATOR", "setMyLocationSource");
        if (requestHandler != null) {
            this.thisRequestHandler = requestHandler;
        }
        this.thisMyLocationSourceWeakReference = new WeakReference<MyLocationSource>(myLocationSource);
    }

    public final void requestLatestLocation() {
        if (this.thisMyLocationSourceWeakReference != null) {
            LogUtil.c("LOCATOR", "requestLatestLocation");
            final MyLocationSource myLocationSource = (MyLocationSource)this.thisMyLocationSourceWeakReference.get();
            if (myLocationSource != null) {
                this.thisRequestHandler.post(new Runnable(){

                    @Override
                    public final void run() {
                        CustomLocationProvider.this.thisLatestLocation = myLocationSource.getMyLocation();
                        Iterator iterator = CustomLocationProvider.this.thisWeakRefLocationObservers.keySet().iterator();
                        while (iterator.hasNext()) {
                            a observer = (a)((WeakReference)iterator.next()).get();
                            if (observer == null) continue;
                            observer.a(CustomLocationProvider.this.thisLatestLocation);
                        }
                    }
                });
            }
        }
    }

    public final synchronized Location getLatestLocation() {
        return this.thisLatestLocation;
    }

    public final synchronized void clearLocation() {
        this.thisLatestLocation = null;
    }

    public final synchronized boolean hasLocation() {
        return this.thisLatestLocation != null;
    }

    public final boolean hasLocationSource() {
        return this.thisMyLocationSourceWeakReference != null && this.thisMyLocationSourceWeakReference.get() != null;
    }

    private void addLocationObserver(a observer) {
        if (observer == null) {
            return;
        }
        this.thisWeakRefLocationObservers.put(new WeakReference<a>(observer), Boolean.TRUE);
        if (this.thisLatestLocation != null) {
            observer.a(this.thisLatestLocation);
        }
    }

    private void removeLocationObserver(a observer) {
        if (observer == null) {
            return;
        }
        Iterator<WeakReference<a>> iter = this.thisWeakRefLocationObservers.keySet().iterator();
        while (iter.hasNext()) {
            if (iter.next().get() != observer) continue;
            iter.remove();
        }
    }

    static interface a {
        public void a(Location var1);
    }

    public static interface MyLocationSource {
        public Location getMyLocation();
    }

    static final class b
    implements a,
    LocationSource {
        LocationSource.OnLocationChangedListener a;
        private final CustomLocationProvider b;
        private final Handler c = new Handler(Looper.getMainLooper());

        public b(CustomLocationProvider customLocationProvider) {
            this.b = customLocationProvider;
        }

        @Override
        public final void activate(LocationSource.OnLocationChangedListener onlocationchangedlistener) {
            this.a = onlocationchangedlistener;
            this.b.addLocationObserver(this);
        }

        @Override
        public final void deactivate() {
            this.b.removeLocationObserver(this);
            this.a = null;
        }

        @Override
        public final void a(final Location location) {
            if (location == null) {
                return;
            }
            final LocationSource.OnLocationChangedListener listener = this.a;
            if (listener != null) {
                this.c.post(new Runnable(){

                    @Override
                    public final void run() {
                        location.setProvider(location.getProvider() + CustomLocationProvider.NAME);
                        listener.onLocationChanged(location);
                    }
                });
            }
        }
    }
}

