/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.tencent.map.tools.Callback;
import com.tencent.mapsdk.internal.t;
import com.tencent.mapsdk.internal.u;
import com.tencent.tencentmap.mapsdk.maps.BaseMapView;
import com.tencent.tencentmap.mapsdk.maps.TencentMap;
import com.tencent.tencentmap.mapsdk.maps.TencentMapInitializer;
import com.tencent.tencentmap.mapsdk.maps.TencentMapOptions;

public class MapView
extends BaseMapView {
    protected BaseMapView.MapViewProxy mMapDelegate;
    private TencentMapOptions mMapOptions;
    private TencentMap mMap;
    private boolean mIsResumed;

    public MapView(@NonNull Context context) {
        this(context, new TencentMapOptions());
    }

    public MapView(@NonNull Context context, TencentMapOptions options) {
        super(context);
        this.mMap = this.getMap(options);
    }

    public MapView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, new TencentMapOptions());
    }

    public MapView(@NonNull Context context, @Nullable AttributeSet attrs, TencentMapOptions options) {
        this(context, attrs, 0, options);
    }

    public MapView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, new TencentMapOptions());
    }

    public MapView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, TencentMapOptions options) {
        super(context, attrs, defStyleAttr);
        this.mMap = this.getMap(options);
    }

    private void initMap(TencentMapOptions options) {
        if (this.mMap != null && (this.mMapOptions == options || this.mMapOptions.equals(options))) {
            return;
        }
        if (options == null) {
            options = new TencentMapOptions();
        }
        if (options.getMapViewType() == null) {
            options.setMapViewType(this.getViewType());
        }
        if (options.getMapKernel() == null) {
            options.setMapKernel(this.getMapKernel());
        }
        this.setClickable(true);
        if (this.mMap != null && this.mMapDelegate != null) {
            this.mMapDelegate.onPause();
            this.mMapDelegate.onStop();
            this.mMapDelegate.onDestroy();
            this.mMapDelegate = null;
            this.mMap = null;
        }
        final Callback<TencentMap> mapCallback = options.getMapAsyncCallback();
        if (this.mMapDelegate == null) {
            t wrapper = new t(this.getContext().getApplicationContext());
            if (mapCallback != null) {
                Callback<BaseMapView.MapViewProxy> callback = new Callback<BaseMapView.MapViewProxy>(){

                    private void a(BaseMapView.MapViewProxy result) {
                        MapView.this.mMapDelegate = result;
                        if (result != null) {
                            MapView.this.mMapDelegate.onResume();
                            mapCallback.callback(result.getMap());
                        }
                    }

                    @Override
                    public final /* synthetic */ void callback(Object object) {
                        BaseMapView.MapViewProxy mapViewProxy = (BaseMapView.MapViewProxy)object;
                        1 var2_3 = this;
                        MapView.this.mMapDelegate = mapViewProxy;
                        if (mapViewProxy != null) {
                            var2_3.MapView.this.mMapDelegate.onResume();
                            var2_3.mapCallback.callback(mapViewProxy.getMap());
                        }
                    }
                };
                TencentMapOptions tencentMapOptions = options;
                MapView mapView = this;
                t t2 = wrapper;
                Callback<Void> callback2 = new Callback<Void>(t2, (ViewGroup)mapView, tencentMapOptions, (Callback)callback){
                    final /* synthetic */ ViewGroup a;
                    final /* synthetic */ TencentMapOptions b;
                    final /* synthetic */ Callback c;
                    final /* synthetic */ t d;
                    {
                        this.d = this$0;
                        this.a = viewGroup;
                        this.b = tencentMapOptions;
                        this.c = callback;
                    }

                    private void a() {
                        BaseMapView.MapViewProxy mViewProxyImpl = this.d.a(u.a().b, this.a, this.b);
                        if (this.c != null) {
                            this.c.callback(mViewProxyImpl);
                        }
                    }

                    public final /* synthetic */ void callback(Object object) {
                        t.1 var2_2 = this;
                        BaseMapView.MapViewProxy mapViewProxy = var2_2.d.a(u.a().b, var2_2.a, var2_2.b);
                        if (var2_2.c != null) {
                            var2_2.c.callback(mapViewProxy);
                        }
                    }
                };
                String string = t2.a(tencentMapOptions);
                Context context = t2.a;
                u u2 = u.a();
                Handler handler = new Handler(Looper.getMainLooper());
                new Thread(new Runnable(u2, context, string, handler, callback2){
                    final /* synthetic */ Context a;
                    final /* synthetic */ String b;
                    final /* synthetic */ Handler c;
                    final /* synthetic */ Callback d;
                    final /* synthetic */ u e;
                    {
                        this.e = this$0;
                        this.a = context;
                        this.b = string;
                        this.c = handler;
                        this.d = callback;
                    }

                    public final void run() {
                        this.e.init(this.a, this.b);
                        this.c.post(new Runnable(this){
                            final /* synthetic */ u.4 a;
                            {
                                this.a = this$1;
                            }

                            public final void run() {
                                if (this.a.d != null) {
                                    this.a.d.callback(null);
                                }
                            }
                        });
                    }
                }, "tms-plugin").start();
            } else {
                TencentMapOptions tencentMapOptions = options;
                MapView mapView = this;
                t t3 = wrapper;
                u.a().init(t3.a, t3.a(tencentMapOptions));
                this.mMapDelegate = t3.a(u.a().b, (ViewGroup)mapView, tencentMapOptions);
            }
        }
        this.mMapOptions = options;
    }

    @Override
    public TencentMap getMap() {
        if (this.mMap != null) {
            return this.mMap;
        }
        MapView mapView = this;
        return mapView.getMap(mapView.mMapOptions);
    }

    @Override
    public TencentMap getMap(TencentMapOptions options) {
        if (TencentMapInitializer.getAgreePrivacy()) {
            this.initMap(options);
            if (this.mMapDelegate != null) {
                return this.mMapDelegate.getMap();
            }
        }
        return null;
    }

    private <T extends TencentMap> void getMapSync(TencentMapOptions options, final Callback<T> callback) {
        options.setGetMapAsync(new Callback<TencentMap>(){

            private void a(TencentMap result) {
                result.addOnMapLoadedCallback(new TencentMap.OnMapLoadedCallback(result){
                    final /* synthetic */ TencentMap a;
                    {
                        this.a = tencentMap;
                    }

                    @Override
                    public final void onMapLoaded() {
                        if (callback != null) {
                            callback.callback(this.a);
                        }
                        this.a.removeOnMapLoadedCallback(this);
                    }
                });
            }

            @Override
            public final /* synthetic */ void callback(Object object) {
                TencentMap tencentMap = (TencentMap)object;
                2 var2_3 = this;
                tencentMap.addOnMapLoadedCallback(new /* invalid duplicate definition of identical inner class */);
            }
        });
        this.initMap(options);
    }

    public boolean dispatchTouchEvent(MotionEvent ev2) {
        boolean result = super.dispatchTouchEvent(ev2);
        if (!result && this.mMapDelegate != null && this.mMapDelegate.isTouchable()) {
            ViewParent parent = this.getParent();
            if (parent != null) {
                parent.requestDisallowInterceptTouchEvent(this.mMapOptions.isDisallowInterceptTouchEvent());
            }
            return this.mMapDelegate.onTouchEvent(ev2);
        }
        return result;
    }

    public final boolean onTouchEvent(MotionEvent event) {
        return false;
    }

    @Override
    public void onStart() {
        if (this.mMapDelegate != null) {
            this.mMapDelegate.onStart();
        }
        if (this.mMapDelegate != null && !this.mIsResumed) {
            this.mMapDelegate.onResume();
            this.mIsResumed = true;
        }
    }

    @Override
    public void onResume() {
        if (this.mMapDelegate != null && !this.mIsResumed) {
            this.mMapDelegate.onResume();
            this.mIsResumed = true;
        }
        u.a().onResumeReport();
    }

    @Override
    public void onPause() {
        if (this.mMapDelegate != null) {
            this.mMapDelegate.onPause();
            this.mIsResumed = false;
        }
    }

    @Override
    public void onRestart() {
        if (this.mMapDelegate != null) {
            this.mMapDelegate.onRestart();
        }
    }

    @Override
    public void onStop() {
        if (this.mMapDelegate != null) {
            this.mMapDelegate.onStop();
        }
        u.a().close();
    }

    @Override
    public void onDestroy() {
        if (this.mMapDelegate != null) {
            this.mMapDelegate.onDestroy();
            this.mMapDelegate = null;
        }
        this.mMapOptions = null;
        this.mMap = null;
    }

    public void setOnTop(boolean isOnTop) {
        if (this.mMapDelegate != null) {
            this.mMapDelegate.setOnTop(isOnTop);
        }
    }

    public void setMapPadding(int left, int top, int right, int bottom) {
        this.setPadding(left, top, right, bottom);
    }

    public int[] getMapPadding() {
        return new int[]{this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom()};
    }

    public void onSizeChanged(int w2, int h2, int oldw, int oldh) {
        super.onSizeChanged(w2, h2, oldw, oldh);
        if (this.mMapDelegate != null) {
            this.mMapDelegate.onSizeChanged(w2, h2, oldw, oldh);
        }
    }

    public void onSurfaceChanged(Object surfaceTexture, int width, int height) {
        if (!(surfaceTexture instanceof Surface || surfaceTexture instanceof SurfaceTexture || surfaceTexture instanceof SurfaceHolder)) {
            return;
        }
        if (this.mMapDelegate != null) {
            this.mMapDelegate.onSurfaceChanged(surfaceTexture, width, height);
        }
    }

    static {
        System.loadLibrary("txmapengine");
    }
}

