/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.mapsdk.core.utils.log.LogUtil;
import com.tencent.mapsdk.internal.ht;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class TencentMapInitializer {
    private static final Map<String, String> EXTRA_MAP = new ConcurrentHashMap<String, String>();
    public static final String KEY_AGREE_PRIVACY = "privacy";

    public static synchronized void setAgreePrivacy(boolean isAgree) {
        EXTRA_MAP.put(KEY_AGREE_PRIVACY, String.valueOf(isAgree));
    }

    public static synchronized boolean getAgreePrivacy() {
        boolean agreePrivacy = TencentMapInitializer.isAgreePrivacy();
        if (!agreePrivacy) {
            LogUtil.d("\u8bf7\u8bbe\u7f6e\u540c\u610f\u9690\u79c1\u534f\u8bae, \u9700\u8981\u5728\u521d\u59cb\u5316\u5730\u56fe\u4e4b\u524d\u5b8c\u6210");
        }
        return agreePrivacy;
    }

    public static synchronized String getDuid(Context context) {
        if (TencentMapInitializer.isAgreePrivacy()) {
            return ht.g(context);
        }
        return "undefined";
    }

    public static synchronized String getSuid(Context context) {
        if (TencentMapInitializer.isAgreePrivacy()) {
            return ht.f(context);
        }
        return "undefined";
    }

    public static synchronized void addExtra(String key, String value) {
        if (KEY_AGREE_PRIVACY.equals(key) && !TextUtils.isEmpty((CharSequence)value)) {
            EXTRA_MAP.put(KEY_AGREE_PRIVACY, value);
            return;
        }
        if (!TencentMapInitializer.isAgreePrivacy()) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)key) && !TextUtils.isEmpty((CharSequence)value)) {
            EXTRA_MAP.put(key, value);
            ht.a(key, value);
        }
    }

    public static synchronized String getExtra(String key) {
        if (!TencentMapInitializer.isAgreePrivacy() || TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        return EXTRA_MAP.get(key);
    }

    private static boolean isAgreePrivacy() {
        return Boolean.parseBoolean(EXTRA_MAP.get(KEY_AGREE_PRIVACY));
    }
}

