/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import com.tencent.tencentmap.mapsdk.maps.model.LatLng;

public final class CameraPosition {
    public LatLng target;
    public final float zoom;
    public final float tilt;
    public final float bearing;

    CameraPosition(int i2, LatLng latlng, float fzoom, float ftilt, float fbearing) {
        this.target = latlng;
        this.zoom = fzoom;
        this.tilt = ftilt;
        this.bearing = fbearing;
    }

    CameraPosition(double lat, double lng, float scale, float rotate, float skew) {
        this(new LatLng(lat, lng), scale, skew, rotate);
    }

    public CameraPosition(LatLng latlng, float zoomLevel, float skew, float rotate) {
        this(1, latlng, zoomLevel, skew, rotate);
    }

    public static final CameraPosition fromLatLngZoom(LatLng latlng, float zoomLevel) {
        return new CameraPosition(latlng, zoomLevel, 0.0f, 0.0f);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(CameraPosition cameraposition) {
        return new Builder(cameraposition);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CameraPosition)) {
            return false;
        }
        CameraPosition cameraposition = (CameraPosition)obj;
        return this.target.equals(cameraposition.target) && Float.floatToIntBits(this.zoom) == Float.floatToIntBits(cameraposition.zoom) && Float.floatToIntBits(this.tilt) == Float.floatToIntBits(cameraposition.tilt) && Float.floatToIntBits(this.bearing) == Float.floatToIntBits(cameraposition.bearing);
    }

    public final String toString() {
        return "latlng:" + this.target.latitude + "," + this.target.longitude + ",zoom:" + this.zoom + ",tilt=" + this.tilt + ",bearing:" + this.bearing;
    }

    public static final class Builder {
        private LatLng p;
        private float q;
        private float r = Float.MIN_VALUE;
        private float s = Float.MIN_VALUE;

        public final Builder target(LatLng latlng) {
            this.p = latlng;
            return this;
        }

        public final Builder zoom(float zoomLevel) {
            this.q = zoomLevel;
            return this;
        }

        public final Builder tilt(float skew) {
            this.r = skew;
            return this;
        }

        public final Builder bearing(float rotate) {
            this.s = rotate;
            return this;
        }

        public final CameraPosition build() {
            return new CameraPosition(this.p, this.q, this.r, this.s);
        }

        public Builder() {
        }

        public Builder(CameraPosition cameraposition) {
            CameraPosition cameraposition1 = cameraposition;
            this.p = cameraposition1.target;
            this.q = cameraposition1.zoom;
            this.r = cameraposition1.tilt;
            this.s = cameraposition1.bearing;
        }
    }
}

