/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.LinearInterpolator;
import com.tencent.tencentmap.mapsdk.maps.model.IAnimatorModel;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import com.tencent.tencentmap.mapsdk.maps.model.RotateAnimationController;
import com.tencent.tencentmap.mapsdk.maps.model.transform.OverlayAnimator;
import com.tencent.tencentmap.mapsdk.maps.model.transform.Point;
import com.tencent.tencentmap.mapsdk.maps.model.transform.SphericalMercatorProjection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GeneralTranslateAnimator
extends OverlayAnimator {
    private final IAnimatorModel mAnimatorModel;
    private LatLng[] mLatLngs;
    private double[] mDistances;
    private double mSumDistance;
    private SphericalMercatorProjection mEarthMercatorProjection;
    private RotateAnimationController mRotateAnimationController;
    private List<IAnimatorModel.IAnimatorEndListener> mAnimatorEndListeners;

    public GeneralTranslateAnimator(Builder builder) {
        super(builder.animatorModel, builder.duration);
        int i2;
        this.mAnimatorModel = builder.animatorModel;
        if (builder.latLngs == null || builder.latLngs.length <= 0 || builder.duration < 0L) {
            return;
        }
        this.mLatLngs = builder.latLngs;
        this.mAnimatorEndListeners = new ArrayList<IAnimatorModel.IAnimatorEndListener>();
        this.mEarthMercatorProjection = new SphericalMercatorProjection();
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        this.mDistances = new double[this.mLatLngs.length - 1];
        for (i2 = 0; i2 < this.mLatLngs.length - 1; ++i2) {
            this.mDistances[i2] = this.mEarthMercatorProjection.distanceBetween(this.mLatLngs[i2], this.mLatLngs[i2 + 1]);
            this.mSumDistance += this.mDistances[i2];
        }
        for (i2 = 0; i2 < this.mLatLngs.length - 1; ++i2) {
            animators.add(this.createSegmentAnimator(i2));
        }
        this.getAnimatorSet().playSequentially(animators);
        this.mRotateAnimationController = new RotateAnimationController(builder.animatorModel, builder.duration, builder.modelType, builder.rotateEnabled, builder.initRotate, this.mLatLngs, this.mDistances, this.mSumDistance, this.mEarthMercatorProjection);
    }

    @Override
    public ValueAnimator createSegmentAnimator(final int segmentIndex) {
        final Point fromMercator = this.mEarthMercatorProjection.toPoint(this.mLatLngs[segmentIndex]);
        final Point toMercator = this.mEarthMercatorProjection.toPoint(this.mLatLngs[segmentIndex + 1]);
        ValueAnimator animator = new ValueAnimator();
        animator.setDuration((long)((double)this.getDuration() * this.mDistances[segmentIndex] / this.mSumDistance));
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.setFloatValues(new float[]{(float)this.mDistances[segmentIndex]});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator animation) {
                if (fromMercator.equals(toMercator)) {
                    return;
                }
                double currentDistance = Double.parseDouble(String.valueOf(animation.getAnimatedValue()));
                double x2 = fromMercator.x + (toMercator.x - fromMercator.x) * currentDistance / GeneralTranslateAnimator.this.mDistances[segmentIndex];
                double y2 = fromMercator.y + (toMercator.y - fromMercator.y) * currentDistance / GeneralTranslateAnimator.this.mDistances[segmentIndex];
                if (GeneralTranslateAnimator.this.mAnimatorModel == null) {
                    return;
                }
                GeneralTranslateAnimator.this.mAnimatorModel.setPosition(GeneralTranslateAnimator.this.mEarthMercatorProjection.toLatLng(new Point(x2, y2)));
            }
        });
        return animator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAnimation() {
        super.startAnimation();
        if (this.mRotateAnimationController == null) {
            return;
        }
        GeneralTranslateAnimator generalTranslateAnimator = this;
        synchronized (generalTranslateAnimator) {
            this.mRotateAnimationController.startAnimation();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAnimation() {
        super.cancelAnimation();
        if (this.mRotateAnimationController == null) {
            return;
        }
        GeneralTranslateAnimator generalTranslateAnimator = this;
        synchronized (generalTranslateAnimator) {
            this.mRotateAnimationController.cancelAnimation();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endAnimation() {
        super.endAnimation();
        if (this.mRotateAnimationController == null) {
            return;
        }
        GeneralTranslateAnimator generalTranslateAnimator = this;
        synchronized (generalTranslateAnimator) {
            this.mRotateAnimationController.endAnimation();
            return;
        }
    }

    @Override
    public void innerAnimationEnd() {
        if (this.mAnimatorEndListeners == null) {
            return;
        }
        Iterator<IAnimatorModel.IAnimatorEndListener> iterator = this.mAnimatorEndListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onAnimatorEnd();
        }
    }

    public void addAnimatorEndListener(IAnimatorModel.IAnimatorEndListener listener) {
        if (this.mAnimatorEndListeners == null) {
            return;
        }
        if (!this.mAnimatorEndListeners.contains(listener) && listener != null) {
            this.mAnimatorEndListeners.add(listener);
            this.addAnimationListener();
        }
    }

    public void removeAnimatorEndListener(IAnimatorModel.IAnimatorEndListener listener) {
        if (this.mAnimatorEndListeners == null) {
            return;
        }
        this.mAnimatorEndListeners.remove(listener);
        this.removeAnimationListener();
    }

    public static enum ModelType {
        MARKER_OVERLAY,
        MODEL_OVERLAY;

    }

    public static class Builder {
        private final IAnimatorModel animatorModel;
        private final long duration;
        private final LatLng[] latLngs;
        private boolean rotateEnabled = false;
        private float initRotate = 0.0f;
        private ModelType modelType = ModelType.MARKER_OVERLAY;

        public Builder(IAnimatorModel animatorModel, long duration, LatLng[] latLngs) {
            this.animatorModel = animatorModel;
            this.duration = duration;
            this.latLngs = latLngs;
        }

        public Builder rotateEnabled(boolean enable) {
            this.rotateEnabled = enable;
            return this;
        }

        public Builder initRotate(float initRotate) {
            this.initRotate = initRotate;
            return this;
        }

        public Builder modelType(ModelType modelType) {
            this.modelType = modelType;
            return this;
        }

        public GeneralTranslateAnimator build() {
            return new GeneralTranslateAnimator(this);
        }
    }
}

