/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.tencent.mapsdk.core.utils.log.LogUtil;
import com.tencent.tencentmap.mapsdk.maps.interfaces.Coordinate;

public class LatLng
implements Parcelable,
Coordinate {
    public static final Parcelable.Creator<LatLng> CREATOR = new Parcelable.Creator<LatLng>(){

        private static LatLng a(@NonNull Parcel in2) {
            return new LatLng(in2);
        }

        private static LatLng[] a(int size) {
            return new LatLng[size];
        }

        public final /* synthetic */ Object createFromParcel(@NonNull Parcel parcel) {
            Parcel parcel2 = parcel;
            return new LatLng(parcel2);
        }
    };
    public double latitude;
    public double longitude;
    public double altitude = 0.0;
    private boolean throwException = false;

    public LatLng() {
        this.latitude = 0.0;
        this.longitude = 0.0;
    }

    public LatLng(double latitude, double longitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
    }

    public LatLng(double latitude, double longitude, double altitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
        this.setAltitude(altitude);
    }

    public LatLng(double latitude, double longitude, double altitude, boolean throwException) {
        this.doThrowException(latitude, longitude, altitude, throwException);
    }

    public LatLng(Location location) {
        this(location.getLatitude(), location.getLongitude(), location.getAltitude());
    }

    public LatLng(LatLng latLng) {
        this.latitude = latLng.latitude;
        this.longitude = latLng.longitude;
        this.altitude = latLng.altitude;
        this.throwException = latLng.throwException;
    }

    public LatLng(Parcel in2) {
        double latitude = in2.readDouble();
        double longitude = in2.readDouble();
        double altitude = in2.readDouble();
        boolean throwException = in2.readByte() != 0;
        this.doThrowException(latitude, longitude, altitude, throwException);
    }

    private void doThrowException(double latitude, double longitude, double altitude, boolean throwException) {
        this.throwException = throwException;
        if (throwException) {
            this.setLatitudeThrowException(latitude);
            this.setLongitudeThrowException(longitude);
        } else {
            this.setLatitude(latitude);
            this.setLongitude(longitude);
        }
        this.setAltitude(altitude);
    }

    public static Builder newBuilder() {
        return new Builder(null, false);
    }

    public static Builder newBuilder(LatLng latLng) {
        return new Builder(latLng, false);
    }

    public static Builder newBuilderThrowException() {
        return new Builder(null, true);
    }

    public static Builder newBuilderThrowException(LatLng latLng) {
        return new Builder(latLng, true);
    }

    public boolean isThrowException() {
        return this.throwException;
    }

    public void setLatitude(@FloatRange(from=-90.0, to=90.0) double latitude) {
        if (Double.isNaN(latitude)) {
            LogUtil.d("latitude must not be NaN");
            return;
        }
        if (Math.abs(latitude) > 90.0) {
            LogUtil.d("latitude must be between -90 and 90");
            return;
        }
        this.latitude = latitude;
    }

    public void setLatitudeThrowException(@FloatRange(from=-90.0, to=90.0) double latitude) {
        if (Double.isNaN(latitude)) {
            throw new IllegalArgumentException("latitude must not be NaN");
        }
        if (Math.abs(latitude) > 90.0) {
            throw new IllegalArgumentException("latitude must be between -90 and 90");
        }
        this.latitude = latitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLongitude(@FloatRange(from=-1.7976931348623157E308, to=1.7976931348623157E308) double longitude) {
        if (Double.isNaN(longitude)) {
            LogUtil.d("longitude must not be NaN");
            return;
        }
        if (Double.isInfinite(longitude)) {
            LogUtil.d("longitude must not be infinite");
            return;
        }
        this.longitude = longitude;
    }

    public void setLongitudeThrowException(@FloatRange(from=-1.7976931348623157E308, to=1.7976931348623157E308) double longitude) {
        if (Double.isNaN(longitude)) {
            throw new IllegalArgumentException("longitude must not be NaN");
        }
        if (Double.isInfinite(longitude)) {
            throw new IllegalArgumentException("longitude must not be infinite");
        }
        this.longitude = longitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public double getAltitude() {
        return this.altitude;
    }

    @NonNull
    public LatLng wrap() {
        return new LatLng(this.latitude, LatLng.wrap(this.longitude, -180.0, 180.0));
    }

    static double wrap(double value, double min, double max) {
        double delta = max - min;
        double secondMod = ((value - min) % delta + delta) % delta;
        if (value >= max && secondMod == 0.0) {
            return max;
        }
        return secondMod + min;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LatLng latLng = (LatLng)object;
        return Double.compare(latLng.altitude, this.altitude) == 0 && Double.compare(latLng.latitude, this.latitude) == 0 && Double.compare(latLng.longitude, this.longitude) == 0;
    }

    public int hashCode() {
        long temp;
        long l2 = Double.doubleToLongBits(this.latitude);
        int result = (int)(l2 ^ l2 >>> 32);
        long l3 = temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(l3 ^ l3 >>> 32);
        long l4 = temp = Double.doubleToLongBits(this.altitude);
        return 31 * result + (int)(l4 ^ l4 >>> 32);
    }

    @NonNull
    public String toString() {
        return "LatLng [latitude=" + this.latitude + ", longitude=" + this.longitude + ", altitude=" + this.altitude + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeDouble(this.latitude);
        out.writeDouble(this.longitude);
        out.writeDouble(this.altitude);
        out.writeByte((byte)(this.throwException ? 1 : 0));
    }

    @Override
    public double x() {
        return this.latitude;
    }

    @Override
    public double y() {
        return this.longitude;
    }

    @Override
    public double z() {
        return this.altitude;
    }

    @Override
    public void setX(double x2) {
        this.latitude = x2;
    }

    @Override
    public void setY(double y2) {
        this.longitude = y2;
    }

    @Override
    public void setZ(double z2) {
        this.altitude = z2;
    }

    public static class Builder {
        private double mLongitude;
        private double mLatitude;
        private double mAltitude;
        private final boolean mThrowException;

        public Builder(LatLng latLng, boolean throwException) {
            if (latLng != null) {
                this.mLongitude = latLng.getLongitude();
                this.mLatitude = latLng.getLatitude();
                this.mAltitude = latLng.getAltitude();
            }
            this.mThrowException = throwException;
        }

        public Builder setLongitude(double longitude) {
            this.mLongitude = longitude;
            return this;
        }

        public Builder setLatitude(double latitude) {
            this.mLatitude = latitude;
            return this;
        }

        public Builder setAltitude(double altitude) {
            this.mAltitude = altitude;
            return this;
        }

        public LatLng build() {
            return new LatLng(this.mLatitude, this.mLongitude, this.mAltitude, this.mThrowException);
        }
    }
}

