/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.LinearInterpolator;
import com.tencent.tencentmap.mapsdk.maps.model.GeneralTranslateAnimator;
import com.tencent.tencentmap.mapsdk.maps.model.IAnimatorModel;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import com.tencent.tencentmap.mapsdk.maps.model.transform.Point;
import com.tencent.tencentmap.mapsdk.maps.model.transform.SphericalMercatorProjection;
import java.util.ArrayList;

public class RotateAnimationController {
    private final boolean mRotateEnabled;
    private final float mInitRotate;
    private IAnimatorModel mAnimatorModel;
    private long mDuration;
    private GeneralTranslateAnimator.ModelType mModelType;
    private AnimatorSet mRotateAnimatorSet;
    private LatLng[] mLatLngs;
    private double[] mDistances;
    private double mSumDistance;
    private SphericalMercatorProjection mEarthMercatorProjection;
    private a mIValueAnimatorStrategy;

    public RotateAnimationController(IAnimatorModel animatorModel, long duration, GeneralTranslateAnimator.ModelType modelType, boolean rotateEnable, float initRotate, LatLng[] latLngs, double[] distances, double sumDistance, SphericalMercatorProjection projection) {
        this.mRotateEnabled = rotateEnable;
        this.mInitRotate = initRotate;
        if (!this.mRotateEnabled) {
            return;
        }
        this.mAnimatorModel = animatorModel;
        this.mDuration = duration;
        this.mModelType = modelType;
        this.mRotateAnimatorSet = new AnimatorSet();
        this.mLatLngs = latLngs;
        this.mDistances = distances;
        this.mSumDistance = sumDistance;
        this.mEarthMercatorProjection = projection;
        this.initValueAnimatorStrategy();
        this.initRotateAnimation();
    }

    private void initValueAnimatorStrategy() {
        this.mIValueAnimatorStrategy = new a(){

            @Override
            public final ValueAnimator a(float startAngle, float endAngle) {
                ValueAnimator animator;
                switch (RotateAnimationController.this.mModelType) {
                    case MODEL_OVERLAY: {
                        animator = ValueAnimator.ofFloat((float[])new float[]{-1.0f * startAngle, -1.0f * endAngle});
                        break;
                    }
                    default: {
                        animator = ValueAnimator.ofFloat((float[])new float[]{startAngle, endAngle});
                    }
                }
                return animator;
            }

            @Override
            public final double[] a() {
                double[] array = new double[2];
                RotateAnimationController.this.mModelType.ordinal();
                array[0] = 0.0;
                array[1] = 1.0;
                return array;
            }
        };
    }

    private void initRotateAnimation() {
        ArrayList<ValueAnimator> mRotateAnimators = new ArrayList<ValueAnimator>();
        long delay = 0L;
        int startIndex = 0;
        int lastTurnIndex = 0;
        float lastAngle = 0.0f;
        for (int i2 = 1; i2 < this.mLatLngs.length; ++i2) {
            long duration;
            if (this.mLatLngs[startIndex].equals(this.mLatLngs[i2])) continue;
            int endIndex = i2;
            Point m02 = this.mEarthMercatorProjection.toPoint(this.mLatLngs[lastTurnIndex]);
            Point m1 = this.mEarthMercatorProjection.toPoint(this.mLatLngs[startIndex]);
            Point m2 = this.mEarthMercatorProjection.toPoint(this.mLatLngs[endIndex]);
            float deltaAngle = (float)this.calculateAngle(m1.x - m02.x, m02.y - m1.y, m2.x - m1.x, m1.y - m2.y);
            if (mRotateAnimators.size() == 0) {
                if (this.mAnimatorModel == null) {
                    return;
                }
                lastAngle = this.mAnimatorModel.getRotation();
                double[] initVector = this.mIValueAnimatorStrategy.a();
                deltaAngle = (float)this.calculateAngle(initVector[0], initVector[1], m2.x - m1.x, m1.y - m2.y) - lastAngle;
                duration = 0L;
            } else {
                double turnDistance = (double)Math.abs(deltaAngle) * Math.PI * 6.0 / 180.0;
                duration = (long)((double)this.mDuration * turnDistance / this.mSumDistance);
                delay = this.calculateDelay(lastTurnIndex, startIndex) - duration / 2L;
            }
            float startAngle = lastAngle;
            float endAngle = startAngle + deltaAngle;
            mRotateAnimators.add(this.createRotateAnimator(startAngle, endAngle, duration, delay));
            lastAngle = endAngle;
            lastTurnIndex = startIndex;
            startIndex = endIndex;
        }
        this.mRotateAnimatorSet.playSequentially(mRotateAnimators);
    }

    private double calculateAngle(double x1, double y1, double x2, double y2) {
        double d2 = x1;
        double d3 = y1;
        double d4 = x2;
        double d5 = y2;
        double cosAlpha = (x1 * x2 + y1 * y2) / (Math.sqrt(d2 * d2 + d3 * d3) * Math.sqrt(d4 * d4 + d5 * d5));
        if (Double.isNaN(cosAlpha)) {
            return 0.0;
        }
        if (cosAlpha < -1.0) {
            cosAlpha = -1.0;
        }
        if (cosAlpha > 1.0) {
            cosAlpha = 1.0;
        }
        double angle = Math.acos(cosAlpha) * 180.0 / Math.PI;
        if (x1 * y2 - y1 * x2 > 0.0) {
            angle = -angle;
        }
        return (float)angle;
    }

    private long calculateDelay(int lastTurnIndex, int currentTurnIndex) {
        double d2 = 0.0;
        for (int i2 = lastTurnIndex; i2 < currentTurnIndex; ++i2) {
            d2 += this.mDistances[i2];
        }
        return (long)((double)this.mDuration * d2 / this.mSumDistance);
    }

    private ValueAnimator createRotateAnimator(float startAngle, float endAngle, long duration, long delay) {
        ValueAnimator animator = this.mIValueAnimatorStrategy.a(startAngle + this.mInitRotate, endAngle + this.mInitRotate);
        animator.setDuration(duration);
        animator.setStartDelay(delay);
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public final void onAnimationUpdate(ValueAnimator animation) {
                double currentAngle = Double.parseDouble(String.valueOf(animation.getAnimatedValue()));
                if (RotateAnimationController.this.mAnimatorModel == null) {
                    return;
                }
                RotateAnimationController.this.mAnimatorModel.setRotation((float)currentAngle);
            }
        });
        return animator;
    }

    public void startAnimation() {
        if (!this.mRotateEnabled) {
            return;
        }
        if (!this.mRotateAnimatorSet.isRunning()) {
            this.mRotateAnimatorSet.start();
        }
    }

    public void cancelAnimation() {
        if (!this.mRotateEnabled) {
            return;
        }
        this.mRotateAnimatorSet.cancel();
    }

    public void endAnimation() {
        if (!this.mRotateEnabled) {
            return;
        }
        this.mRotateAnimatorSet.end();
    }

    static interface a {
        public ValueAnimator a(float var1, float var2);

        public double[] a();
    }
}

