/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import com.tencent.tencentmap.mapsdk.maps.TencentMapContext;
import com.tencent.tencentmap.mapsdk.maps.model.TileProvider;

public final class TileOverlayOptions {
    public static final int MIN_DATA_LEVEL = 3;
    public static final int MAX_DATA_LEVEL = 22;
    private TileProvider mTileProvider;
    private volatile String mDiskCacheDir;
    private volatile String mVersionInfo;
    private int mZIndex = 1;
    private int mMinDataLevel = 3;
    private int mMaxDataLevel = 18;
    private int mMinVisibleLevel = 3;
    private int mMaxVisibleLevel = 18;
    private boolean mBetterQuality = true;
    private boolean mReuseTile = false;
    private int mMaxMemoryCacheSize;
    private int mLevelOffset;

    public final TileOverlayOptions tileProvider(TileProvider tileProvider) {
        this.mTileProvider = tileProvider;
        return this;
    }

    public final TileOverlayOptions diskCacheDir(String diskCacheDir) {
        this.mDiskCacheDir = diskCacheDir;
        return this;
    }

    public final TileOverlayOptions maxMemoryCacheSize(int maxMemoryCacheSize) {
        this.mMaxMemoryCacheSize = maxMemoryCacheSize;
        return this;
    }

    public final TileOverlayOptions versionInfo(String versionInfo) {
        this.mVersionInfo = versionInfo;
        return this;
    }

    public final TileOverlayOptions zIndex(int zindex) {
        this.mZIndex = zindex;
        return this;
    }

    public final TileOverlayOptions betterQuality(boolean betterQuality) {
        this.mBetterQuality = betterQuality;
        return this;
    }

    public final TileOverlayOptions reuseTile(boolean reuseTile) {
        this.mReuseTile = reuseTile;
        return this;
    }

    public final TileOverlayOptions dataLevelRange(int minLevel, int maxLevel) {
        if (minLevel >= 3 && minLevel <= Math.max(maxLevel, 22)) {
            this.mMinDataLevel = minLevel;
        }
        if (maxLevel <= 22 && maxLevel >= Math.max(3, minLevel)) {
            this.mMaxDataLevel = maxLevel;
        }
        return this;
    }

    public final TileOverlayOptions visibleLevelRange(int minLevel, int maxLevel) {
        if (minLevel >= 3 && minLevel <= Math.max(maxLevel, 22)) {
            this.mMinVisibleLevel = minLevel;
        }
        if (maxLevel <= 22 && maxLevel >= Math.max(3, minLevel)) {
            this.mMaxVisibleLevel = maxLevel;
        }
        return this;
    }

    public final TileOverlayOptions levelOffset(int offset) {
        if (offset < -2) {
            offset = -2;
        }
        if (offset > 2) {
            offset = 2;
        }
        this.mLevelOffset = offset;
        return this;
    }

    public final int getLevelOffset() {
        return this.mLevelOffset;
    }

    public final TileProvider getTileProvider() {
        return this.mTileProvider;
    }

    public final int getZIndex() {
        return this.mZIndex;
    }

    public final boolean isBetterQuality() {
        return this.mBetterQuality;
    }

    public final boolean isReuseTile() {
        return this.mReuseTile;
    }

    public final String getDiskCacheDir() {
        return this.mDiskCacheDir;
    }

    public final String getVersionInfo() {
        return this.mVersionInfo;
    }

    public final int getMaxMemoryCacheSize(TencentMapContext context) {
        if (this.mMaxMemoryCacheSize == 0) {
            return 4 * context.getScreenPixels();
        }
        return this.mMaxMemoryCacheSize;
    }

    public final int getMinDataLevel() {
        return this.mMinDataLevel;
    }

    public final int getMaxDataLevel() {
        return this.mMaxDataLevel;
    }

    public final int getMinVisibleLevel() {
        return this.mMinVisibleLevel;
    }

    public final int getMaxVisibleLevel() {
        return this.mMaxVisibleLevel;
    }

    public final String toString() {
        return "TileOverlayOptions{mTileProvider=" + this.mTileProvider + ", mDiskCacheDir='" + this.mDiskCacheDir + '\'' + ", mVersionInfo='" + this.mVersionInfo + '\'' + ", mZIndex=" + this.mZIndex + ", mMinDataLevel=" + this.mMinDataLevel + ", mMaxDataLevel=" + this.mMaxDataLevel + ", mBetterQuality=" + this.mBetterQuality + ", mReuseTile=" + this.mReuseTile + ", mMaxMemoryCacheSize=" + this.mMaxMemoryCacheSize + ", mLevelOffset=" + this.mLevelOffset + '}';
    }
}

