/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import com.tencent.map.tools.net.NetManager;
import com.tencent.map.tools.net.NetResponse;
import com.tencent.map.tools.net.exception.NetErrorException;
import com.tencent.tencentmap.mapsdk.maps.model.Tile;
import com.tencent.tencentmap.mapsdk.maps.model.TileProvider;
import java.net.URL;

public abstract class UrlTileProvider
implements TileProvider {
    private static final String TAG = "UrlTileProvider";
    private static final boolean DEBUG = false;
    private final int mWidth;
    private final int mHeight;

    public UrlTileProvider() {
        this(256, 256);
    }

    public UrlTileProvider(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public final Tile getTile(int x2, int y2, int zoom) {
        URL url = this.getTileUrl(x2, y2, zoom);
        Tile result = NO_TILE;
        if (url == null) {
            return result;
        }
        byte[] data = null;
        NetResponse response = this.requestTileData(url.toString());
        if (response != null) {
            if (response.available()) {
                data = response.data;
            } else {
                if (response.exception instanceof NetErrorException) {
                    if (response.statusCode == 404) {
                        return NO_TILE;
                    }
                    return new Tile(this.mWidth, this.mHeight, null);
                }
                if (response.statusCode == 404) {
                    return NO_TILE;
                }
                return new Tile(this.mWidth, this.mHeight, null);
            }
        }
        if (data != null && data.length != 0) {
            result = new Tile(this.mWidth, this.mHeight, data);
        }
        if (result.equals(NO_TILE)) {
            return Tile.EMPTY_TILE;
        }
        return result;
    }

    protected NetResponse requestTileData(String url) {
        NetResponse netResponse = null;
        try {
            netResponse = NetManager.getInstance().builder().url(url).doGet();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return netResponse;
    }

    public abstract URL getTileUrl(int var1, int var2, int var3);
}

