/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.storage;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.StatFs;
import android.text.TextUtils;
import com.tencent.mapsdk.internal.hs;
import com.tencent.mapsdk.internal.kt;
import java.io.File;

public class StorageManager {
    private Context mContext;
    private String mCustomCacheRootPath;
    private String mAppRootDir;
    private String mPrivateFileRootPath;
    private String mPrivateFilePath;
    private static final String ROOT_DIR = "/tencentmapsdk/";
    private static final String PRIVATE_ROOT_DIR = "/tencentMapSdk/";
    private static StorageManager mInstance;
    private static String[] mSharedPrefNames;
    private static String[] mPrivateFileNames;

    public static StorageManager getInstance(Context context, String customCacheRootPath) {
        if (mInstance == null) {
            mInstance = new StorageManager(context, customCacheRootPath);
        }
        return mInstance;
    }

    private StorageManager(Context context, String customCacheRootPath) {
        if (context == null) {
            throw new Error("context can not be null");
        }
        this.mContext = context.getApplicationContext();
        this.mCustomCacheRootPath = customCacheRootPath;
        this.updatePublicPath();
        this.updatePrivatePath();
    }

    public static void clearMapCache(Context context, String customCacheRootPath) {
        kt.f(StorageManager.getInstance(context, customCacheRootPath).getCacheDir());
        kt.f(StorageManager.getInstance(context, customCacheRootPath).getPrivateCacheDir());
        String[] stringArray = mPrivateFileNames;
        int n2 = mPrivateFileNames.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String fileName = stringArray[i2];
            kt.f(StorageManager.getInstance(context, customCacheRootPath).getPrivateCacheFileName(fileName));
        }
        StorageManager.removeAllPrefs(context);
    }

    public File getCacheDir() {
        return new File(this.mAppRootDir);
    }

    public static void removeAllPrefs(Context context) {
        try {
            File[] fileArr = new File(context.getFilesDir().getParent() + File.separator + "shared_prefs").listFiles();
            if (fileArr == null) {
                return;
            }
            File[] fileArray = fileArr;
            int n2 = fileArr.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                File file = fileArray[i2];
                String[] stringArray = mSharedPrefNames;
                int n3 = mSharedPrefNames.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    String prefName = stringArray[i3];
                    if (!file.getName().startsWith(prefName)) continue;
                    file.delete();
                }
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public File getPrivateCacheDir() {
        return new File(this.mPrivateFilePath);
    }

    public File getPrivateCacheFileName(String fileName) {
        return new File(this.mPrivateFileRootPath + File.separator + fileName);
    }

    private void updatePublicPath() {
        String strPath = this.getStorageRootPath();
        String packageName = kt.a(this.mContext);
        if (hs.a(packageName)) {
            this.mAppRootDir = strPath + ROOT_DIR;
            return;
        }
        this.mAppRootDir = strPath + ROOT_DIR + packageName;
    }

    private void updatePrivatePath() {
        this.mPrivateFileRootPath = this.mContext.getFilesDir().getAbsolutePath();
        this.mPrivateFilePath = this.mPrivateFileRootPath + PRIVATE_ROOT_DIR;
    }

    private String getStorageRootPath() {
        if (!TextUtils.isEmpty((CharSequence)this.mCustomCacheRootPath)) {
            return this.mCustomCacheRootPath;
        }
        Context context = this.mContext;
        String strSdkDirectory = StorageManager.getExternalStoragePath(context);
        if (StorageManager.getAvailableStorageSize(strSdkDirectory) < 5L && StorageManager.getAvailableStorageSize(strSdkDirectory = context.getFilesDir().getPath()) < 5L) {
            strSdkDirectory = StorageManager.getExternalStoragePath(context);
        }
        return strSdkDirectory;
    }

    private static String getExternalStoragePath(Context context) {
        File externalFile = context.getExternalFilesDir(null);
        if (externalFile != null) {
            return externalFile.getAbsolutePath();
        }
        return context.getFilesDir().getPath();
    }

    @SuppressLint(value={"NewApi"})
    private static long getAvailableStorageSize(String path) {
        try {
            long availBlocks;
            long blockSize;
            StatFs stfs = new StatFs(path);
            if (Build.VERSION.SDK_INT < 18) {
                blockSize = stfs.getBlockSize();
                availBlocks = stfs.getAvailableBlocks();
            } else {
                blockSize = stfs.getBlockSizeLong();
                availBlocks = stfs.getAvailableBlocksLong();
            }
            return blockSize * availBlocks / 1024L / 1024L;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    static {
        mSharedPrefNames = new String[]{"com.tencent.tencentmap.mapsdk.maps.offlinemap", "txlbs_suid", "txlbs_duid", "Tencent_MapSDK_SUB_CONFIG"};
        mPrivateFileNames = new String[]{"frontiers.dat"};
    }
}

