/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix;

import android.app.Application;
import android.content.Context;
import com.tencent.matrix.plugin.DefaultPluginListener;
import com.tencent.matrix.plugin.Plugin;
import com.tencent.matrix.plugin.PluginListener;
import com.tencent.matrix.util.MatrixLog;
import java.util.HashSet;

public class Matrix {
    private static final String TAG = "Matrix.Matrix";
    private static volatile Matrix sInstance;
    private final HashSet<Plugin> plugins;
    private final Application application;
    private final PluginListener pluginListener;

    private Matrix(Application app, PluginListener listener, HashSet<Plugin> plugins) {
        this.application = app;
        this.pluginListener = listener;
        this.plugins = plugins;
        for (Plugin plugin : plugins) {
            plugin.init(this.application, this.pluginListener);
            this.pluginListener.onInit(plugin);
        }
    }

    public static void setLogIml(MatrixLog.MatrixLogImp imp) {
        MatrixLog.setMatrixLogImp(imp);
    }

    public static boolean isInstalled() {
        return sInstance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Matrix init(Matrix matrix) {
        if (matrix == null) {
            throw new RuntimeException("Matrix init, Matrix should not be null.");
        }
        Class<Matrix> clazz = Matrix.class;
        synchronized (Matrix.class) {
            if (sInstance == null) {
                sInstance = matrix;
            } else {
                MatrixLog.e(TAG, "Matrix instance is already set. this invoking will be ignored", new Object[0]);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    public static Matrix with() {
        if (sInstance == null) {
            throw new RuntimeException("you must init Matrix sdk first");
        }
        return sInstance;
    }

    public void startAllPlugins() {
        for (Plugin plugin : this.plugins) {
            plugin.start();
        }
    }

    public void stopAllPlugins() {
        for (Plugin plugin : this.plugins) {
            plugin.stop();
        }
    }

    public void destroyAllPlugins() {
        for (Plugin plugin : this.plugins) {
            plugin.destroy();
        }
    }

    public Application getApplication() {
        return this.application;
    }

    public HashSet<Plugin> getPlugins() {
        return this.plugins;
    }

    public Plugin getPluginByTag(String tag) {
        for (Plugin plugin : this.plugins) {
            if (!plugin.getTag().equals(tag)) continue;
            return plugin;
        }
        return null;
    }

    public <T extends Plugin> T getPluginByClass(Class<T> pluginClass) {
        String className = pluginClass.getName();
        for (Plugin plugin : this.plugins) {
            if (!plugin.getClass().getName().equals(className)) continue;
            return (T)plugin;
        }
        return null;
    }

    public static class Builder {
        private final Application application;
        private PluginListener pluginListener;
        private HashSet<Plugin> plugins = new HashSet();

        public Builder(Application app) {
            if (app == null) {
                throw new RuntimeException("matrix init, application is null");
            }
            this.application = app;
        }

        public Builder plugin(Plugin plugin) {
            String tag = plugin.getTag();
            for (Plugin exist : this.plugins) {
                if (!tag.equals(exist.getTag())) continue;
                throw new RuntimeException(String.format("plugin with tag %s is already exist", tag));
            }
            this.plugins.add(plugin);
            return this;
        }

        public Builder patchListener(PluginListener pluginListener) {
            this.pluginListener = pluginListener;
            return this;
        }

        public Matrix build() {
            if (this.pluginListener == null) {
                this.pluginListener = new DefaultPluginListener((Context)this.application);
            }
            return new Matrix(this.application, this.pluginListener, this.plugins);
        }
    }
}

