/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.report;

import android.content.Context;
import android.content.SharedPreferences;
import com.tencent.matrix.report.IssuePublisher;
import com.tencent.matrix.util.MatrixUtil;
import java.util.HashMap;
import java.util.HashSet;

public class FilePublisher
extends IssuePublisher {
    private static final String TAG = "Matrix.FilePublisher";
    private final long expiredTime;
    private final SharedPreferences sharedPreferences;
    private final SharedPreferences.Editor editor;
    private final HashMap<String, Long> mPublishedMap;

    public FilePublisher(Context context, long expire, String tag, IssuePublisher.OnIssueDetectListener issueDetectListener) {
        super(issueDetectListener);
        this.expiredTime = expire;
        this.sharedPreferences = context.getSharedPreferences(tag + MatrixUtil.getProcessName(context), 0);
        this.mPublishedMap = new HashMap();
        long current = System.currentTimeMillis();
        this.editor = this.sharedPreferences.edit();
        HashSet spKeys = new HashSet(this.sharedPreferences.getAll().keySet());
        for (String key : spKeys) {
            long start = this.sharedPreferences.getLong(key, 0L);
            long costTime = current - start;
            if (start <= 0L || costTime > this.expiredTime) {
                this.editor.remove(key);
                continue;
            }
            this.mPublishedMap.put(key, start);
        }
        this.editor.apply();
    }

    @Override
    public void markPublished(String key) {
        if (key == null) {
            return;
        }
        if (!this.mPublishedMap.containsKey(key)) {
            long now = System.currentTimeMillis();
            this.mPublishedMap.put(key, now);
            this.editor.putLong(key, now).apply();
            return;
        }
    }

    @Override
    public void unMarkPublished(String key) {
        if (key == null) {
            return;
        }
        if (!this.mPublishedMap.containsKey(key)) {
            return;
        }
        this.mPublishedMap.remove(key);
        this.editor.remove(key).apply();
    }

    @Override
    public boolean isPublished(String key) {
        if (!this.mPublishedMap.containsKey(key)) {
            return false;
        }
        long start = this.mPublishedMap.get(key);
        if (start <= 0L || System.currentTimeMillis() - start > this.expiredTime) {
            this.editor.remove(key).apply();
            this.mPublishedMap.remove(key);
            return false;
        }
        return true;
    }
}

