/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.tencent.matrix.util.MatrixLog;
import java.util.HashSet;
import java.util.Iterator;

public class MatrixHandlerThread {
    private static final String TAG = "Matrix.HandlerThread";
    public static final String MATRIX_THREAD_NAME = "default_matrix_thread";
    private static volatile HandlerThread defaultHandlerThread;
    private static volatile Handler defaultHandler;
    private static volatile Handler defaultMainHandler;
    private static HashSet<HandlerThread> handlerThreads;

    public static Handler getDefaultMainHandler() {
        return defaultMainHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HandlerThread getDefaultHandlerThread() {
        Class<MatrixHandlerThread> clazz = MatrixHandlerThread.class;
        synchronized (MatrixHandlerThread.class) {
            if (null == defaultHandlerThread) {
                defaultHandlerThread = new HandlerThread(MATRIX_THREAD_NAME);
                defaultHandlerThread.start();
                defaultHandler = new Handler(defaultHandlerThread.getLooper());
                MatrixLog.w(TAG, "create default handler thread, we should use these thread normal", new Object[0]);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultHandlerThread;
        }
    }

    public static Handler getDefaultHandler() {
        return defaultHandler;
    }

    public static HandlerThread getNewHandlerThread(String name) {
        Iterator<HandlerThread> i = handlerThreads.iterator();
        while (i.hasNext()) {
            HandlerThread element = i.next();
            if (element.isAlive()) continue;
            i.remove();
            MatrixLog.w(TAG, "warning: remove dead handler thread with name %s", name);
        }
        HandlerThread handlerThread = new HandlerThread(name);
        handlerThread.start();
        handlerThreads.add(handlerThread);
        MatrixLog.w(TAG, "warning: create new handler thread with name %s, alive thread size:%d", name, handlerThreads.size());
        return handlerThread;
    }

    static {
        defaultMainHandler = new Handler(Looper.getMainLooper());
        handlerThreads = new HashSet();
    }
}

