/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.util;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public final class MatrixUtil {
    private static final String TAG = "Matrix.MatrixUtil";
    private static String processName = null;
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final ThreadLocal<MessageDigest> MD5_DIGEST = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Initialize MD5 failed.", e);
            }
        }
    };

    private MatrixUtil() {
    }

    public static String formatTime(String format, long timeMilliSecond) {
        return new SimpleDateFormat(format).format(new Date(timeMilliSecond));
    }

    public static boolean isInMainThread(long threadId) {
        return Looper.getMainLooper().getThread().getId() == threadId;
    }

    public static boolean isInMainProcess(Context context) {
        String pkgName = context.getPackageName();
        String processName = MatrixUtil.getProcessName(context);
        if (processName == null || processName.length() == 0) {
            processName = "";
        }
        return pkgName.equals(processName);
    }

    public static String getProcessName(Context context) {
        if (processName != null) {
            return processName;
        }
        processName = MatrixUtil.getProcessNameInternal(context);
        return processName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcessNameInternal(Context context) {
        List appProcessList;
        int myPid = Process.myPid();
        if (context == null || myPid <= 0) {
            return "";
        }
        ActivityManager.RunningAppProcessInfo myProcess = null;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager != null && (appProcessList = activityManager.getRunningAppProcesses()) != null) {
            try {
                for (ActivityManager.RunningAppProcessInfo process : appProcessList) {
                    if (process.pid != myPid) continue;
                    myProcess = process;
                    break;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("getProcessNameInternal exception:" + e.getMessage()));
            }
            if (myProcess != null) {
                return myProcess.processName;
            }
        }
        byte[] b = new byte[128];
        FileInputStream in = null;
        try {
            in = new FileInputStream("/proc/" + myPid + "/cmdline");
            int len = in.read(b);
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    if (b[i] > 0) continue;
                    len = i;
                    break;
                }
                String string = new String(b, 0, len, Charset.forName("UTF-8"));
                return string;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getProcessNameInternal exception:" + e.getMessage()));
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.getMessage());
            }
        }
        return "";
    }

    public static String getLatestStack(String stack, int count) {
        if (stack == null || stack.isEmpty()) {
            return "";
        }
        String[] strings = stack.split("\n");
        if (strings.length <= count) {
            return stack;
        }
        StringBuffer sb = new StringBuffer(count);
        for (int i = 0; i < count; ++i) {
            sb.append(strings[i]).append('\n');
        }
        return sb.toString();
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to close resource", (Throwable)e);
        }
    }

    public static String getMD5String(String s) {
        return MatrixUtil.getMD5String(s.getBytes());
    }

    public static String getMD5String(byte[] bytes) {
        MessageDigest digest = MD5_DIGEST.get();
        return MatrixUtil.bufferToHex(digest.digest(bytes));
    }

    private static String bufferToHex(byte[] bytes) {
        return MatrixUtil.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        for (int l = m; l < k; ++l) {
            MatrixUtil.appendHexPair(bytes[l], stringbuffer);
        }
        return stringbuffer.toString();
    }

    private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char c0 = hexDigits[(bt & 0xF0) >> 4];
        char c1 = hexDigits[bt & 0xF];
        stringbuffer.append(c0);
        stringbuffer.append(c1);
    }
}

