/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Bundle;
import android.text.TextUtils;
import com.tencent.matrix.listeners.IAppForeground;
import com.tencent.matrix.util.MatrixLog;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum AppActiveMatrixDelegate {
    INSTANCE;

    private static final String TAG = "Matrix.AppActiveMatrixDelegate";
    private Set<IAppForeground> listeners = Collections.synchronizedSet(new HashSet());
    private boolean isAppForeground = false;
    private String visibleScene = "default";
    private Controller controller = new Controller();
    private boolean isInited = false;
    private String currentFragmentName;

    public void init(Application application) {
        if (this.isInited) {
            MatrixLog.e(TAG, "has inited!", new Object[0]);
            return;
        }
        this.isInited = true;
        application.registerComponentCallbacks((ComponentCallbacks)this.controller);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.controller);
    }

    public String getCurrentFragmentName() {
        return this.currentFragmentName;
    }

    public void setCurrentFragmentName(String fragmentName) {
        MatrixLog.i(TAG, "[setCurrentFragmentName] fragmentName:%s", fragmentName);
        this.currentFragmentName = fragmentName;
        this.updateScene(fragmentName);
    }

    public String getVisibleScene() {
        return this.visibleScene;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDispatchForeground(String visibleScene) {
        if (this.isAppForeground || !this.isInited) {
            return;
        }
        MatrixLog.i(TAG, "onForeground... visibleScene[%s]", visibleScene);
        try {
            for (IAppForeground listener : this.listeners) {
                listener.onForeground(true);
            }
        }
        finally {
            this.isAppForeground = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDispatchBackground(String visibleScene) {
        if (!this.isAppForeground || !this.isInited) {
            return;
        }
        MatrixLog.i(TAG, "onBackground... visibleScene[%s]", visibleScene);
        try {
            for (IAppForeground listener : this.listeners) {
                listener.onForeground(false);
            }
        }
        finally {
            this.isAppForeground = false;
        }
    }

    public boolean isAppForeground() {
        return this.isAppForeground;
    }

    public void addListener(IAppForeground listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IAppForeground listener) {
        this.listeners.remove(listener);
    }

    private void updateScene(Activity activity) {
        this.visibleScene = activity.getClass().getName();
    }

    private void updateScene(String currentFragmentName) {
        StringBuilder ss = new StringBuilder();
        ss.append(TextUtils.isEmpty((CharSequence)currentFragmentName) ? "?" : currentFragmentName);
        this.visibleScene = ss.toString();
    }

    /*
     * Exception decompiling
     */
    public static String getTopActivityName() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final class Controller
    implements Application.ActivityLifecycleCallbacks,
    ComponentCallbacks2 {
        private Controller() {
        }

        public void onActivityStarted(Activity activity) {
            AppActiveMatrixDelegate.this.updateScene(activity);
            if (!AppActiveMatrixDelegate.this.isAppForeground) {
                AppActiveMatrixDelegate.this.onDispatchForeground(AppActiveMatrixDelegate.this.getVisibleScene());
            }
        }

        public void onActivityStopped(Activity activity) {
            if (AppActiveMatrixDelegate.getTopActivityName() == null) {
                AppActiveMatrixDelegate.this.onDispatchBackground(AppActiveMatrixDelegate.this.getVisibleScene());
            }
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
        }

        public void onTrimMemory(int level) {
            MatrixLog.i(AppActiveMatrixDelegate.TAG, "[onTrimMemory] level:%s", level);
            if (level == 20 && AppActiveMatrixDelegate.this.isAppForeground) {
                AppActiveMatrixDelegate.this.onDispatchBackground(AppActiveMatrixDelegate.this.visibleScene);
            }
        }
    }
}

