/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.util;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Debug;
import android.os.Process;
import com.tencent.matrix.util.MatrixLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceUtil {
    private static final long MB = 0x100000L;
    private static final String TAG = "Matrix.DeviceUtil";
    private static final int INVALID = 0;
    private static final String MEMORY_FILE_PATH = "/proc/meminfo";
    private static final String CPU_FILE_PATH_0 = "/sys/devices/system/cpu/";
    private static final String CPU_FILE_PATH_1 = "/sys/devices/system/cpu/possible";
    private static final String CPU_FILE_PATH_2 = "/sys/devices/system/cpu/present";
    private static LEVEL sLevelCache = null;
    public static final String DEVICE_MACHINE = "machine";
    private static final String DEVICE_MEMORY_FREE = "mem_free";
    private static final String DEVICE_MEMORY = "mem";
    private static final String DEVICE_CPU = "cpu_app";
    private static long sTotalMemory = 0L;
    private static long sLowMemoryThresold = 0L;
    private static int sMemoryClass = 0;
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return Pattern.matches("cpu[0-9]", pathname.getName());
        }
    };

    public static JSONObject getDeviceInfo(JSONObject oldObj, Application context) {
        try {
            oldObj.put(DEVICE_MACHINE, (Object)DeviceUtil.getLevel((Context)context));
            oldObj.put(DEVICE_CPU, DeviceUtil.getAppCpuRate());
            oldObj.put(DEVICE_MEMORY, DeviceUtil.getTotalMemory((Context)context));
            oldObj.put(DEVICE_MEMORY_FREE, DeviceUtil.getMemFree((Context)context));
        }
        catch (JSONException e) {
            MatrixLog.e(TAG, "[JSONException for stack, error: %s", new Object[]{e});
        }
        return oldObj;
    }

    public static LEVEL getLevel(Context context) {
        if (null != sLevelCache) {
            return sLevelCache;
        }
        long start = System.currentTimeMillis();
        long totalMemory = DeviceUtil.getTotalMemory(context);
        int coresNum = DeviceUtil.getNumOfCores();
        MatrixLog.i(TAG, "[getLevel] totalMemory:%s coresNum:%s", totalMemory, coresNum);
        if (totalMemory >= 0x100000000L) {
            sLevelCache = LEVEL.BEST;
        } else if (totalMemory >= 0xC0000000L) {
            sLevelCache = LEVEL.HIGH;
        } else if (totalMemory >= 0x80000000L) {
            if (coresNum >= 4) {
                sLevelCache = LEVEL.HIGH;
            } else if (coresNum >= 2) {
                sLevelCache = LEVEL.MIDDLE;
            } else if (coresNum > 0) {
                sLevelCache = LEVEL.LOW;
            }
        } else if (totalMemory >= 0x40000000L) {
            if (coresNum >= 4) {
                sLevelCache = LEVEL.MIDDLE;
            } else if (coresNum >= 2) {
                sLevelCache = LEVEL.LOW;
            } else if (coresNum > 0) {
                sLevelCache = LEVEL.LOW;
            }
        } else {
            sLevelCache = 0L <= totalMemory && totalMemory < 0x40000000L ? LEVEL.BAD : LEVEL.UN_KNOW;
        }
        MatrixLog.i(TAG, "getLevel, cost:" + (System.currentTimeMillis() - start) + ", level:" + (Object)((Object)sLevelCache), new Object[0]);
        return sLevelCache;
    }

    private static int getAppId() {
        return Process.myPid();
    }

    public static long getLowMemoryThresold(Context context) {
        if (0L != sLowMemoryThresold) {
            return sLowMemoryThresold;
        }
        DeviceUtil.getTotalMemory(context);
        return sLowMemoryThresold;
    }

    public static int getMemoryClass(Context context) {
        if (0 != sMemoryClass) {
            return sMemoryClass * 1024;
        }
        DeviceUtil.getTotalMemory(context);
        return sMemoryClass * 1024;
    }

    public static long getTotalMemory(Context context) {
        if (0L != sTotalMemory) {
            return sTotalMemory;
        }
        long start = System.currentTimeMillis();
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            am.getMemoryInfo(memInfo);
            sTotalMemory = memInfo.totalMem;
            sLowMemoryThresold = memInfo.threshold;
            long memClass = Runtime.getRuntime().maxMemory();
            sMemoryClass = memClass == Long.MAX_VALUE ? am.getMemoryClass() : (int)(memClass / 0x100000L);
            MatrixLog.i(TAG, "getTotalMemory cost:" + (System.currentTimeMillis() - start) + ", total_mem:" + sTotalMemory + ", LowMemoryThresold:" + sLowMemoryThresold + ", Memory Class:" + sMemoryClass, new Object[0]);
            return sTotalMemory;
        }
        return 0L;
    }

    public static boolean isLowMemory(Context context) {
        ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        am.getMemoryInfo(memInfo);
        return memInfo.lowMemory;
    }

    public static long getAvailMemory(Context context) {
        Runtime runtime = Runtime.getRuntime();
        return runtime.freeMemory() / 1024L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static long getMemFree(Context context) {
        long availMemory;
        block16: {
            if (Build.VERSION.SDK_INT >= 16) {
                ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
                ActivityManager am = (ActivityManager)context.getSystemService("activity");
                am.getMemoryInfo(memInfo);
                return memInfo.availMem / 1024L;
            }
            availMemory = 0L;
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(MEMORY_FILE_PATH), "UTF-8"));
            String line = bufferedReader.readLine();
            while (null != line) {
                String[] args = line.split("\\s+");
                if ("MemAvailable:".equals(args[0])) {
                    availMemory = (long)Integer.parseInt(args[1]) * 1024L;
                    break;
                }
                line = bufferedReader.readLine();
            }
            try {
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
                break block16;
            }
            catch (Exception e) {
                MatrixLog.i(TAG, "close reader %s", e.toString());
            }
            break block16;
            catch (Exception e) {
                try {
                    MatrixLog.i(TAG, "[getAvailMemory] error! %s", e.toString());
                }
                catch (Throwable throwable) {
                    try {
                        if (null != bufferedReader) {
                            bufferedReader.close();
                        }
                    }
                    catch (Exception e2) {
                        MatrixLog.i(TAG, "close reader %s", e2.toString());
                    }
                    throw throwable;
                }
                try {
                    if (null != bufferedReader) {
                        bufferedReader.close();
                    }
                }
                catch (Exception e3) {
                    MatrixLog.i(TAG, "close reader %s", e3.toString());
                }
            }
        }
        return availMemory / 1024L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static double getAppCpuRate() {
        double cpuRate;
        long appTime;
        long cpuTime;
        long start;
        block28: {
            RandomAccessFile appStatFile;
            block27: {
                start = System.currentTimeMillis();
                cpuTime = 0L;
                appTime = 0L;
                cpuRate = 0.0;
                RandomAccessFile procStatFile = null;
                appStatFile = null;
                procStatFile = new RandomAccessFile("/proc/stat", "r");
                String procStatString = procStatFile.readLine();
                String[] procStats = procStatString.split(" ");
                cpuTime = Long.parseLong(procStats[2]) + Long.parseLong(procStats[3]) + Long.parseLong(procStats[4]) + Long.parseLong(procStats[5]) + Long.parseLong(procStats[6]) + Long.parseLong(procStats[7]) + Long.parseLong(procStats[8]);
                try {
                    if (null != procStatFile) {
                        procStatFile.close();
                    }
                    break block27;
                }
                catch (Exception e) {
                    MatrixLog.i(TAG, "close process reader %s", e.toString());
                }
                break block27;
                catch (Exception e) {
                    try {
                        MatrixLog.i(TAG, "RandomAccessFile(Process Stat) reader fail, error: %s", e.toString());
                    }
                    catch (Throwable throwable) {
                        try {
                            if (null != procStatFile) {
                                procStatFile.close();
                            }
                        }
                        catch (Exception e2) {
                            MatrixLog.i(TAG, "close process reader %s", e2.toString());
                        }
                        throw throwable;
                    }
                    try {
                        if (null != procStatFile) {
                            procStatFile.close();
                        }
                    }
                    catch (Exception e3) {
                        MatrixLog.i(TAG, "close process reader %s", e3.toString());
                    }
                }
            }
            appStatFile = new RandomAccessFile("/proc/" + DeviceUtil.getAppId() + "/stat", "r");
            String appStatString = appStatFile.readLine();
            String[] appStats = appStatString.split(" ");
            appTime = Long.parseLong(appStats[13]) + Long.parseLong(appStats[14]);
            try {
                if (null != appStatFile) {
                    appStatFile.close();
                }
                break block28;
            }
            catch (Exception e) {
                MatrixLog.i(TAG, "close app reader %s", e.toString());
            }
            break block28;
            catch (Exception e) {
                try {
                    MatrixLog.i(TAG, "RandomAccessFile(App Stat) reader fail, error: %s", e.toString());
                }
                catch (Throwable throwable) {
                    try {
                        if (null != appStatFile) {
                            appStatFile.close();
                        }
                    }
                    catch (Exception e4) {
                        MatrixLog.i(TAG, "close app reader %s", e4.toString());
                    }
                    throw throwable;
                }
                try {
                    if (null != appStatFile) {
                        appStatFile.close();
                    }
                }
                catch (Exception e5) {
                    MatrixLog.i(TAG, "close app reader %s", e5.toString());
                }
            }
        }
        if (0L != cpuTime) {
            cpuRate = (double)appTime / (double)cpuTime * 100.0;
        }
        MatrixLog.i(TAG, "getAppCpuRate cost:" + (System.currentTimeMillis() - start) + ",rate:" + cpuRate, new Object[0]);
        return cpuRate;
    }

    public static Debug.MemoryInfo getAppMemory(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            Debug.MemoryInfo[] memInfo = activityManager.getProcessMemoryInfo(new int[]{DeviceUtil.getAppId()});
            if (memInfo.length > 0) {
                return memInfo[0];
            }
        }
        catch (Exception e) {
            MatrixLog.i(TAG, "getProcessMemoryInfo fail, error: %s", e.toString());
        }
        return null;
    }

    private static int getNumOfCores() {
        int cores;
        if (Build.VERSION.SDK_INT <= 10) {
            return 1;
        }
        try {
            cores = DeviceUtil.getCoresFromFile(CPU_FILE_PATH_1);
            if (cores == 0) {
                cores = DeviceUtil.getCoresFromFile(CPU_FILE_PATH_2);
            }
            if (cores == 0) {
                cores = DeviceUtil.getCoresFromCPUFiles(CPU_FILE_PATH_0);
            }
        }
        catch (Exception e) {
            cores = 0;
        }
        if (cores == 0) {
            cores = 1;
        }
        return cores;
    }

    private static int getCoresFromCPUFiles(String path) {
        File[] list = new File(path).listFiles(CPU_FILTER);
        return null == list ? 0 : list.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static int getCoresFromFile(String file) {
        String fileContents;
        FileInputStream is;
        block17: {
            is = null;
            is = new FileInputStream(file);
            BufferedReader buf = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
            fileContents = buf.readLine();
            buf.close();
            if (fileContents != null && fileContents.matches("0-[\\d]+$")) break block17;
            int n = 0;
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e) {
                MatrixLog.i(TAG, "[getCoresFromFile] error! %s", e.toString());
            }
            return n;
        }
        String num = fileContents.substring(2);
        int n = Integer.parseInt(num) + 1;
        try {
            if (is != null) {
                ((InputStream)is).close();
            }
        }
        catch (IOException e) {
            MatrixLog.i(TAG, "[getCoresFromFile] error! %s", e.toString());
        }
        return n;
        catch (IOException e) {
            int n2;
            try {
                MatrixLog.i(TAG, "[getCoresFromFile] error! %s", e.toString());
                n2 = 0;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e2) {
                    MatrixLog.i(TAG, "[getCoresFromFile] error! %s", e2.toString());
                }
                throw throwable;
            }
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e3) {
                MatrixLog.i(TAG, "[getCoresFromFile] error! %s", e3.toString());
            }
            return n2;
        }
    }

    public static long getDalvikHeap() {
        Runtime runtime = Runtime.getRuntime();
        return (runtime.totalMemory() - runtime.freeMemory()) / 1024L;
    }

    public static long getNativeHeap() {
        return Debug.getNativeHeapAllocatedSize() / 1024L;
    }

    public static long getVmSize() {
        String status = String.format("/proc/%s/status", DeviceUtil.getAppId());
        try {
            Pattern p;
            Matcher matcher;
            String[] args;
            String content = DeviceUtil.getStringFromFile(status).trim();
            for (String str : args = content.split("\n")) {
                Pattern p2;
                Matcher matcher2;
                if (!str.startsWith("VmSize") || !(matcher2 = (p2 = Pattern.compile("\\d+")).matcher(str)).find()) continue;
                return Long.parseLong(matcher2.group());
            }
            if (args.length > 12 && (matcher = (p = Pattern.compile("\\d+")).matcher(args[12])).find()) {
                return Long.parseLong(matcher.group());
            }
        }
        catch (Exception e) {
            return -1L;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) throws Exception {
        BufferedReader reader = null;
        StringBuilder sb = new StringBuilder();
        try {
            reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromFile(String filePath) throws Exception {
        String ret;
        File fl = new File(filePath);
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(fl);
            ret = DeviceUtil.convertStreamToString(fin);
        }
        finally {
            if (null != fin) {
                fin.close();
            }
        }
        return ret;
    }

    public static enum LEVEL {
        BEST(5),
        HIGH(4),
        MIDDLE(3),
        LOW(2),
        BAD(1),
        UN_KNOW(-1);

        int value;

        private LEVEL(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }
    }
}

