/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.lifecycle;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import com.tencent.matrix.lifecycle.IStateObserver;
import com.tencent.matrix.lifecycle.ObserverWrapper;
import com.tencent.matrix.lifecycle.StatefulOwner;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/tencent/matrix/lifecycle/AutoReleaseObserverWrapper;", "Lcom/tencent/matrix/lifecycle/ObserverWrapper;", "Landroidx/lifecycle/LifecycleObserver;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "targetObservable", "Lcom/tencent/matrix/lifecycle/StatefulOwner;", "observer", "Lcom/tencent/matrix/lifecycle/IStateObserver;", "(Landroidx/lifecycle/LifecycleOwner;Lcom/tencent/matrix/lifecycle/StatefulOwner;Lcom/tencent/matrix/lifecycle/IStateObserver;)V", "getLifecycleOwner", "()Landroidx/lifecycle/LifecycleOwner;", "isAttachedTo", "", "owner", "release", "", "matrix-android-lib_release"})
final class AutoReleaseObserverWrapper
extends ObserverWrapper
implements LifecycleObserver {
    @NotNull
    private final LifecycleOwner lifecycleOwner;

    @Override
    public boolean isAttachedTo(@Nullable LifecycleOwner owner) {
        return Intrinsics.areEqual((Object)this.lifecycleOwner, (Object)owner);
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public final void release() {
        this.getStatefulOwner().removeObserver(this.getObserver());
    }

    @NotNull
    public final LifecycleOwner getLifecycleOwner() {
        return this.lifecycleOwner;
    }

    public AutoReleaseObserverWrapper(@NotNull LifecycleOwner lifecycleOwner, @NotNull StatefulOwner targetObservable, @NotNull IStateObserver observer) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)targetObservable, (String)"targetObservable");
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        super(observer, targetObservable);
        this.lifecycleOwner = lifecycleOwner;
        Lifecycle lifecycle = this.lifecycleOwner.getLifecycle();
        Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"lifecycleOwner.lifecycle");
        if (lifecycle.getCurrentState() == Lifecycle.State.DESTROYED) {
            throw (Throwable)new IllegalStateException("NOT allow to observe with DESTROYED lifecycle owner");
        }
        this.lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)this);
    }
}

