/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.lifecycle.owners;

import androidx.lifecycle.LifecycleOwner;
import com.tencent.matrix.lifecycle.IBackgroundStatefulOwner;
import com.tencent.matrix.lifecycle.IMatrixBackgroundCallback;
import com.tencent.matrix.lifecycle.IMatrixLifecycleCallback;
import com.tencent.matrix.lifecycle.ISerialObserver;
import com.tencent.matrix.lifecycle.StatefulOwner;
import com.tencent.matrix.lifecycle.owners.ProcessBackgroundStateOwnerKt;
import com.tencent.matrix.lifecycle.owners.ProcessExplicitBackgroundOwner;
import com.tencent.matrix.lifecycle.owners.ProcessStagedBackgroundOwner;
import com.tencent.matrix.lifecycle.owners.ProcessUICreatedStateOwner;
import com.tencent.matrix.lifecycle.owners.ProcessUILifecycleOwner;
import com.tencent.matrix.lifecycle.owners.TimerChecker;
import com.tencent.matrix.util.MatrixLog;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000*\u0001\u0007\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lcom/tencent/matrix/lifecycle/owners/ProcessStagedBackgroundOwner;", "Lcom/tencent/matrix/lifecycle/StatefulOwner;", "Lcom/tencent/matrix/lifecycle/IBackgroundStatefulOwner;", "()V", "TAG", "", "checkTask", "com/tencent/matrix/lifecycle/owners/ProcessStagedBackgroundOwner$checkTask$1", "Lcom/tencent/matrix/lifecycle/owners/ProcessStagedBackgroundOwner$checkTask$1;", "value", "", "maxCheckInterval", "getMaxCheckInterval", "()J", "setMaxCheckInterval", "(J)V", "", "maxCheckTimes", "getMaxCheckTimes", "()I", "setMaxCheckTimes", "(I)V", "active", "", "matrix-android-lib_release"})
public final class ProcessStagedBackgroundOwner
extends StatefulOwner
implements IBackgroundStatefulOwner {
    private static final String TAG = "Matrix.background.Staged";
    private static long maxCheckInterval;
    private static int maxCheckTimes;
    private static final checkTask.1 checkTask;
    @NotNull
    public static final ProcessStagedBackgroundOwner INSTANCE;

    public final long getMaxCheckInterval() {
        return maxCheckInterval;
    }

    public final void setMaxCheckInterval(long value) {
        if (value < TimeUnit.SECONDS.toMillis(10L)) {
            throw (Throwable)new IllegalArgumentException("interval should NOT be less than 10s");
        }
        maxCheckInterval = value;
        MatrixLog.i(TAG, "set max check interval as " + value, new Object[0]);
    }

    public final int getMaxCheckTimes() {
        return maxCheckTimes;
    }

    public final void setMaxCheckTimes(int value) {
        if (value <= 0) {
            throw (Throwable)new IllegalArgumentException("max check times should be greater than 0");
        }
        maxCheckTimes = value;
        MatrixLog.i(TAG, "set max check interval as " + value, new Object[0]);
    }

    @Override
    public boolean active() {
        boolean bl;
        if (!ProcessExplicitBackgroundOwner.INSTANCE.active()) {
            this.turnOff();
            bl = false;
        } else {
            checkTask.checkAndPostIfNeeded();
            bl = super.active();
        }
        return bl;
    }

    private ProcessStagedBackgroundOwner() {
        super(false, 1, null);
    }

    static {
        ProcessStagedBackgroundOwner processStagedBackgroundOwner;
        INSTANCE = processStagedBackgroundOwner = new ProcessStagedBackgroundOwner();
        maxCheckInterval = ProcessBackgroundStateOwnerKt.access$getMAX_CHECK_INTERVAL$p();
        maxCheckTimes = 20;
        checkTask = new TimerChecker(processStagedBackgroundOwner, TAG, maxCheckInterval, maxCheckTimes){
            final /* synthetic */ ProcessStagedBackgroundOwner this$0;

            protected boolean action() {
                if (ProcessExplicitBackgroundOwner.INSTANCE.active()) {
                    boolean bl = ProcessUILifecycleOwner.hasRunningAppTask();
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean it = bl;
                    boolean bl4 = false;
                    MatrixLog.i("Matrix.background.Staged", "hasRunningAppTask? " + it, new Object[0]);
                    if (bl || ProcessUICreatedStateOwner.INSTANCE.active()) {
                        MatrixLog.i("Matrix.background.Staged", "turn ON", new Object[0]);
                        ProcessStagedBackgroundOwner.access$turnOn(ProcessStagedBackgroundOwner.INSTANCE);
                        return true;
                    }
                }
                MatrixLog.i("Matrix.background.Staged", "turn off", new Object[0]);
                ProcessStagedBackgroundOwner.access$turnOff(ProcessStagedBackgroundOwner.INSTANCE);
                return false;
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }
        };
        ProcessExplicitBackgroundOwner.INSTANCE.observeForever(new ISerialObserver(){

            @Override
            public void on() {
                ProcessStagedBackgroundOwner.access$getCheckTask$p(INSTANCE).post();
            }

            @Override
            public void off() {
                ProcessStagedBackgroundOwner.access$getCheckTask$p(INSTANCE).stop();
                INSTANCE.turnOff();
            }

            @Override
            public boolean serial() {
                return ISerialObserver.DefaultImpls.serial(this);
            }
        });
    }

    @Override
    public boolean isBackground() {
        return IBackgroundStatefulOwner.DefaultImpls.isBackground(this);
    }

    @Override
    public void addLifecycleCallback(@NotNull IMatrixBackgroundCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        IBackgroundStatefulOwner.DefaultImpls.addLifecycleCallback((IBackgroundStatefulOwner)this, callback);
    }

    @Override
    public void addLifecycleCallback(@NotNull LifecycleOwner lifecycleOwner, @NotNull IMatrixBackgroundCallback callback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        IBackgroundStatefulOwner.DefaultImpls.addLifecycleCallback((IBackgroundStatefulOwner)this, lifecycleOwner, callback);
    }

    @Override
    @Deprecated(message="")
    public void addLifecycleCallback(@NotNull IMatrixLifecycleCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        IBackgroundStatefulOwner.DefaultImpls.addLifecycleCallback((IBackgroundStatefulOwner)this, callback);
    }

    @Override
    @Deprecated(message="")
    public void addLifecycleCallback(@NotNull LifecycleOwner lifecycleOwner, @NotNull IMatrixLifecycleCallback callback) {
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        IBackgroundStatefulOwner.DefaultImpls.addLifecycleCallback((IBackgroundStatefulOwner)this, lifecycleOwner, callback);
    }

    @Override
    public void removeLifecycleCallback(@NotNull IMatrixBackgroundCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        IBackgroundStatefulOwner.DefaultImpls.removeLifecycleCallback((IBackgroundStatefulOwner)this, callback);
    }

    @Override
    @Deprecated(message="")
    public void removeLifecycleCallback(@NotNull IMatrixLifecycleCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        IBackgroundStatefulOwner.DefaultImpls.removeLifecycleCallback((IBackgroundStatefulOwner)this, callback);
    }

    public static final /* synthetic */ void access$turnOn(ProcessStagedBackgroundOwner $this) {
        $this.turnOn();
    }

    public static final /* synthetic */ checkTask.1 access$getCheckTask$p(ProcessStagedBackgroundOwner $this) {
        ProcessStagedBackgroundOwner processStagedBackgroundOwner = $this;
        return checkTask;
    }
}

