/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.lifecycle.supervisor;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import com.tencent.matrix.lifecycle.MatrixLifecycleThread;
import com.tencent.matrix.lifecycle.StatefulOwner;
import com.tencent.matrix.lifecycle.supervisor.DispatcherStateOwner;
import com.tencent.matrix.lifecycle.supervisor.ISubordinateProxy;
import com.tencent.matrix.lifecycle.supervisor.ISupervisorProxy;
import com.tencent.matrix.lifecycle.supervisor.ProcessSubordinate;
import com.tencent.matrix.lifecycle.supervisor.ProcessSupervisor;
import com.tencent.matrix.lifecycle.supervisor.ProcessToken;
import com.tencent.matrix.lifecycle.supervisor.SubordinatePacemaker;
import com.tencent.matrix.lifecycle.supervisor.SupervisorConfig;
import com.tencent.matrix.lifecycle.supervisor.SupervisorService;
import com.tencent.matrix.util.MatrixLog;
import com.tencent.matrix.util.MatrixUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b*\u0001\u000b\u0018\u0000 '2\u00020\u0001:\u0003'()B\u0005\u00a2\u0006\u0002\u0010\u0002J\\\u0010\u001b\u001a\u00020\u00182M\u0010\u001c\u001aI\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0015\u0012\u0013\u0018\u00010\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u00180\u0010H\u0000\u00a2\u0006\u0002\b\u001eJ\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020\u0018H\u0016J\u0012\u0010$\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u001a\u0010%\u001a\u00020\u0018*\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010&\u001a\u00020\u0005H\u0002R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000RW\u0010\u000f\u001aK\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0015\u0012\u0013\u0018\u00010\u0015\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0016\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/tencent/matrix/lifecycle/supervisor/SupervisorService;", "Landroid/app/Service;", "()V", "backgroundProcessLru", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/tencent/matrix/lifecycle/supervisor/ProcessToken;", "getBackgroundProcessLru", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "backgroundProcessLru$delegate", "Lkotlin/Lazy;", "binder", "com/tencent/matrix/lifecycle/supervisor/SupervisorService$binder$1", "Lcom/tencent/matrix/lifecycle/supervisor/SupervisorService$binder$1;", "runningHandler", "Landroid/os/Handler;", "targetKilledCallback", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "result", "", "target", "pid", "", "tokenRecord", "Lcom/tencent/matrix/lifecycle/supervisor/SupervisorService$TokenRecord;", "backgroundLruKill", "killedCallback", "process", "backgroundLruKill$matrix_android_lib_release", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onCreate", "contentToString", "moveOrAddFirst", "token", "Companion", "RemoteProcessLifecycleProxy", "TokenRecord", "matrix-android-lib_release"})
public final class SupervisorService
extends Service {
    private final Handler runningHandler = MatrixLifecycleThread.INSTANCE.getHandler();
    private final TokenRecord tokenRecord = new TokenRecord();
    private final Lazy backgroundProcessLru$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)backgroundProcessLru.2.INSTANCE);
    private Function3<? super Integer, ? super String, ? super Integer, Unit> targetKilledCallback;
    private final binder.1 binder = new ISupervisorProxy.Stub(this){
        final /* synthetic */ SupervisorService this$0;

        public void registerSubordinate(@NotNull ProcessToken[] tokens, @NotNull ISubordinateProxy subordinateProxy) {
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            Intrinsics.checkNotNullParameter((Object)subordinateProxy, (String)"subordinateProxy");
            int pid = Binder.getCallingPid();
            SupervisorConfig supervisorConfig = ProcessSupervisor.INSTANCE.getConfig$matrix_android_lib_release();
            if (supervisorConfig == null || !supervisorConfig.getEnable()) {
                MatrixLog.e("Matrix.ProcessSupervisor.Service", "supervisor was disabled", new Object[0]);
                return;
            }
            SupervisorService.access$getRunningHandler$p(this.this$0).post(new Runnable(this, tokens, subordinateProxy, pid){
                final /* synthetic */ binder.1 this$0;
                final /* synthetic */ ProcessToken[] $tokens;
                final /* synthetic */ ISubordinateProxy $subordinateProxy;
                final /* synthetic */ int $pid;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    StringBuilder stringBuilder = new StringBuilder().append("supervisor called register, tokens(").append(this.$tokens.length).append("): ");
                    Object object = this.$tokens;
                    boolean bl = false;
                    String string = Arrays.toString(object);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
                    MatrixLog.d("Matrix.ProcessSupervisor.Service", stringBuilder.append(string).toString(), new Object[0]);
                    object = ArraysKt.first((Object[])this.$tokens);
                    String tag$iv = "Matrix.ProcessSupervisor.Service";
                    boolean log$iv = true;
                    String msg$iv = "";
                    boolean $i$f$safeApply = false;
                    try {
                        void $this$safeApply$iv;
                        ProcessToken $this$safeApply = (ProcessToken)$this$safeApply$iv;
                        boolean bl2 = false;
                        SupervisorService.access$getTokenRecord$p(this.this$0.this$0).addToken($this$safeApply);
                        ProcessSubordinate.INSTANCE.getManager$matrix_android_lib_release().addProxy($this$safeApply, this.$subordinateProxy);
                        SupervisorService.access$moveOrAddFirst(this.this$0.this$0, SupervisorService.access$getBackgroundProcessLru$p(this.this$0.this$0), $this$safeApply);
                        MatrixLog.i("Matrix.ProcessSupervisor.Service", "CREATED: [" + $this$safeApply.getPid() + '-' + $this$safeApply.getName() + "] -> [" + SupervisorService.access$getBackgroundProcessLru$p(this.this$0.this$0).size() + ']' + SupervisorService.access$contentToString(this.this$0.this$0, SupervisorService.access$getBackgroundProcessLru$p(this.this$0.this$0)), new Object[0]);
                        $this$safeApply.linkToDeath(new IBinder.DeathRecipient($this$safeApply, this){
                            final /* synthetic */ ProcessToken $this_safeApply;
                            final /* synthetic */ binder.registerSubordinate.1 this$0;
                            {
                                this.$this_safeApply = processToken;
                                this.this$0 = var2_2;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void binderDied() {
                                ProcessToken processToken = this.$this_safeApply;
                                String tag$iv = "Matrix.ProcessSupervisor.Service";
                                boolean log$iv = true;
                                String msg$iv = "";
                                boolean $i$f$safeApply = false;
                                try {
                                    void $this$safeApply$iv;
                                    void $this$safeApply = $this$safeApply$iv;
                                    boolean bl = false;
                                    ProcessToken dead = SupervisorService.access$getTokenRecord$p(this.this$0.this$0.this$0).removeToken(this.this$0.$pid);
                                    boolean lruRemoveSuccess = SupervisorService.access$getBackgroundProcessLru$p(this.this$0.this$0.this$0).remove(dead);
                                    ProcessSubordinate.INSTANCE.getManager$matrix_android_lib_release().removeProxy(dead);
                                    boolean proxyRemoveSuccess = RemoteProcessLifecycleProxy.Companion.removeProxy(dead);
                                    ProcessSubordinate.INSTANCE.getManager$matrix_android_lib_release().dispatchDeath(this.this$0.this$0.getRecentScene(), dead.getName(), dead.getPid(), !lruRemoveSuccess && !proxyRemoveSuccess);
                                    MatrixLog.i("Matrix.ProcessSupervisor.Service", "" + this.this$0.$pid + '-' + dead + " was dead. is LRU kill? " + (!lruRemoveSuccess && !proxyRemoveSuccess), new Object[0]);
                                }
                                catch (Throwable e$iv) {
                                    MatrixLog.printErrStackTrace(tag$iv, e$iv, msg$iv, new Object[0]);
                                }
                            }
                        });
                    }
                    catch (Throwable e$iv) {
                        MatrixLog.printErrStackTrace(tag$iv, e$iv, msg$iv, new Object[0]);
                    }
                    ProcessToken[] $this$forEach$iv = this.$tokens;
                    boolean $i$f$forEach = false;
                    ProcessToken[] processTokenArray = $this$forEach$iv;
                    int n = processTokenArray.length;
                    for (int i = 0; i < n; ++i) {
                        ProcessToken element$iv;
                        ProcessToken it = element$iv = processTokenArray[i];
                        boolean bl3 = false;
                        MatrixLog.d("Matrix.ProcessSupervisor.Service", "register: " + it.getName() + ", " + it.getStatefulName() + ", " + it.getState(), new Object[0]);
                        RemoteProcessLifecycleProxy.Companion.getProxy(it).onStateChanged(it.getState());
                    }
                    if (SupervisorService.access$getTokenRecord$p(this.this$0.this$0).isEmpty()) {
                        MatrixLog.i("Matrix.ProcessSupervisor.Service", "stateRegister: no other process registered, ignore state changes", new Object[0]);
                        return;
                    }
                    Context context = this.this$0.this$0.getApplicationContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                    DispatcherStateOwner.Companion.syncStates(ProcessToken.Companion.current$default(ProcessToken.Companion, context, null, false, 6, null), this.this$0.getRecentScene());
                }
                {
                    this.this$0 = var1_1;
                    this.$tokens = processTokenArray;
                    this.$subordinateProxy = iSubordinateProxy;
                    this.$pid = n;
                }
            });
        }

        public void onStateChanged(@NotNull ProcessToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            SupervisorConfig supervisorConfig = ProcessSupervisor.INSTANCE.getConfig$matrix_android_lib_release();
            if (supervisorConfig == null || !supervisorConfig.getEnable()) {
                MatrixLog.e("Matrix.ProcessSupervisor.Service", "supervisor was disabled", new Object[0]);
                return;
            }
            SupervisorService.access$getRunningHandler$p(this.this$0).post(new Runnable(this, token){
                final /* synthetic */ binder.1 this$0;
                final /* synthetic */ ProcessToken $token;

                public final void run() {
                    MatrixLog.i("Matrix.ProcessSupervisor.Service", "onStateChanged: " + this.$token.getStatefulName() + ' ' + this.$token.getState() + ' ' + this.$token.getName(), new Object[0]);
                    RemoteProcessLifecycleProxy.Companion.getProxy(this.$token).onStateChanged(this.$token.getState());
                    binder.1.access$onProcessStateChanged(this.this$0, this.$token);
                }
                {
                    this.this$0 = var1_1;
                    this.$token = processToken;
                }
            });
        }

        private final void onProcessStateChanged(ProcessToken token) {
            SupervisorConfig supervisorConfig = ProcessSupervisor.INSTANCE.getConfig$matrix_android_lib_release();
            if (supervisorConfig == null || !supervisorConfig.getEnable()) {
                MatrixLog.e("Matrix.ProcessSupervisor.Service", "supervisor was disabled", new Object[0]);
                return;
            }
            if (Intrinsics.areEqual((Object)"ExplicitBackgroundOwner", (Object)token.getStatefulName())) {
                if (token.getState()) {
                    SupervisorService.access$moveOrAddFirst(this.this$0, SupervisorService.access$getBackgroundProcessLru$p(this.this$0), token);
                    MatrixLog.i("Matrix.ProcessSupervisor.Service", "BACKGROUND: [" + token.getPid() + '-' + token.getName() + "] -> [" + SupervisorService.access$getBackgroundProcessLru$p(this.this$0).size() + ']' + SupervisorService.access$contentToString(this.this$0, SupervisorService.access$getBackgroundProcessLru$p(this.this$0)), new Object[0]);
                } else {
                    SupervisorService.access$getBackgroundProcessLru$p(this.this$0).remove(token);
                    MatrixLog.i("Matrix.ProcessSupervisor.Service", "FOREGROUND: [" + token.getPid() + '-' + token.getName() + "] <- [" + SupervisorService.access$getBackgroundProcessLru$p(this.this$0).size() + ']' + SupervisorService.access$contentToString(this.this$0, SupervisorService.access$getBackgroundProcessLru$p(this.this$0)), new Object[0]);
                }
            }
        }

        public void onSceneChanged(@NotNull String scene) {
            Intrinsics.checkNotNullParameter((Object)scene, (String)"scene");
            SupervisorConfig supervisorConfig = ProcessSupervisor.INSTANCE.getConfig$matrix_android_lib_release();
            if (supervisorConfig == null || !supervisorConfig.getEnable()) {
                MatrixLog.e("Matrix.ProcessSupervisor.Service", "supervisor was disabled", new Object[0]);
                return;
            }
            SupervisorService.Companion.setRecentScene$matrix_android_lib_release(scene);
        }

        public void onProcessKilled(@NotNull ProcessToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            SupervisorConfig supervisorConfig = ProcessSupervisor.INSTANCE.getConfig$matrix_android_lib_release();
            if (supervisorConfig == null || !supervisorConfig.getEnable()) {
                MatrixLog.e("Matrix.ProcessSupervisor.Service", "supervisor was disabled", new Object[0]);
                return;
            }
            SupervisorService.access$getRunningHandler$p(this.this$0).post(new Runnable(this, token){
                final /* synthetic */ binder.1 this$0;
                final /* synthetic */ ProcessToken $token;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    binder.1 var1_1 = this.this$0;
                    String tag$iv = "Matrix.ProcessSupervisor.Service";
                    boolean log$iv = true;
                    String msg$iv = "";
                    boolean $i$f$safeApply = false;
                    try {
                        void $this$safeApply$iv;
                        void $this$safeApply = $this$safeApply$iv;
                        boolean bl = false;
                        Function3 function3 = SupervisorService.access$getTargetKilledCallback$p(this.this$0.this$0);
                        if (function3 != null) {
                            Unit cfr_ignored_0 = (Unit)function3.invoke((Object)1, (Object)this.$token.getName(), (Object)this.$token.getPid());
                        }
                    }
                    catch (Throwable e$iv) {
                        MatrixLog.printErrStackTrace(tag$iv, e$iv, msg$iv, new Object[0]);
                    }
                    SupervisorService.access$getBackgroundProcessLru$p(this.this$0.this$0).remove(this.$token);
                    RemoteProcessLifecycleProxy.Companion.removeProxy(this.$token);
                    MatrixLog.i("Matrix.ProcessSupervisor.Service", "KILL: [" + this.$token.getPid() + '-' + this.$token.getName() + "] X [" + SupervisorService.access$getBackgroundProcessLru$p(this.this$0.this$0).size() + ']' + SupervisorService.access$contentToString(this.this$0.this$0, SupervisorService.access$getBackgroundProcessLru$p(this.this$0.this$0)), new Object[0]);
                }
                {
                    this.this$0 = var1_1;
                    this.$token = processToken;
                }
            });
        }

        public void onProcessRescuedFromKill(@NotNull ProcessToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            SupervisorConfig supervisorConfig = ProcessSupervisor.INSTANCE.getConfig$matrix_android_lib_release();
            if (supervisorConfig == null || !supervisorConfig.getEnable()) {
                MatrixLog.e("Matrix.ProcessSupervisor.Service", "supervisor was disabled", new Object[0]);
                return;
            }
            SupervisorService.access$getRunningHandler$p(this.this$0).post(new Runnable(this, token){
                final /* synthetic */ binder.1 this$0;
                final /* synthetic */ ProcessToken $token;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    binder.1 var1_1 = this.this$0;
                    String tag$iv = "Matrix.ProcessSupervisor.Service";
                    boolean log$iv = true;
                    String msg$iv = "";
                    boolean $i$f$safeApply = false;
                    try {
                        void $this$safeApply$iv;
                        void $this$safeApply = $this$safeApply$iv;
                        boolean bl = false;
                        Function3 function3 = SupervisorService.access$getTargetKilledCallback$p(this.this$0.this$0);
                        if (function3 != null) {
                            Unit cfr_ignored_0 = (Unit)function3.invoke((Object)2, (Object)this.$token.getName(), (Object)this.$token.getPid());
                        }
                    }
                    catch (Throwable e$iv) {
                        MatrixLog.printErrStackTrace(tag$iv, e$iv, msg$iv, new Object[0]);
                    }
                }
                {
                    this.this$0 = var1_1;
                    this.$token = processToken;
                }
            });
        }

        public void onProcessKillCanceled(@NotNull ProcessToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            SupervisorConfig supervisorConfig = ProcessSupervisor.INSTANCE.getConfig$matrix_android_lib_release();
            if (supervisorConfig == null || !supervisorConfig.getEnable()) {
                MatrixLog.e("Matrix.ProcessSupervisor.Service", "supervisor was disabled", new Object[0]);
                return;
            }
            SupervisorService.access$getRunningHandler$p(this.this$0).post(new Runnable(this, token){
                final /* synthetic */ binder.1 this$0;
                final /* synthetic */ ProcessToken $token;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    binder.1 var1_1 = this.this$0;
                    String tag$iv = "Matrix.ProcessSupervisor.Service";
                    boolean log$iv = true;
                    String msg$iv = "";
                    boolean $i$f$safeApply = false;
                    try {
                        void $this$safeApply$iv;
                        void $this$safeApply = $this$safeApply$iv;
                        boolean bl = false;
                        Function3 function3 = SupervisorService.access$getTargetKilledCallback$p(this.this$0.this$0);
                        if (function3 != null) {
                            Unit cfr_ignored_0 = (Unit)function3.invoke((Object)3, (Object)this.$token.getName(), (Object)this.$token.getPid());
                        }
                    }
                    catch (Throwable e$iv) {
                        MatrixLog.printErrStackTrace(tag$iv, e$iv, msg$iv, new Object[0]);
                    }
                }
                {
                    this.this$0 = var1_1;
                    this.$token = processToken;
                }
            });
        }

        @NotNull
        public String getRecentScene() {
            String string;
            SupervisorConfig supervisorConfig = ProcessSupervisor.INSTANCE.getConfig$matrix_android_lib_release();
            if (supervisorConfig == null || !supervisorConfig.getEnable()) {
                MatrixLog.e("Matrix.ProcessSupervisor.Service", "supervisor was disabled", new Object[0]);
                string = "";
            } else {
                string = SupervisorService.Companion.getRecentScene$matrix_android_lib_release();
            }
            return string;
        }
        {
            this.this$0 = this$0;
        }

        public static final /* synthetic */ void access$onProcessStateChanged(binder.1 $this, ProcessToken token) {
            $this.onProcessStateChanged(token);
        }
    };
    private static final String TAG = "Matrix.ProcessSupervisor.Service";
    private static volatile boolean isSupervisor;
    @NotNull
    private static volatile String recentScene;
    @Nullable
    private static volatile SupervisorService instance;
    @NotNull
    public static final Companion Companion;

    private final ConcurrentLinkedQueue<ProcessToken> getBackgroundProcessLru() {
        Lazy lazy = this.backgroundProcessLru$delegate;
        SupervisorService supervisorService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ConcurrentLinkedQueue)lazy.getValue();
    }

    private final String contentToString(ConcurrentLinkedQueue<ProcessToken> $this$contentToString) {
        Iterator<ProcessToken> iterator = $this$contentToString.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator()");
        Iterator<ProcessToken> it = iterator;
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            ProcessToken e = it.next();
            sb.append("" + e.getPid() + '-' + e.getName());
            if (!it.hasNext()) {
                String string = sb.append(']').toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.append(']').toString()");
                return string;
            }
            sb.append(',').append(' ');
        }
    }

    private final void moveOrAddFirst(ConcurrentLinkedQueue<ProcessToken> $this$moveOrAddFirst, ProcessToken token) {
        $this$moveOrAddFirst.remove(token);
        $this$moveOrAddFirst.add(token);
    }

    public void onCreate() {
        super.onCreate();
        MatrixLog.d(TAG, "onCreate", new Object[0]);
        isSupervisor = true;
        instance = this;
        SupervisorConfig supervisorConfig = ProcessSupervisor.INSTANCE.getConfig$matrix_android_lib_release();
        if (supervisorConfig == null || !supervisorConfig.getEnable()) {
            MatrixLog.e(TAG, "supervisor was disabled", new Object[0]);
            return;
        }
        DispatcherStateOwner.Companion.observe((Function2<? super String, ? super Boolean, Unit>)((Function2)new Function2<String, Boolean, Unit>(this){
            final /* synthetic */ SupervisorService this$0;

            public final void invoke(@NotNull String stateName, boolean state) {
                Intrinsics.checkNotNullParameter((Object)stateName, (String)"stateName");
                if (SupervisorService.access$getTokenRecord$p(this.this$0).isEmpty()) {
                    MatrixLog.i("Matrix.ProcessSupervisor.Service", "observe: no other process registered, ignore state changes", new Object[0]);
                    return;
                }
                MatrixLog.d("Matrix.ProcessSupervisor.Service", "supervisor dispatch " + stateName + ' ' + state, new Object[0]);
                ProcessSubordinate.Manager manager2 = ProcessSubordinate.INSTANCE.getManager$matrix_android_lib_release();
                Context context = this.this$0.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                manager2.dispatchState(ProcessToken.Companion.current$default(ProcessToken.Companion, context, null, false, 6, null), SupervisorService.Companion.getRecentScene$matrix_android_lib_release(), stateName, state);
            }
            {
                this.this$0 = supervisorService;
                super(2);
            }
        }));
        SubordinatePacemaker.INSTANCE.notifySupervisorInstalled(this.getApplicationContext());
    }

    @NotNull
    public IBinder onBind(@Nullable Intent intent) {
        MatrixLog.d(TAG, "onBind", new Object[0]);
        return (IBinder)this.binder;
    }

    /*
     * Unable to fully structure code
     */
    public final void backgroundLruKill$matrix_android_lib_release(@NotNull Function3<? super Integer, ? super String, ? super Integer, Unit> killedCallback) {
        block8: {
            Intrinsics.checkNotNullParameter(killedCallback, (String)"killedCallback");
            v0 = ProcessSupervisor.INSTANCE.getConfig$matrix_android_lib_release();
            if (v0 == null || !v0.getEnable()) {
                MatrixLog.e("Matrix.ProcessSupervisor.Service", "supervisor was disabled", new Object[0]);
                return;
            }
            if (!SupervisorService.isSupervisor) {
                throw (Throwable)new IllegalStateException("backgroundLruKill should only be called in supervisor");
            }
            if (SupervisorService.instance == null) {
                throw (Throwable)new IllegalStateException("not initialized yet !");
            }
            this.targetKilledCallback = killedCallback;
            $this$firstOrNull$iv = this.getBackgroundProcessLru();
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                it = (ProcessToken)element$iv;
                $i$a$-firstOrNull-SupervisorService$backgroundLruKill$candidate$1 = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)MatrixUtil.getProcessName((Context)this)) ^ true)) ** GOTO lbl-1000
                v1 = ProcessSupervisor.INSTANCE.getConfig$matrix_android_lib_release();
                Intrinsics.checkNotNull((Object)v1);
                if (!v1.getLruKillerWhiteList().contains(it.getName())) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v3 = element$iv;
                break block8;
            }
            v3 = null;
        }
        candidate = v3;
        if (candidate != null) {
            ProcessSubordinate.INSTANCE.getManager$matrix_android_lib_release().dispatchKill(SupervisorService.recentScene, candidate.getName(), candidate.getPid());
        } else {
            killedCallback.invoke((Object)4, null, (Object)-1);
        }
    }

    static {
        Companion = new Companion(null);
        recentScene = "";
    }

    public static final /* synthetic */ TokenRecord access$getTokenRecord$p(SupervisorService $this) {
        return $this.tokenRecord;
    }

    public static final /* synthetic */ Handler access$getRunningHandler$p(SupervisorService $this) {
        return $this.runningHandler;
    }

    public static final /* synthetic */ void access$moveOrAddFirst(SupervisorService $this, ConcurrentLinkedQueue $this$access_u24moveOrAddFirst, ProcessToken token) {
        $this.moveOrAddFirst($this$access_u24moveOrAddFirst, token);
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$getBackgroundProcessLru$p(SupervisorService $this) {
        return $this.getBackgroundProcessLru();
    }

    public static final /* synthetic */ String access$contentToString(SupervisorService $this, ConcurrentLinkedQueue $this$access_u24contentToString) {
        return $this.contentToString($this$access_u24contentToString);
    }

    public static final /* synthetic */ Function3 access$getTargetKilledCallback$p(SupervisorService $this) {
        return $this.targetKilledCallback;
    }

    public static final /* synthetic */ void access$setTargetKilledCallback$p(SupervisorService $this, Function3 function3) {
        $this.targetKilledCallback = function3;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\fJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0005R'\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR'\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\n\u001a\u0004\b\r\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/tencent/matrix/lifecycle/supervisor/SupervisorService$TokenRecord;", "", "()V", "nameToToken", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/tencent/matrix/lifecycle/supervisor/ProcessToken;", "getNameToToken", "()Ljava/util/concurrent/ConcurrentHashMap;", "nameToToken$delegate", "Lkotlin/Lazy;", "pidToToken", "", "getPidToToken", "pidToToken$delegate", "addToken", "", "token", "getToken", "pid", "name", "isEmpty", "", "removeToken", "matrix-android-lib_release"})
    private static final class TokenRecord {
        private final Lazy pidToToken$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)pidToToken.2.INSTANCE);
        private final Lazy nameToToken$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)nameToToken.2.INSTANCE);

        private final ConcurrentHashMap<Integer, ProcessToken> getPidToToken() {
            Lazy lazy = this.pidToToken$delegate;
            TokenRecord tokenRecord = this;
            Object var3_3 = null;
            boolean bl = false;
            return (ConcurrentHashMap)lazy.getValue();
        }

        private final ConcurrentHashMap<String, ProcessToken> getNameToToken() {
            Lazy lazy = this.nameToToken$delegate;
            TokenRecord tokenRecord = this;
            Object var3_3 = null;
            boolean bl = false;
            return (ConcurrentHashMap)lazy.getValue();
        }

        public final void addToken(@NotNull ProcessToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            ((Map)this.getPidToToken()).put(token.getPid(), token);
            ((Map)this.getNameToToken()).put(token.getName(), token);
        }

        @Nullable
        public final ProcessToken getToken(int pid) {
            return this.getPidToToken().get(pid);
        }

        @Nullable
        public final ProcessToken getToken(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this.getNameToToken().get(name);
        }

        @NotNull
        public final ProcessToken removeToken(int pid) {
            ProcessToken rm;
            ProcessToken processToken = rm = this.getPidToToken().remove(pid);
            if (processToken != null) {
                ProcessToken processToken2 = processToken;
                boolean bl = false;
                boolean bl2 = false;
                ProcessToken it = processToken2;
                boolean bl3 = false;
                this.getNameToToken().remove(rm.getName());
                return rm;
            }
            throw (Throwable)new IllegalStateException("token with pid=" + pid + " not found");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isEmpty() {
            boolean bl;
            if (this.getPidToToken().isEmpty()) return true;
            Map $this$all$iv = this.getPidToToken();
            boolean $i$f$all = false;
            if ($this$all$iv.isEmpty()) {
                return true;
            }
            Map map = $this$all$iv;
            boolean bl2 = false;
            Iterator iterator = map.entrySet().iterator();
            do {
                Map.Entry element$iv;
                if (!iterator.hasNext()) return true;
                Map.Entry it = element$iv = iterator.next();
                boolean bl3 = false;
                if (((Number)it.getKey()).intValue() != Process.myPid()) return false;
                bl = true;
            } while (bl);
            return false;
        }

        @NotNull
        public final ProcessToken removeToken(@NotNull String name) {
            ProcessToken rm;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            ProcessToken processToken = rm = this.getNameToToken().remove(name);
            if (processToken != null) {
                ProcessToken processToken2 = processToken;
                boolean bl = false;
                boolean bl2 = false;
                ProcessToken it = processToken2;
                boolean bl3 = false;
                this.getPidToToken().remove(rm.getPid());
                return rm;
            }
            throw (Throwable)new IllegalStateException("token with name=" + name + " not found");
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/tencent/matrix/lifecycle/supervisor/SupervisorService$RemoteProcessLifecycleProxy;", "Lcom/tencent/matrix/lifecycle/StatefulOwner;", "token", "Lcom/tencent/matrix/lifecycle/supervisor/ProcessToken;", "(Lcom/tencent/matrix/lifecycle/supervisor/ProcessToken;)V", "getToken", "()Lcom/tencent/matrix/lifecycle/supervisor/ProcessToken;", "onStateChanged", "", "state", "", "toString", "", "Companion", "matrix-android-lib_release"})
    private static final class RemoteProcessLifecycleProxy
    extends StatefulOwner {
        @NotNull
        private final ProcessToken token;
        private static final Lazy processProxies$delegate;
        @NotNull
        public static final Companion Companion;

        public final void onStateChanged(boolean state) {
            if (state) {
                this.turnOn();
            } else {
                this.turnOff();
            }
        }

        @NotNull
        public String toString() {
            return "OwnerProxy_" + this.token.getStatefulName() + '_' + this.active() + '@' + this.hashCode() + '_' + this.token.getName() + '_' + this.token.getPid();
        }

        @NotNull
        public final ProcessToken getToken() {
            return this.token;
        }

        public RemoteProcessLifecycleProxy(@NotNull ProcessToken token) {
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            super(false, 1, null);
            this.token = token;
            DispatcherStateOwner.Companion.addSourceOwner(this.token.getStatefulName(), this);
        }

        static {
            Companion = new Companion(null);
            processProxies$delegate = LazyKt.lazy((Function0)Companion.processProxies.2.INSTANCE);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0005R3\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00040\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/tencent/matrix/lifecycle/supervisor/SupervisorService$RemoteProcessLifecycleProxy$Companion;", "", "()V", "processProxies", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/tencent/matrix/lifecycle/supervisor/ProcessToken;", "", "Lcom/tencent/matrix/lifecycle/supervisor/SupervisorService$RemoteProcessLifecycleProxy;", "getProcessProxies", "()Ljava/util/concurrent/ConcurrentHashMap;", "processProxies$delegate", "Lkotlin/Lazy;", "getProxy", "token", "profile", "", "removeProxy", "", "matrix-android-lib_release"})
        public static final class Companion {
            private final ConcurrentHashMap<ProcessToken, ConcurrentHashMap<String, RemoteProcessLifecycleProxy>> getProcessProxies() {
                Lazy lazy = processProxies$delegate;
                Companion companion = Companion;
                Object var3_3 = null;
                boolean bl = false;
                return (ConcurrentHashMap)lazy.getValue();
            }

            @NotNull
            public final RemoteProcessLifecycleProxy getProxy(@NotNull ProcessToken token) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                ConcurrentMap $this$getOrPut$iv = this.getProcessProxies();
                boolean $i$f$getOrPut = false;
                Object object = $this$getOrPut$iv.get(token);
                if (object == null) {
                    boolean bl2 = false;
                    ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
                    boolean bl3 = false;
                    bl = false;
                    ConcurrentHashMap default$iv = concurrentHashMap;
                    boolean bl4 = false;
                    object = $this$getOrPut$iv.putIfAbsent(token, default$iv);
                    if (object == null) {
                        object = default$iv;
                    }
                }
                Intrinsics.checkNotNullExpressionValue(object, (String)"processProxies.getOrPut(\u2026 { ConcurrentHashMap() })");
                $this$getOrPut$iv = (ConcurrentMap)object;
                String key$iv = token.getStatefulName();
                boolean $i$f$getOrPut2 = false;
                Object object2 = $this$getOrPut$iv.get(key$iv);
                if (object2 == null) {
                    boolean bl5 = false;
                    RemoteProcessLifecycleProxy remoteProcessLifecycleProxy = new RemoteProcessLifecycleProxy(token);
                    bl = false;
                    boolean bl6 = false;
                    RemoteProcessLifecycleProxy default$iv = remoteProcessLifecycleProxy;
                    boolean bl7 = false;
                    object2 = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                    if (object2 == null) {
                        object2 = default$iv;
                    }
                }
                Intrinsics.checkNotNull(object2);
                return (RemoteProcessLifecycleProxy)object2;
            }

            public final boolean removeProxy(@NotNull ProcessToken token) {
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                ConcurrentHashMap<String, RemoteProcessLifecycleProxy> proxies = this.getProcessProxies().remove(token);
                if (proxies == null || proxies.isEmpty()) {
                    return false;
                }
                Map $this$forEach$iv = proxies;
                boolean $i$f$forEach = false;
                Map map = $this$forEach$iv;
                boolean bl = false;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl2 = false;
                    DispatcherStateOwner.Companion.removeSourceOwner((String)it.getKey(), (StatefulOwner)it.getValue());
                }
                return true;
            }

            public final void profile() {
                Map $this$forEach$iv = this.getProcessProxies();
                boolean $i$f$forEach = false;
                Map map = $this$forEach$iv;
                boolean bl = false;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl2 = false;
                    Map $this$forEach$iv2 = (Map)it.getValue();
                    boolean $i$f$forEach2 = false;
                    Map map2 = $this$forEach$iv2;
                    boolean bl3 = false;
                    Iterator iterator2 = map2.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        Map.Entry element$iv2;
                        Map.Entry p = element$iv2 = iterator2.next();
                        boolean bl4 = false;
                        MatrixLog.d(SupervisorService.TAG, "===> " + (RemoteProcessLifecycleProxy)p.getValue(), new Object[0]);
                    }
                }
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R(\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\f@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lcom/tencent/matrix/lifecycle/supervisor/SupervisorService$Companion;", "", "()V", "TAG", "", "<set-?>", "Lcom/tencent/matrix/lifecycle/supervisor/SupervisorService;", "instance", "getInstance$matrix_android_lib_release", "()Lcom/tencent/matrix/lifecycle/supervisor/SupervisorService;", "setInstance", "(Lcom/tencent/matrix/lifecycle/supervisor/SupervisorService;)V", "", "isSupervisor", "isSupervisor$matrix_android_lib_release", "()Z", "setSupervisor", "(Z)V", "recentScene", "getRecentScene$matrix_android_lib_release", "()Ljava/lang/String;", "setRecentScene$matrix_android_lib_release", "(Ljava/lang/String;)V", "start", "context", "Landroid/content/Context;", "start$matrix_android_lib_release", "matrix-android-lib_release"})
    public static final class Companion {
        public final boolean isSupervisor$matrix_android_lib_release() {
            return isSupervisor;
        }

        private final void setSupervisor(boolean bl) {
            isSupervisor = bl;
        }

        @NotNull
        public final String getRecentScene$matrix_android_lib_release() {
            return recentScene;
        }

        public final void setRecentScene$matrix_android_lib_release(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            recentScene = string;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Companion start$matrix_android_lib_release(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Companion companion = this;
            String tag$iv = SupervisorService.TAG;
            boolean log$iv = true;
            String msg$iv = "";
            boolean $i$f$safeApply = false;
            try {
                void $this$safeApply$iv;
                Companion $this$safeApply = (Companion)$this$safeApply$iv;
                boolean bl = false;
                if ($this$safeApply.getInstance$matrix_android_lib_release() != null) {
                    MatrixLog.e(SupervisorService.TAG, "duplicated start", new Object[0]);
                } else {
                    SupervisorConfig supervisorConfig = ProcessSupervisor.INSTANCE.getConfig$matrix_android_lib_release();
                    if (supervisorConfig == null || !supervisorConfig.getEnable()) {
                        MatrixLog.e(SupervisorService.TAG, "supervisor was disabled", new Object[0]);
                    } else {
                        Intent intent = new Intent(context, SupervisorService.class);
                        context.startService(intent);
                    }
                }
            }
            catch (Throwable e$iv) {
                MatrixLog.printErrStackTrace(tag$iv, e$iv, msg$iv, new Object[0]);
            }
            return companion;
        }

        @Nullable
        public final SupervisorService getInstance$matrix_android_lib_release() {
            return instance;
        }

        private final void setInstance(SupervisorService supervisorService) {
            instance = supervisorService;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

