/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.util;

import com.tencent.matrix.util.MatrixLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectMethod {
    private static final String TAG = "ReflectFiled";
    private Class<?> mClazz;
    private String mMethodName;
    private boolean mInit;
    private Method mMethod;
    private Class[] mParameterTypes;

    public ReflectMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        if (clazz == null || methodName == null || methodName.length() == 0) {
            throw new IllegalArgumentException("Both of invoker and fieldName can not be null or nil.");
        }
        this.mClazz = clazz;
        this.mMethodName = methodName;
        this.mParameterTypes = parameterTypes;
    }

    private synchronized void prepare() {
        if (this.mInit) {
            return;
        }
        for (Class<?> clazz = this.mClazz; clazz != null; clazz = clazz.getSuperclass()) {
            try {
                Method method = clazz.getDeclaredMethod(this.mMethodName, this.mParameterTypes);
                method.setAccessible(true);
                this.mMethod = method;
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
        this.mInit = true;
    }

    public synchronized <T> T invoke(Object instance, Object ... args) throws NoSuchFieldException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.invoke(instance, false, args);
    }

    public synchronized <T> T invoke(Object instance, boolean ignoreFieldNoExist, Object ... args) throws NoSuchFieldException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.prepare();
        if (this.mMethod == null) {
            if (!ignoreFieldNoExist) {
                throw new NoSuchFieldException("Method " + this.mMethodName + " is not exists.");
            }
            MatrixLog.w(TAG, "Field %s is no exists", this.mMethodName);
            return null;
        }
        return (T)this.mMethod.invoke(instance, args);
    }

    public synchronized <T> T invokeWithoutThrow(Object instance, Object ... args) {
        try {
            return this.invoke(instance, true, args);
        }
        catch (NoSuchFieldException e) {
            MatrixLog.e(TAG, "invokeWithoutThrow, exception occur :%s", e);
        }
        catch (IllegalAccessException e) {
            MatrixLog.e(TAG, "invokeWithoutThrow, exception occur :%s", e);
        }
        catch (IllegalArgumentException e) {
            MatrixLog.e(TAG, "invokeWithoutThrow, exception occur :%s", e);
        }
        catch (InvocationTargetException e) {
            MatrixLog.e(TAG, "invokeWithoutThrow, exception occur :%s", e);
        }
        return null;
    }
}

