/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.lifecycle;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import androidx.annotation.NonNull;
import com.tencent.matrix.lifecycle.MatrixLifecycleConfig;
import com.tencent.matrix.lifecycle.MatrixLifecycleLogger;
import com.tencent.matrix.lifecycle.MatrixLifecycleThread;
import com.tencent.matrix.lifecycle.owners.ForegroundServiceLifecycleOwner;
import com.tencent.matrix.lifecycle.owners.OverlayWindowLifecycleOwner;
import com.tencent.matrix.lifecycle.owners.ProcessUILifecycleOwner;
import com.tencent.matrix.util.MatrixLog;
import java.lang.reflect.Field;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/tencent/matrix/lifecycle/MatrixLifecycleOwnerInitializer;", "", "()V", "Companion", "matrix-android-lib_release"})
public final class MatrixLifecycleOwnerInitializer {
    private static final String TAG = "Matrix.ProcessLifecycleOwnerInit";
    private static volatile boolean inited;
    @NotNull
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
    }

    @JvmStatic
    public static final void init(@NonNull @NotNull Application app, @NotNull MatrixLifecycleConfig config) {
        Companion.init(app, config);
    }

    @JvmStatic
    @SuppressLint(value={"PrivateApi", "DiscouragedPrivateApi"})
    private static final boolean hasCreatedActivities() {
        return MatrixLifecycleOwnerInitializer.Companion.hasCreatedActivities();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0003J\u001a\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/tencent/matrix/lifecycle/MatrixLifecycleOwnerInitializer$Companion;", "", "()V", "TAG", "", "inited", "", "hasCreatedActivities", "init", "", "app", "Landroid/app/Application;", "config", "Lcom/tencent/matrix/lifecycle/MatrixLifecycleConfig;", "matrix-android-lib_release"})
    public static final class Companion {
        @JvmStatic
        public final void init(@NonNull @NotNull Application app, @NotNull MatrixLifecycleConfig config) {
            Intrinsics.checkNotNullParameter((Object)app, (String)"app");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            if (inited) {
                return;
            }
            inited = true;
            if (this.hasCreatedActivities()) {
                String string = "Matrix Warning: Matrix might be inited after launching first Activity, which would disable some features like ProcessLifecycleOwner, pls consider calling MultiProcessLifecycleInitializer#init manually or initializing matrix at Application#onCreate";
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                MatrixLog.e(MatrixLifecycleOwnerInitializer.TAG, it, new Object[0]);
                return;
            }
            MatrixLifecycleThread.INSTANCE.init(config.getLifecycleThreadConfig());
            ProcessUILifecycleOwner.INSTANCE.init$matrix_android_lib_release(app);
            ForegroundServiceLifecycleOwner.INSTANCE.init((Context)app, config.getEnableFgServiceMonitor());
            OverlayWindowLifecycleOwner.INSTANCE.init$matrix_android_lib_release(config.getEnableOverlayWindowMonitor());
            MatrixLifecycleLogger.INSTANCE.init(app, config.getEnableLifecycleLogger());
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @SuppressLint(value={"PrivateApi", "DiscouragedPrivateApi"})
        private final boolean hasCreatedActivities() {
            Companion companion = this;
            String string = MatrixLifecycleOwnerInitializer.TAG;
            boolean defVal$iv = false;
            boolean log$iv = true;
            String msg$iv = "";
            boolean $i$f$safeLet = false;
            try {
                Field fieldMActivities;
                void $this$safeLet$iv;
                Companion it = (Companion)$this$safeLet$iv;
                boolean bl = false;
                Class<?> clazzActivityThread = Class.forName("android.app.ActivityThread");
                Object objectActivityThread = clazzActivityThread.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
                Field field = fieldMActivities = clazzActivityThread.getDeclaredField("mActivities");
                Intrinsics.checkNotNullExpressionValue((Object)field, (String)"fieldMActivities");
                field.setAccessible(true);
                Map mActivities = (Map)fieldMActivities.get(objectActivityThread);
                if (mActivities == null) return false;
                Map map = mActivities;
                boolean bl2 = false;
                if (map.isEmpty()) return false;
                return true;
            }
            catch (Throwable e$iv) {
                void tag$iv;
                MatrixLog.printErrStackTrace((String)tag$iv, e$iv, msg$iv, new Object[0]);
                return defVal$iv;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

