/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.lifecycle.owners;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.matrix.util.MatrixLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

class ArrayListProxy<T>
extends ArrayList<T> {
    private static final String TAG = "Matrix.ArrayListProxy";
    private final ArrayList<T> mOrigin;
    private final OnDataChangedListener mListener;

    ArrayListProxy(ArrayList<T> origin, OnDataChangedListener listener) {
        this.mOrigin = origin;
        this.mListener = listener;
    }

    @Override
    public int size() {
        return this.mOrigin.size();
    }

    @Override
    public boolean isEmpty() {
        return this.mOrigin.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.mOrigin.contains(o);
    }

    @Override
    @NonNull
    public Iterator<T> iterator() {
        return this.mOrigin.iterator();
    }

    @Override
    @NonNull
    public Object[] toArray() {
        return this.mOrigin.toArray();
    }

    @Override
    @NonNull
    public <T1> T1[] toArray(@NonNull T1[] a) {
        return this.mOrigin.toArray(a);
    }

    @Override
    public boolean add(T t) {
        boolean ret = this.mOrigin.add(t);
        try {
            this.mListener.onAdded(t);
        }
        catch (Throwable e) {
            MatrixLog.printErrStackTrace(TAG, e, "", new Object[0]);
        }
        return ret;
    }

    @Override
    public boolean remove(@Nullable Object o) {
        boolean ret = this.mOrigin.remove(o);
        try {
            this.mListener.onRemoved(o);
        }
        catch (Throwable e) {
            MatrixLog.printErrStackTrace(TAG, e, "", new Object[0]);
        }
        return ret;
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        return this.mOrigin.containsAll(c);
    }

    @Override
    public boolean addAll(@NonNull Collection<? extends T> c) {
        boolean ret = this.mOrigin.addAll(c);
        try {
            for (T t : c) {
                this.mListener.onAdded(t);
            }
        }
        catch (Throwable e) {
            MatrixLog.printErrStackTrace(TAG, e, "", new Object[0]);
        }
        return ret;
    }

    @Override
    public boolean addAll(int index, @NonNull Collection<? extends T> c) {
        boolean ret = this.mOrigin.addAll(index, c);
        try {
            for (T t : c) {
                this.mListener.onAdded(t);
            }
        }
        catch (Throwable e) {
            MatrixLog.printErrStackTrace(TAG, e, "", new Object[0]);
        }
        return ret;
    }

    @Override
    public boolean removeAll(@NonNull Collection<?> c) {
        boolean ret = this.mOrigin.removeAll(c);
        try {
            for (Object o : c) {
                this.mListener.onRemoved(o);
            }
        }
        catch (Throwable e) {
            MatrixLog.printErrStackTrace(TAG, e, "", new Object[0]);
        }
        return ret;
    }

    @Override
    public boolean retainAll(@NonNull Collection<?> c) {
        return this.mOrigin.retainAll(c);
    }

    @Override
    public void clear() {
        this.mOrigin.clear();
    }

    @Override
    public T get(int index) {
        return this.mOrigin.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.mOrigin.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.mOrigin.add(index, element);
        try {
            this.mListener.onAdded(element);
        }
        catch (Throwable e) {
            MatrixLog.printErrStackTrace(TAG, e, "", new Object[0]);
        }
    }

    @Override
    public T remove(int index) {
        T ret = this.mOrigin.remove(index);
        try {
            this.mListener.onRemoved(ret);
        }
        catch (Throwable e) {
            MatrixLog.printErrStackTrace(TAG, e, "", new Object[0]);
        }
        return ret;
    }

    @Override
    public int indexOf(@Nullable Object o) {
        return this.mOrigin.indexOf(o);
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return this.mOrigin.lastIndexOf(o);
    }

    @Override
    @NonNull
    public ListIterator<T> listIterator() {
        return this.mOrigin.listIterator();
    }

    @Override
    @NonNull
    public ListIterator<T> listIterator(int index) {
        return this.mOrigin.listIterator(index);
    }

    @Override
    @NonNull
    public List<T> subList(int fromIndex, int toIndex) {
        return this.mOrigin.subList(fromIndex, toIndex);
    }

    static interface OnDataChangedListener {
        public void onAdded(Object var1);

        public void onRemoved(Object var1);
    }
}

