/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.lifecycle.supervisor;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.tencent.matrix.lifecycle.supervisor.ISubordinateProxy;
import com.tencent.matrix.lifecycle.supervisor.ProcessToken;

public interface ISupervisorProxy
extends IInterface {
    public void registerSubordinate(ProcessToken[] var1, ISubordinateProxy var2) throws RemoteException;

    public void onStateChanged(ProcessToken var1) throws RemoteException;

    public void onSceneChanged(String var1) throws RemoteException;

    public void onProcessKilled(ProcessToken var1) throws RemoteException;

    public void onProcessRescuedFromKill(ProcessToken var1) throws RemoteException;

    public void onProcessKillCanceled(ProcessToken var1) throws RemoteException;

    public String getRecentScene() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISupervisorProxy {
        private static final String DESCRIPTOR = "com.tencent.matrix.lifecycle.supervisor.ISupervisorProxy";
        static final int TRANSACTION_registerSubordinate = 1;
        static final int TRANSACTION_onStateChanged = 2;
        static final int TRANSACTION_onSceneChanged = 3;
        static final int TRANSACTION_onProcessKilled = 4;
        static final int TRANSACTION_onProcessRescuedFromKill = 5;
        static final int TRANSACTION_onProcessKillCanceled = 6;
        static final int TRANSACTION_getRecentScene = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISupervisorProxy asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISupervisorProxy) {
                return (ISupervisorProxy)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    ProcessToken[] _arg0 = (ProcessToken[])data.createTypedArray(ProcessToken.CREATOR);
                    ISubordinateProxy _arg1 = ISubordinateProxy.Stub.asInterface(data.readStrongBinder());
                    this.registerSubordinate(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    ProcessToken _arg0 = 0 != data.readInt() ? (ProcessToken)ProcessToken.CREATOR.createFromParcel(data) : null;
                    this.onStateChanged(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.onSceneChanged(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    ProcessToken _arg0 = 0 != data.readInt() ? (ProcessToken)ProcessToken.CREATOR.createFromParcel(data) : null;
                    this.onProcessKilled(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    ProcessToken _arg0 = 0 != data.readInt() ? (ProcessToken)ProcessToken.CREATOR.createFromParcel(data) : null;
                    this.onProcessRescuedFromKill(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    ProcessToken _arg0 = 0 != data.readInt() ? (ProcessToken)ProcessToken.CREATOR.createFromParcel(data) : null;
                    this.onProcessKillCanceled(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    String _result = this.getRecentScene();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ISupervisorProxy impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ISupervisorProxy getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ISupervisorProxy {
            private IBinder mRemote;
            public static ISupervisorProxy sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSubordinate(ProcessToken[] tokens, ISubordinateProxy subordinateProxy) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedArray((Parcelable[])tokens, 0);
                    _data.writeStrongBinder(subordinateProxy != null ? subordinateProxy.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerSubordinate(tokens, subordinateProxy);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStateChanged(ProcessToken token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (token != null) {
                        _data.writeInt(1);
                        token.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onStateChanged(token);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSceneChanged(String scene) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(scene);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSceneChanged(scene);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProcessKilled(ProcessToken token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (token != null) {
                        _data.writeInt(1);
                        token.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onProcessKilled(token);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProcessRescuedFromKill(ProcessToken token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (token != null) {
                        _data.writeInt(1);
                        token.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onProcessRescuedFromKill(token);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProcessKillCanceled(ProcessToken token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (token != null) {
                        _data.writeInt(1);
                        token.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onProcessKillCanceled(token);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getRecentScene() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string = Stub.getDefaultImpl().getRecentScene();
                        return string;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ISupervisorProxy {
        @Override
        public void registerSubordinate(ProcessToken[] tokens, ISubordinateProxy subordinateProxy) throws RemoteException {
        }

        @Override
        public void onStateChanged(ProcessToken token) throws RemoteException {
        }

        @Override
        public void onSceneChanged(String scene) throws RemoteException {
        }

        @Override
        public void onProcessKilled(ProcessToken token) throws RemoteException {
        }

        @Override
        public void onProcessRescuedFromKill(ProcessToken token) throws RemoteException {
        }

        @Override
        public void onProcessKillCanceled(ProcessToken token) throws RemoteException {
        }

        @Override
        public String getRecentScene() throws RemoteException {
            return null;
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

