/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Printer;
import com.tencent.matrix.lifecycle.owners.ProcessUILifecycleOwner;
import com.tencent.matrix.listeners.IAppForeground;
import com.tencent.matrix.util.MatrixLog;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;

public class MatrixHandlerThread {
    private static final String TAG = "Matrix.HandlerThread";
    public static final String MATRIX_THREAD_NAME = "default_matrix_thread";
    private static volatile HandlerThread defaultHandlerThread;
    private static volatile Handler defaultHandler;
    private static volatile Handler defaultMainHandler;
    private static HashSet<HandlerThread> handlerThreads;
    public static boolean isDebug;

    public static Handler getDefaultMainHandler() {
        return defaultMainHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HandlerThread getDefaultHandlerThread() {
        Class<MatrixHandlerThread> clazz = MatrixHandlerThread.class;
        synchronized (MatrixHandlerThread.class) {
            if (null == defaultHandlerThread) {
                defaultHandlerThread = new HandlerThread(MATRIX_THREAD_NAME);
                defaultHandlerThread.start();
                defaultHandler = new Handler(defaultHandlerThread.getLooper());
                defaultHandlerThread.getLooper().setMessageLogging((Printer)(isDebug ? new LooperPrinter() : null));
                MatrixLog.w(TAG, "create default handler thread, we should use these thread normal, isDebug:%s", isDebug);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultHandlerThread;
        }
    }

    public static Handler getDefaultHandler() {
        if (defaultHandler == null) {
            MatrixHandlerThread.getDefaultHandlerThread();
        }
        return defaultHandler;
    }

    public static synchronized HandlerThread getNewHandlerThread(String name, int priority) {
        Iterator<HandlerThread> i = handlerThreads.iterator();
        while (i.hasNext()) {
            HandlerThread element = i.next();
            if (element.isAlive()) continue;
            i.remove();
            MatrixLog.w(TAG, "warning: remove dead handler thread with name %s", name);
        }
        HandlerThread handlerThread = new HandlerThread(name);
        handlerThread.setPriority(priority);
        handlerThread.start();
        handlerThreads.add(handlerThread);
        MatrixLog.w(TAG, "warning: create new handler thread with name %s, alive thread size:%d", name, handlerThreads.size());
        return handlerThread;
    }

    static {
        defaultMainHandler = new Handler(Looper.getMainLooper());
        handlerThreads = new HashSet();
        isDebug = false;
    }

    private static final class LooperPrinter
    implements Printer,
    IAppForeground {
        private ConcurrentHashMap<String, Info> hashMap = new ConcurrentHashMap();
        private boolean isForeground;

        LooperPrinter() {
            ProcessUILifecycleOwner.INSTANCE.addListener(this);
            this.isForeground = ProcessUILifecycleOwner.INSTANCE.isProcessForeground();
        }

        public void println(String x) {
            if (this.isForeground) {
                return;
            }
            if (x.charAt(0) == '>') {
                int start = x.indexOf("} ");
                int end = x.indexOf("@", start);
                if (start < 0 || end < 0) {
                    return;
                }
                String content = x.substring(start, end);
                Info info = this.hashMap.get(content);
                if (info == null) {
                    info = new Info();
                    info.key = content;
                    this.hashMap.put(content, info);
                }
                ++info.count;
            }
        }

        @Override
        public void onForeground(boolean isForeground) {
            this.isForeground = isForeground;
            if (isForeground) {
                long start = System.currentTimeMillis();
                LinkedList<Info> list = new LinkedList<Info>();
                for (Info info : this.hashMap.values()) {
                    if (info.count <= 1) continue;
                    list.add(info);
                }
                Collections.sort(list, new Comparator<Info>(){

                    @Override
                    public int compare(Info o1, Info o2) {
                        return o2.count - o1.count;
                    }
                });
                this.hashMap.clear();
                if (!list.isEmpty()) {
                    MatrixLog.i(MatrixHandlerThread.TAG, "matrix default thread has exec in background! %s cost:%s", list, System.currentTimeMillis() - start);
                }
            } else {
                this.hashMap.clear();
            }
        }

        class Info {
            String key;
            int count;

            Info() {
            }

            public String toString() {
                return this.key + ":" + this.count;
            }
        }
    }
}

