/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.util;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import com.tencent.matrix.util.MatrixLog;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public final class MatrixUtil {
    private static final String TAG = "Matrix.MatrixUtil";
    private static String processName = null;
    private static String packageName = null;
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final ThreadLocal<MessageDigest> MD5_DIGEST = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Initialize MD5 failed.", e);
            }
        }
    };
    private static final ThreadLocal<MessageDigest> SHA256_DIGEST = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Initialize SHA256-DIGEST failed.", e);
            }
        }
    };

    private MatrixUtil() {
    }

    public static String formatTime(String format, long timeMilliSecond) {
        return new SimpleDateFormat(format).format(new Date(timeMilliSecond));
    }

    @Deprecated
    public static boolean isInMainThread(long threadId) {
        return Looper.getMainLooper().getThread().getId() == threadId;
    }

    public static boolean isInMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static boolean isInMainProcess(Context context) {
        String pkgName = context.getPackageName();
        String processName = MatrixUtil.getProcessName(context);
        if (processName == null || processName.length() == 0) {
            processName = "";
        }
        return pkgName.equals(processName);
    }

    public static boolean isMainProcessName(String processName, Context context) {
        String pkgName = context.getPackageName();
        return Objects.equals(pkgName, processName);
    }

    public static String getPackageName(Context context) {
        if (packageName != null) {
            return packageName;
        }
        packageName = context.getPackageName();
        return packageName;
    }

    public static String getProcessName(Context context) {
        if (processName != null) {
            return processName;
        }
        processName = MatrixUtil.getProcessNameInternal(context);
        return processName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcessNameInternal(Context context) {
        List appProcessList;
        int myPid = Process.myPid();
        if (context == null || myPid <= 0) {
            return "";
        }
        ActivityManager.RunningAppProcessInfo myProcess = null;
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        if (activityManager != null && (appProcessList = activityManager.getRunningAppProcesses()) != null) {
            try {
                for (ActivityManager.RunningAppProcessInfo process : appProcessList) {
                    if (process.pid != myPid) continue;
                    myProcess = process;
                    break;
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)("getProcessNameInternal exception:" + e.getMessage()));
            }
            if (myProcess != null) {
                return myProcess.processName;
            }
        }
        byte[] b = new byte[128];
        FileInputStream in = null;
        try {
            in = new FileInputStream("/proc/" + myPid + "/cmdline");
            int len = in.read(b);
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    if (b[i] > 0) continue;
                    len = i;
                    break;
                }
                String string = new String(b, 0, len, Charset.forName("UTF-8"));
                return string;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getProcessNameInternal exception:" + e.getMessage()));
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)e.getMessage());
            }
        }
        return "";
    }

    public static String getLatestStack(String stack, int count) {
        if (stack == null || stack.isEmpty()) {
            return "";
        }
        String[] strings = stack.split("\n");
        if (strings.length <= count) {
            return stack;
        }
        StringBuffer sb = new StringBuffer(count);
        for (int i = 0; i < count; ++i) {
            sb.append(strings[i]).append('\n');
        }
        return sb.toString();
    }

    public static String printException(Exception e) {
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace == null) {
            return "";
        }
        StringBuilder t = new StringBuilder(e.toString());
        for (int i = 2; i < stackTrace.length; ++i) {
            t.append('[');
            t.append(stackTrace[i].getClassName());
            t.append(':');
            t.append(stackTrace[i].getMethodName());
            t.append("(" + stackTrace[i].getLineNumber() + ")]");
            t.append("\n");
        }
        return t.toString();
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to close resource", (Throwable)e);
        }
    }

    public static String getMD5String(String s) {
        return MatrixUtil.getMD5String(s.getBytes());
    }

    public static String getMD5String(byte[] bytes) {
        MessageDigest digest = MD5_DIGEST.get();
        return MatrixUtil.bufferToHex(digest.digest(bytes));
    }

    private static byte[] getSHA(String input) throws NoSuchAlgorithmException {
        MessageDigest md = SHA256_DIGEST.get();
        return md.digest(input.getBytes(StandardCharsets.UTF_8));
    }

    private static String toHexString(byte[] hash) {
        BigInteger number = new BigInteger(1, hash);
        StringBuilder hexString = new StringBuilder(number.toString(16));
        while (hexString.length() < 32) {
            hexString.insert(0, '0');
        }
        return hexString.toString();
    }

    public static String getSHA256String(String s) throws NoSuchAlgorithmException {
        return MatrixUtil.toHexString(MatrixUtil.getSHA(s));
    }

    private static String bufferToHex(byte[] bytes) {
        return MatrixUtil.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        for (int l = m; l < k; ++l) {
            MatrixUtil.appendHexPair(bytes[l], stringbuffer);
        }
        return stringbuffer.toString();
    }

    private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char c0 = hexDigits[(bt & 0xF0) >> 4];
        char c1 = hexDigits[bt & 0xF];
        stringbuffer.append(c0);
        stringbuffer.append(c1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromFile(String filePath) throws IOException {
        String ret;
        File fl = new File(filePath);
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(fl);
            ret = MatrixUtil.convertStreamToString(fin);
        }
        finally {
            if (null != fin) {
                fin.close();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) throws IOException {
        BufferedReader reader = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
        return sb.toString();
    }

    public static long parseLong(String string, long def) {
        try {
            return string == null || string.length() <= 0 ? def : Long.decode(string);
        }
        catch (NumberFormatException e) {
            MatrixLog.w(TAG, "parseLong error: " + e.getMessage(), new Object[0]);
            return def;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printFileByLine(String printTAG, String filePath) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(filePath)), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                MatrixLog.i(printTAG, line, new Object[0]);
            }
        }
        catch (Throwable t) {
            MatrixLog.e(printTAG, "printFileByLine failed e : " + t.getMessage(), new Object[0]);
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static String getTopActivityName() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

