/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.arscutil.data;

import com.tencent.mm.arscutil.data.ResChunk;
import com.tencent.mm.arscutil.data.ResStringBlock;
import com.tencent.mm.arscutil.data.ResType;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.List;

public class ResPackage
extends ResChunk {
    private int id;
    private byte[] name;
    private int resTypePoolOffset;
    private int lastPublicType;
    private int resNamePoolOffset;
    private int lastPublicName;
    private ResStringBlock resTypePool;
    private ResStringBlock resNamePool;
    private List<ResChunk> resTypeArray;
    private ResStringBlock resProguardPool;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public byte[] getName() {
        return this.name;
    }

    public void setName(byte[] name) {
        this.name = name;
    }

    public int getResTypePoolOffset() {
        return this.resTypePoolOffset;
    }

    public void setResTypePoolOffset(int resTypePoolOffset) {
        this.resTypePoolOffset = resTypePoolOffset;
    }

    public int getLastPublicType() {
        return this.lastPublicType;
    }

    public void setLastPublicType(int lastPublicType) {
        this.lastPublicType = lastPublicType;
    }

    public int getResNamePoolOffset() {
        return this.resNamePoolOffset;
    }

    public void setResNamePoolOffset(int resNamePoolOffset) {
        this.resNamePoolOffset = resNamePoolOffset;
    }

    public int getLastPublicName() {
        return this.lastPublicName;
    }

    public void setLastPublicName(int lastPublicName) {
        this.lastPublicName = lastPublicName;
    }

    public ResStringBlock getResTypePool() {
        return this.resTypePool;
    }

    public void setResTypePool(ResStringBlock resTypePool) {
        this.resTypePool = resTypePool;
    }

    public ResStringBlock getResNamePool() {
        return this.resNamePool;
    }

    public void setResNamePool(ResStringBlock resNamePool) {
        this.resNamePool = resNamePool;
    }

    public ResStringBlock getResProguardPool() {
        return this.resProguardPool;
    }

    public void setResProguardPool(ResStringBlock resProguardPool) {
        this.resProguardPool = resProguardPool;
    }

    public List<ResChunk> getResTypeArray() {
        return this.resTypeArray;
    }

    public void setResTypeArray(List<ResChunk> resTypes) {
        this.resTypeArray = resTypes;
    }

    public void refresh() {
        if (this.resProguardPool != null) {
            this.resNamePool = this.resProguardPool;
            this.resNamePool.refresh();
        }
        this.recomputeChunkSize();
    }

    public void shrinkResNameStringPool() {
        HashMap<Integer, Integer> countMap = new HashMap<Integer, Integer>();
        for (ResChunk resType : this.resTypeArray) {
            if (resType.getType() != 513) continue;
            for (int index : ((ResType)resType).getResNameStringCountMap().keySet()) {
                if (!countMap.containsKey(index)) {
                    countMap.put(index, 0);
                }
                countMap.put(index, (Integer)countMap.get(index) + ((ResType)resType).getResNameStringCountMap().get(index));
            }
        }
        for (int index = 0; index < this.resNamePool.getStringCount(); ++index) {
            if (countMap.containsKey(index)) continue;
            this.resNamePool.getStrings().set(index, ByteBuffer.wrap(ResStringBlock.encodeStringPoolEntry("", this.resNamePool.getCharSet())));
        }
        this.resNamePool.refresh();
    }

    private void recomputeChunkSize() {
        this.chunkSize = 0;
        this.chunkSize += this.headSize;
        if (this.resTypePool != null) {
            this.chunkSize += this.resTypePool.getChunkSize();
        }
        if (this.resNamePool != null) {
            this.chunkSize += this.resNamePool.getChunkSize();
        }
        if (this.resTypeArray != null) {
            for (ResChunk resType : this.resTypeArray) {
                if (resType == null) continue;
                this.chunkSize += resType.getChunkSize();
            }
        }
        if (this.chunkSize % 4 != 0) {
            this.chunkPadding = 4 - this.chunkSize % 4;
            this.chunkSize += this.chunkPadding;
        } else {
            this.chunkPadding = 0;
        }
    }

    @Override
    public byte[] toBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.chunkSize);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.clear();
        byteBuffer.putShort(this.type);
        byteBuffer.putShort(this.headSize);
        byteBuffer.putInt(this.chunkSize);
        byteBuffer.putInt(this.id);
        byteBuffer.put(this.name);
        byteBuffer.putInt(this.resTypePoolOffset);
        byteBuffer.putInt(this.lastPublicType);
        byteBuffer.putInt(this.resNamePoolOffset);
        byteBuffer.putInt(this.lastPublicName);
        if (this.headPadding > 0) {
            byteBuffer.put(new byte[this.headPadding]);
        }
        if (this.resTypePool != null) {
            byteBuffer.put(this.resTypePool.toBytes());
        }
        if (this.resNamePool != null) {
            byteBuffer.put(this.resNamePool.toBytes());
        }
        if (this.resTypeArray != null && !this.resTypeArray.isEmpty()) {
            for (ResChunk resChunk : this.resTypeArray) {
                if (resChunk.chunkSize <= 0) continue;
                byteBuffer.put(resChunk.toBytes());
            }
        }
        if (this.chunkPadding > 0) {
            byteBuffer.put(new byte[this.chunkPadding]);
        }
        byteBuffer.flip();
        return byteBuffer.array();
    }
}

