/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.arscutil.data;

import com.tencent.mm.arscutil.data.ResChunk;
import com.tencent.mm.arscutil.data.ResConfig;
import com.tencent.mm.arscutil.data.ResEntry;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResType
extends ResChunk {
    private static final String TAG = "ArscUtil.ResType";
    private byte id;
    private byte reserved0;
    private short reserved1;
    private int entryCount;
    private int entryTableOffset;
    private ResConfig resConfigFlags;
    private List<Integer> entryOffsets;
    private List<ResEntry> entryTable;
    private Map<Integer, Integer> resNameStringCountMap = new HashMap<Integer, Integer>();

    public byte getId() {
        return this.id;
    }

    public void setId(byte id) {
        this.id = id;
    }

    public byte getReserved0() {
        return this.reserved0;
    }

    public void setReserved0(byte reserved0) {
        this.reserved0 = reserved0;
    }

    public short getReserved1() {
        return this.reserved1;
    }

    public void setReserved1(short reserved1) {
        this.reserved1 = reserved1;
    }

    public int getEntryCount() {
        return this.entryCount;
    }

    public void setEntryCount(int entryCount) {
        this.entryCount = entryCount;
    }

    public int getEntryTableOffset() {
        return this.entryTableOffset;
    }

    public void setEntryTableOffset(int entryTableOffset) {
        this.entryTableOffset = entryTableOffset;
    }

    public ResConfig getResConfigFlags() {
        return this.resConfigFlags;
    }

    public void setResConfigFlags(ResConfig resConfigFlags) {
        this.resConfigFlags = resConfigFlags;
    }

    public List<Integer> getEntryOffsets() {
        return this.entryOffsets;
    }

    public void setEntryOffsets(List<Integer> entryOffsets) {
        this.entryOffsets = entryOffsets;
    }

    public List<ResEntry> getEntryTable() {
        return this.entryTable;
    }

    public void setEntryTable(List<ResEntry> entryTable) {
        this.entryTable = entryTable;
        if (entryTable != null) {
            this.updateResNameReferenceCount();
        }
    }

    public Map<Integer, Integer> getResNameStringCountMap() {
        return this.resNameStringCountMap;
    }

    public void removeEntry(int entryId) {
        this.getEntryTable().set(entryId, null);
        this.getEntryOffsets().set(entryId, -1);
    }

    private void updateResNameReferenceCount() {
        this.resNameStringCountMap.clear();
        for (int i = 0; i < this.entryCount; ++i) {
            if (this.entryTable.get(i) == null) continue;
            int resNameStringPoolIndex = this.entryTable.get((int)i).stringPoolIndex;
            if (!this.resNameStringCountMap.containsKey(resNameStringPoolIndex)) {
                this.resNameStringCountMap.put(resNameStringPoolIndex, 0);
            }
            this.resNameStringCountMap.put(resNameStringPoolIndex, this.resNameStringCountMap.get(resNameStringPoolIndex) + 1);
        }
    }

    public void refresh() {
        if (this.entryTable != null) {
            int lastOffset = 0;
            for (int i = 0; i < this.entryCount; ++i) {
                if (this.entryOffsets.get(i) == -1) continue;
                this.entryOffsets.set(i, lastOffset);
                lastOffset += this.entryTable.get(i).toBytes().length;
            }
            this.updateResNameReferenceCount();
        }
        this.recomputeChunkSize();
    }

    private void recomputeChunkSize() {
        this.chunkSize = 0;
        this.chunkSize += this.headSize;
        int realEntryCount = 0;
        if (this.entryOffsets != null) {
            this.chunkSize += this.entryOffsets.size() * 4;
        }
        if (this.entryTable != null) {
            for (ResEntry entry : this.entryTable) {
                if (entry == null) continue;
                ++realEntryCount;
                this.chunkSize += entry.toBytes().length;
            }
        }
        if (realEntryCount == 0) {
            this.entryCount = 0;
            this.chunkSize = 0;
            this.chunkPadding = 0;
        } else if (this.chunkSize % 4 != 0) {
            this.chunkPadding = 4 - this.chunkSize % 4;
            this.chunkSize += this.chunkPadding;
        } else {
            this.chunkPadding = 0;
        }
    }

    @Override
    public byte[] toBytes() {
        int i;
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.chunkSize);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.clear();
        byteBuffer.putShort(this.type);
        byteBuffer.putShort(this.headSize);
        byteBuffer.putInt(this.chunkSize);
        byteBuffer.put(this.id);
        byteBuffer.put(this.reserved0);
        byteBuffer.putShort(this.reserved1);
        byteBuffer.putInt(this.entryCount);
        byteBuffer.putInt(this.entryTableOffset);
        if (this.resConfigFlags != null) {
            byteBuffer.put(this.resConfigFlags.toBytes());
        }
        if (this.headPadding > 0) {
            byteBuffer.put(new byte[this.headPadding]);
        }
        if (this.entryOffsets != null) {
            for (i = 0; i < this.entryOffsets.size(); ++i) {
                byteBuffer.putInt(this.entryOffsets.get(i));
            }
        }
        if (this.entryTable != null) {
            for (i = 0; i < this.entryTable.size(); ++i) {
                if (this.entryTable.get(i) == null) continue;
                byteBuffer.put(this.entryTable.get(i).toBytes());
            }
        }
        if (this.chunkPadding > 0) {
            byteBuffer.put(new byte[this.chunkPadding]);
        }
        byteBuffer.flip();
        return byteBuffer.array();
    }
}

