/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.arscutil.io;

import com.tencent.matrix.javalib.util.Log;
import com.tencent.mm.arscutil.ArscUtil;
import com.tencent.mm.arscutil.data.ResChunk;
import com.tencent.mm.arscutil.data.ResConfig;
import com.tencent.mm.arscutil.data.ResEntry;
import com.tencent.mm.arscutil.data.ResMapValue;
import com.tencent.mm.arscutil.data.ResPackage;
import com.tencent.mm.arscutil.data.ResStringBlock;
import com.tencent.mm.arscutil.data.ResTable;
import com.tencent.mm.arscutil.data.ResType;
import com.tencent.mm.arscutil.data.ResTypeSpec;
import com.tencent.mm.arscutil.data.ResValue;
import com.tencent.mm.arscutil.io.LittleEndianInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;

public class ArscReader {
    private static final String TAG = "ArscUtil.ArscReader";
    LittleEndianInputStream dataInput;
    private ResTable globalResTable;

    public ArscReader(String arscFile) throws FileNotFoundException {
        this.dataInput = new LittleEndianInputStream(arscFile);
        Log.i((String)TAG, (String)"read From %s", (Object[])new Object[]{arscFile});
    }

    public ResTable readResourceTable() throws IOException {
        ResTable resTable;
        Log.d((String)TAG, (String)"=============ResTable==============", (Object[])new Object[0]);
        long headStart = 0L;
        this.globalResTable = resTable = new ResTable();
        resTable.setStart(headStart);
        resTable.setType(this.dataInput.readShort());
        Log.d((String)TAG, (String)"table type %d", (Object[])new Object[]{resTable.getType()});
        resTable.setHeadSize(this.dataInput.readShort());
        Log.d((String)TAG, (String)"head size %d", (Object[])new Object[]{resTable.getHeadSize()});
        resTable.setChunkSize(this.dataInput.readInt());
        Log.d((String)TAG, (String)"chunk size %f KB", (Object[])new Object[]{Float.valueOf((float)resTable.getChunkSize() / 1024.0f)});
        resTable.setPackageCount(this.dataInput.readInt());
        Log.d((String)TAG, (String)"package count %d", (Object[])new Object[]{resTable.getPackageCount()});
        int headPaddingSize = (int)((long)resTable.getHeadSize() + headStart - this.dataInput.getFilePointer());
        Log.d((String)TAG, (String)"head padding size %d", (Object[])new Object[]{headPaddingSize});
        resTable.setHeadPadding(headPaddingSize);
        resTable.setGlobalStringPool(this.readStringBlock());
        Log.d((String)TAG, (String)"global string pool pos %d", (Object[])new Object[]{this.dataInput.getFilePointer()});
        if (resTable.getPackageCount() > 0) {
            ResPackage[] packages = new ResPackage[resTable.getPackageCount()];
            for (int i = 0; i < resTable.getPackageCount(); ++i) {
                packages[i] = this.readPackage();
            }
            resTable.setPackages(packages);
        }
        int chunkPaddingSize = (int)((long)resTable.getChunkSize() + headStart - this.dataInput.getFilePointer());
        Log.d((String)TAG, (String)"chunk padding size %d", (Object[])new Object[]{chunkPaddingSize});
        resTable.setChunkPadding(chunkPaddingSize);
        this.dataInput.close();
        return resTable;
    }

    private ResPackage readPackage() throws IOException {
        Log.d((String)TAG, (String)"=============ResPackage==============", (Object[])new Object[0]);
        long headStart = this.dataInput.getFilePointer();
        Log.d((String)TAG, (String)"package start %d", (Object[])new Object[]{headStart});
        ResPackage resPackage = new ResPackage();
        resPackage.setStart(headStart);
        resPackage.setType(this.dataInput.readShort());
        Log.d((String)TAG, (String)"package type %d", (Object[])new Object[]{resPackage.getType()});
        resPackage.setHeadSize(this.dataInput.readShort());
        Log.d((String)TAG, (String)"head size %d", (Object[])new Object[]{resPackage.getHeadSize()});
        resPackage.setChunkSize(this.dataInput.readInt());
        Log.d((String)TAG, (String)"chunk size %d", (Object[])new Object[]{resPackage.getChunkSize()});
        resPackage.setId(this.dataInput.readInt());
        Log.d((String)TAG, (String)"package id %d", (Object[])new Object[]{resPackage.getId()});
        byte[] buffer = new byte[256];
        this.dataInput.read(buffer);
        resPackage.setName(buffer);
        Log.d((String)TAG, (String)"package name %s", (Object[])new Object[]{ArscUtil.toUTF16String(buffer)});
        resPackage.setResTypePoolOffset(this.dataInput.readInt());
        Log.d((String)TAG, (String)"resType pool offset %d", (Object[])new Object[]{resPackage.getResTypePoolOffset()});
        resPackage.setLastPublicType(this.dataInput.readInt());
        resPackage.setResNamePoolOffset(this.dataInput.readInt());
        Log.d((String)TAG, (String)"resName pool offset %d", (Object[])new Object[]{resPackage.getResNamePoolOffset()});
        resPackage.setLastPublicName(this.dataInput.readInt());
        int headPaddingSize = (int)((long)resPackage.getHeadSize() + headStart - this.dataInput.getFilePointer());
        Log.d((String)TAG, (String)"head padding size %d", (Object[])new Object[]{headPaddingSize});
        resPackage.setHeadPadding(headPaddingSize);
        if (resPackage.getResTypePoolOffset() > 0) {
            this.dataInput.seek(headStart + (long)resPackage.getResTypePoolOffset());
            ResStringBlock resTypePool = this.readStringBlock();
            resPackage.setResTypePool(resTypePool);
        }
        if (resPackage.getResNamePoolOffset() > 0) {
            this.dataInput.seek(headStart + (long)resPackage.getResNamePoolOffset());
            ResStringBlock resNamePool = this.readStringBlock();
            resPackage.setResNamePool(resNamePool);
        }
        ArrayList<ResChunk> resTypeList = new ArrayList<ResChunk>();
        while (this.dataInput.getFilePointer() < resPackage.getStart() + (long)resPackage.getChunkSize()) {
            short type = this.dataInput.readShort();
            if (type == 514) {
                this.dataInput.seek(this.dataInput.getFilePointer() - 2L);
                ResTypeSpec resTypeSpec = this.readResTypeSpec();
                resTypeList.add(resTypeSpec);
                continue;
            }
            if (type != 513) continue;
            this.dataInput.seek(this.dataInput.getFilePointer() - 2L);
            ResType resType = this.readResType(resPackage);
            resTypeList.add(resType);
        }
        resPackage.setResTypeArray(resTypeList);
        int chunkPaddingSize = (int)((long)resPackage.getChunkSize() + headStart - this.dataInput.getFilePointer());
        Log.d((String)TAG, (String)"chunk padding size %d", (Object[])new Object[]{chunkPaddingSize});
        resPackage.setChunkPadding(chunkPaddingSize);
        return resPackage;
    }

    private ResTypeSpec readResTypeSpec() throws IOException {
        Log.d((String)TAG, (String)"==============ResTypeSpec=============", (Object[])new Object[0]);
        long headStart = this.dataInput.getFilePointer();
        ResTypeSpec resTypeSpec = new ResTypeSpec();
        resTypeSpec.setStart(headStart);
        resTypeSpec.setType(this.dataInput.readShort());
        Log.d((String)TAG, (String)"resTypeSpec type %d", (Object[])new Object[]{resTypeSpec.getType()});
        resTypeSpec.setHeadSize(this.dataInput.readShort());
        Log.d((String)TAG, (String)"resTypeSpec header size %d", (Object[])new Object[]{resTypeSpec.getHeadSize()});
        resTypeSpec.setChunkSize(this.dataInput.readInt());
        Log.d((String)TAG, (String)"resTypeSpec chunk size %d", (Object[])new Object[]{resTypeSpec.getChunkSize()});
        resTypeSpec.setId(this.dataInput.readByte());
        Log.d((String)TAG, (String)"resTypeSpec type id %d", (Object[])new Object[]{resTypeSpec.getId()});
        resTypeSpec.setReserved0(this.dataInput.readByte());
        resTypeSpec.setReserved1(this.dataInput.readShort());
        resTypeSpec.setEntryCount(this.dataInput.readInt());
        Log.d((String)TAG, (String)"resTypeSpec entry count %d", (Object[])new Object[]{resTypeSpec.getEntryCount()});
        int headPaddingSize = (int)((long)resTypeSpec.getHeadSize() + headStart - this.dataInput.getFilePointer());
        Log.d((String)TAG, (String)"head padding size %d", (Object[])new Object[]{headPaddingSize});
        resTypeSpec.setHeadPadding(headPaddingSize);
        if (resTypeSpec.getChunkSize() - resTypeSpec.getHeadSize() > 0) {
            byte[] buffer = new byte[resTypeSpec.getChunkSize() - resTypeSpec.getHeadSize()];
            this.dataInput.read(buffer);
            resTypeSpec.setConfigFlags(buffer);
        }
        int chunkPaddingSize = (int)((long)resTypeSpec.getChunkSize() + headStart - this.dataInput.getFilePointer());
        Log.d((String)TAG, (String)"chunk padding size %d", (Object[])new Object[]{chunkPaddingSize});
        resTypeSpec.setChunkPadding(chunkPaddingSize);
        return resTypeSpec;
    }

    private ResType readResType(ResPackage resPackage) throws IOException {
        int i;
        Log.d((String)TAG, (String)"=============ResType==============", (Object[])new Object[0]);
        long headStart = this.dataInput.getFilePointer();
        ResType resType = new ResType();
        resType.setStart(headStart);
        resType.setType(this.dataInput.readShort());
        Log.d((String)TAG, (String)"resType type %d", (Object[])new Object[]{resType.getType()});
        resType.setHeadSize(this.dataInput.readShort());
        Log.d((String)TAG, (String)"resType header size %d", (Object[])new Object[]{resType.getHeadSize()});
        resType.setChunkSize(this.dataInput.readInt());
        Log.d((String)TAG, (String)"resType chunk size %d", (Object[])new Object[]{resType.getChunkSize()});
        resType.setId(this.dataInput.readByte());
        resType.setReserved0(this.dataInput.readByte());
        resType.setReserved1(this.dataInput.readShort());
        resType.setEntryCount(this.dataInput.readInt());
        resType.setEntryTableOffset(this.dataInput.readInt());
        resType.setResConfigFlags(this.readResConfig());
        int headPaddingSize = (int)((long)resType.getHeadSize() + headStart - this.dataInput.getFilePointer());
        Log.d((String)TAG, (String)"head padding size %d", (Object[])new Object[]{headPaddingSize});
        resType.setHeadPadding(headPaddingSize);
        if (resType.getEntryCount() > 0) {
            ArrayList<Integer> resEntryOffsets = new ArrayList<Integer>();
            for (i = 0; i < resType.getEntryCount(); ++i) {
                resEntryOffsets.add(this.dataInput.readInt());
            }
            resType.setEntryOffsets(resEntryOffsets);
        }
        this.dataInput.seek(headStart + (long)resType.getEntryTableOffset());
        ArrayList<ResEntry> entryTable = new ArrayList<ResEntry>();
        for (i = 0; i < resType.getEntryCount(); ++i) {
            if (resType.getEntryOffsets().get(i) != -1) {
                entryTable.add(this.readResEntry(resPackage, headStart + (long)resType.getEntryTableOffset() + (long)resType.getEntryOffsets().get(i).intValue()));
                continue;
            }
            entryTable.add(null);
        }
        resType.setEntryTable(entryTable);
        int chunkPaddingSize = (int)((long)resType.getChunkSize() + headStart - this.dataInput.getFilePointer());
        Log.d((String)TAG, (String)"chunk padding size %d", (Object[])new Object[]{chunkPaddingSize});
        resType.setChunkPadding(chunkPaddingSize);
        return resType;
    }

    private ResEntry readResEntry(ResPackage resPackage, long start) throws IOException {
        Log.d((String)TAG, (String)"==============ResEntry=============", (Object[])new Object[0]);
        this.dataInput.seek(start);
        ResEntry resEntry = new ResEntry();
        resEntry.setSize(this.dataInput.readShort());
        resEntry.setFlag(this.dataInput.readShort());
        Log.d((String)TAG, (String)"resEntry flag %d", (Object[])new Object[]{resEntry.getFlag()});
        resEntry.setStringPoolIndex(this.dataInput.readInt());
        String entryName = ResStringBlock.resolveStringPoolEntry(resPackage.getResNamePool().getStrings().get(resEntry.getStringPoolIndex()).array(), resPackage.getResNamePool().getCharSet());
        Log.d((String)TAG, (String)"entryName %s", (Object[])new Object[]{entryName});
        resEntry.setEntryName(entryName);
        if ((resEntry.getFlag() & 1) == 0) {
            resEntry.setResValue(this.readResValue());
        } else {
            resEntry.setParent(this.dataInput.readInt());
            resEntry.setPairCount(this.dataInput.readInt());
            if (resEntry.getPairCount() > 0) {
                ArrayList<ResMapValue> mapValues = new ArrayList<ResMapValue>();
                for (int i = 0; i < resEntry.getPairCount(); ++i) {
                    mapValues.add(this.readResMapValue());
                }
                resEntry.setResMapValues(mapValues);
            }
        }
        return resEntry;
    }

    private ResValue readResValue() throws IOException {
        Log.d((String)TAG, (String)"============ResValue===============", (Object[])new Object[0]);
        ResValue resValue = new ResValue();
        resValue.setSize(this.dataInput.readShort());
        resValue.setResvered(this.dataInput.readByte());
        resValue.setDataType(this.dataInput.readByte());
        Log.d((String)TAG, (String)"resValue data type %d", (Object[])new Object[]{resValue.getDataType()});
        resValue.setData(this.dataInput.readInt());
        if (resValue.getDataType() == 3) {
            Log.d((String)TAG, (String)"resValue string %s", (Object[])new Object[]{ResStringBlock.resolveStringPoolEntry(this.globalResTable.getGlobalStringPool().getStrings().get(resValue.getData()).array(), this.globalResTable.getGlobalStringPool().getCharSet())});
        } else {
            Log.d((String)TAG, (String)"resValue %s", (Object[])new Object[]{resValue.printData()});
        }
        return resValue;
    }

    private ResMapValue readResMapValue() throws IOException {
        Log.d((String)TAG, (String)"==============ResMapValue=============", (Object[])new Object[0]);
        ResMapValue resValue = new ResMapValue();
        resValue.setName(this.dataInput.readInt());
        resValue.setResValue(this.readResValue());
        return resValue;
    }

    private ResConfig readResConfig() throws IOException {
        Log.d((String)TAG, (String)"==============ResConfig=============", (Object[])new Object[0]);
        ResConfig config = new ResConfig();
        config.setSize(this.dataInput.readInt());
        if (config.getSize() > 4) {
            byte[] buffer = new byte[config.getSize() - 4];
            this.dataInput.read(buffer);
            config.setContent(buffer);
        }
        return config;
    }

    private ResStringBlock readStringBlock() throws IOException {
        int i;
        Log.d((String)TAG, (String)"==============ResStringBlock=============", (Object[])new Object[0]);
        long headStart = this.dataInput.getFilePointer();
        ResStringBlock stringPool = new ResStringBlock();
        stringPool.setStart(headStart);
        stringPool.setType(this.dataInput.readShort());
        Log.d((String)TAG, (String)"stringPool type %d", (Object[])new Object[]{stringPool.getType()});
        stringPool.setHeadSize(this.dataInput.readShort());
        Log.d((String)TAG, (String)"stringPool head size %d", (Object[])new Object[]{stringPool.getHeadSize()});
        stringPool.setChunkSize(this.dataInput.readInt());
        Log.d((String)TAG, (String)"stringPool chunk size %d", (Object[])new Object[]{stringPool.getChunkSize()});
        stringPool.setStringCount(this.dataInput.readInt());
        Log.d((String)TAG, (String)"stringPool string count %d", (Object[])new Object[]{stringPool.getStringCount()});
        stringPool.setStyleCount(this.dataInput.readInt());
        Log.d((String)TAG, (String)"stringPool style count %d", (Object[])new Object[]{stringPool.getStyleCount()});
        stringPool.setFlag(this.dataInput.readInt());
        Log.d((String)TAG, (String)"stringPool flag %d", (Object[])new Object[]{stringPool.getFlag()});
        stringPool.setStringStart(this.dataInput.readInt());
        Log.d((String)TAG, (String)"stringPool string start %d", (Object[])new Object[]{stringPool.getStringStart()});
        stringPool.setStyleStart(this.dataInput.readInt());
        Log.d((String)TAG, (String)"stringPool style start %d", (Object[])new Object[]{stringPool.getStyleStart()});
        int headPaddingSize = (int)((long)stringPool.getHeadSize() + headStart - this.dataInput.getFilePointer());
        Log.d((String)TAG, (String)"head padding size %d", (Object[])new Object[]{headPaddingSize});
        stringPool.setHeadPadding(headPaddingSize);
        this.dataInput.seek(headStart + (long)stringPool.getHeadSize());
        if (stringPool.getStringCount() > 0) {
            ArrayList<Integer> stringOffsets = new ArrayList<Integer>();
            for (i = 0; i < stringPool.getStringCount(); ++i) {
                stringOffsets.add(this.dataInput.readInt());
            }
            stringPool.setStringOffsets(stringOffsets);
        }
        if (stringPool.getStyleCount() > 0) {
            ArrayList<Integer> styleOffsets = new ArrayList<Integer>();
            for (i = 0; i < stringPool.getStyleCount(); ++i) {
                styleOffsets.add(this.dataInput.readInt());
            }
            stringPool.setStyleOffsets(styleOffsets);
        }
        this.dataInput.seek(headStart + (long)stringPool.getStringStart());
        if (stringPool.getStringCount() > 0) {
            ArrayList<ByteBuffer> strings = new ArrayList<ByteBuffer>();
            HashMap<String, Integer> stringIndexMap = new HashMap<String, Integer>();
            for (int i2 = 0; i2 < stringPool.getStringCount(); ++i2) {
                byte[] buffer = null;
                buffer = i2 < stringPool.getStringCount() - 1 ? new byte[stringPool.getStringOffsets().get(i2 + 1) - stringPool.getStringOffsets().get(i2)] : (stringPool.getStyleCount() > 0 ? new byte[stringPool.getStyleStart() - (stringPool.getStringOffsets().get(i2) + stringPool.getStringStart())] : new byte[stringPool.getChunkSize() - stringPool.getStringStart() - stringPool.getStringOffsets().get(i2)]);
                this.dataInput.read(buffer);
                strings.add(ByteBuffer.allocate(buffer.length));
                ((ByteBuffer)strings.get(i2)).order(ByteOrder.LITTLE_ENDIAN);
                ((ByteBuffer)strings.get(i2)).clear();
                ((ByteBuffer)strings.get(i2)).put(buffer);
                stringIndexMap.put(ResStringBlock.resolveStringPoolEntry(buffer, stringPool.getCharSet()), i2);
            }
            stringPool.setStrings(strings);
            stringPool.setStringIndexMap(stringIndexMap);
        }
        if (stringPool.getStyleCount() > 0) {
            byte[] styleBytes = new byte[stringPool.getChunkSize() - stringPool.getStyleStart()];
            this.dataInput.read(styleBytes);
            stringPool.setStyles(styleBytes);
        }
        int chunkPaddingSize = (int)((long)stringPool.getChunkSize() + headStart - this.dataInput.getFilePointer());
        Log.d((String)TAG, (String)"chunk padding size %d", (Object[])new Object[]{chunkPaddingSize});
        stringPool.setChunkPadding(chunkPaddingSize);
        return stringPool;
    }
}

