/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.backtrace;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;

public class ProcessUtil {
    private static String sProcessName = null;

    public static synchronized String getProcessNameByPid(Context context) {
        if (sProcessName == null) {
            sProcessName = ProcessUtil.getProcessNameByPidImpl(context, Process.myPid());
        }
        return sProcessName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcessNameByPidImpl(Context context, int pid) {
        if (context == null || pid <= 0) {
            return "";
        }
        try {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            for (ActivityManager.RunningAppProcessInfo i : am.getRunningAppProcesses()) {
                if (i.pid != pid || i.processName == null || i.processName.equals("")) continue;
                return i.processName;
            }
        }
        catch (Exception am) {
            // empty catch block
        }
        byte[] b = new byte[128];
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream("/proc/" + pid + "/cmdline"));
            int len = in.read(b);
            if (len > 0) {
                for (int i = 0; i < len; ++i) {
                    if (b[i] <= 128 && b[i] > 0) continue;
                    len = i;
                    break;
                }
                String string = new String(b, 0, len);
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return "";
    }

    public static boolean isMainProcess(Context context) {
        String processName = ProcessUtil.getProcessNameByPid(context);
        return context.getPackageName().equalsIgnoreCase(processName);
    }
}

