/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.backtrace;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.OperationCanceledException;
import android.os.Process;
import android.system.ErrnoException;
import android.system.Os;
import android.system.StructStat;
import android.util.Pair;
import com.tencent.matrix.backtrace.WarmUpInvoker;
import com.tencent.matrix.backtrace.WarmUpReporter;
import com.tencent.matrix.backtrace.WarmUpScheduler;
import com.tencent.matrix.backtrace.WarmUpService;
import com.tencent.matrix.backtrace.WarmUpUtility;
import com.tencent.matrix.backtrace.WeChatBacktrace;
import com.tencent.matrix.backtrace.WeChatBacktraceNative;
import com.tencent.matrix.util.MatrixLog;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CancellationException;

class WarmUpDelegate {
    private static final String TAG = "Matrix.WarmUpDelegate";
    private static final String ACTION_WARMED_UP = "action.backtrace.warmed-up";
    private static final String PERMISSION_WARMED_UP = ".backtrace.warmed_up";
    private static final String TASK_TAG_WARM_UP = "warm-up";
    private static final String TASK_TAG_CLEAN_UP = "clean-up";
    private static final String TASK_TAG_CONSUMING_UP = "consuming-up";
    private static final String TASK_TAG_COMPUTE_DISK_USAGE = "compute-disk-usage";
    private boolean mIsolateRemote = false;
    String mSavingPath;
    private WarmedUpReceiver mWarmedUpReceiver;
    private ThreadTaskExecutor mThreadTaskExecutor;
    private WarmUpScheduler mWarmUpScheduler;
    private WeChatBacktrace.Configuration mConfiguration;
    private final boolean[] mPrepared = new boolean[]{false};
    static volatile WarmUpReporter sReporter;

    WarmUpDelegate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepare(WeChatBacktrace.Configuration configuration) {
        boolean[] blArray = this.mPrepared;
        synchronized (this.mPrepared) {
            if (this.mPrepared[0]) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.mPrepared[0] = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mConfiguration = configuration;
            this.mIsolateRemote = configuration.mWarmUpInIsolateProcess;
            this.mThreadTaskExecutor = new ThreadTaskExecutor("WeChatBacktraceTask");
            this.mWarmUpScheduler = new WarmUpScheduler(this, configuration.mContext, configuration.mWarmUpTiming, configuration.mWarmUpDelay);
            if (configuration.mIsWarmUpProcess) {
                Context context = configuration.mContext;
                if (!WarmUpUtility.hasWarmedUp(context)) {
                    MatrixLog.i((String)TAG, (String)"Has not been warmed up", (Object[])new Object[0]);
                    this.mWarmUpScheduler.scheduleTask(WarmUpScheduler.TaskType.WarmUp);
                }
                if (WarmUpUtility.needCleanUp(context)) {
                    MatrixLog.i((String)TAG, (String)"Need clean up", (Object[])new Object[0]);
                    this.mWarmUpScheduler.scheduleTask(WarmUpScheduler.TaskType.CleanUp);
                }
                if (WarmUpUtility.shouldComputeDiskUsage(context)) {
                    MatrixLog.i((String)TAG, (String)"Should schedule disk usage task.", (Object[])new Object[0]);
                    this.mWarmUpScheduler.scheduleTask(WarmUpScheduler.TaskType.DiskUsage);
                }
            }
            return;
        }
    }

    void requestConsuming() {
        if (!WarmUpUtility.hasWarmedUp(this.mConfiguration.mContext)) {
            return;
        }
        this.mWarmUpScheduler.scheduleTask(WarmUpScheduler.TaskType.RequestConsuming);
    }

    boolean isBacktraceThreadBlocked() {
        if (this.mThreadTaskExecutor != null) {
            return this.mThreadTaskExecutor.isThreadBlocked();
        }
        return true;
    }

    void setSavingPath(String savingPath) {
        this.mSavingPath = savingPath;
        WeChatBacktraceNative.setSavingPath(savingPath);
    }

    static boolean internalWarmUpSoPath(String pathOfSo, int elfStartOffset, boolean onlySaveFile) {
        return WeChatBacktraceNative.warmUp(pathOfSo, elfStartOffset, onlySaveFile);
    }

    private WarmUpInvoker acquireWarmUpInvoker() {
        if (this.mIsolateRemote) {
            RemoteWarmUpInvoker invoker = new RemoteWarmUpInvoker(this.mSavingPath);
            Bundle args = new Bundle();
            args.putBoolean("enable-logger", this.mConfiguration.mEnableIsolateProcessLog);
            args.putString("path-of-xlog-so", this.mConfiguration.mPathOfXLogSo);
            if (invoker.connect(this.mConfiguration.mContext, args)) {
                return invoker;
            }
            return null;
        }
        return new LocalWarmUpInvoker();
    }

    private void releaseWarmUpInvoker(WarmUpInvoker invoker) {
        if (this.mIsolateRemote) {
            ((RemoteWarmUpInvoker)invoker).disconnect(this.mConfiguration.mContext);
        }
    }

    synchronized void registerWarmedUpReceiver(WeChatBacktrace.Configuration configuration, WeChatBacktrace.Mode mode) {
        if (WarmUpUtility.hasWarmedUp(configuration.mContext)) {
            return;
        }
        if (this.mWarmedUpReceiver != null) {
            return;
        }
        this.mWarmedUpReceiver = new WarmedUpReceiver(mode);
        MatrixLog.i((String)TAG, (String)"Register warm-up receiver.", (Object[])new Object[0]);
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_WARMED_UP);
        configuration.mContext.registerReceiver((BroadcastReceiver)this.mWarmedUpReceiver, filter, configuration.mContext.getPackageName() + PERMISSION_WARMED_UP, null);
    }

    private void broadcastWarmedUp(Context context) {
        try {
            File warmedUpFile = WarmUpUtility.warmUpMarkedFile(context);
            warmedUpFile.createNewFile();
            WarmUpUtility.writeContentToFile(warmedUpFile, context.getApplicationInfo().nativeLibraryDir);
        }
        catch (IOException e) {
            MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
        }
        WeChatBacktraceNative.setWarmedUp(true);
        WarmUpDelegate.updateBacktraceMode(this.mConfiguration.mBacktraceMode);
        MatrixLog.i((String)TAG, (String)"Broadcast warmed up message to other processes.", (Object[])new Object[0]);
        Intent intent = new Intent(ACTION_WARMED_UP);
        intent.putExtra("pid", Process.myPid());
        context.sendBroadcast(intent, context.getPackageName() + PERMISSION_WARMED_UP);
        WarmUpReporter callback = sReporter;
        if (callback != null) {
            callback.onReport(WarmUpReporter.ReportEvent.WarmedUp, new Object[0]);
        }
    }

    void warmingUp(final CancellationSignal cs) {
        this.mThreadTaskExecutor.arrangeTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                block16: {
                    MatrixLog.i((String)"Matrix.WarmUpDelegate", (String)"Going to warm up.", (Object[])new Object[0]);
                    cancelled = false;
                    invoker = null;
                    try {
                        if (!new File(WarmUpUtility.validateSavingPath(WarmUpDelegate.access$100(WarmUpDelegate.this))).isDirectory()) {
                            MatrixLog.w((String)"Matrix.WarmUpDelegate", (String)"Saving path is not a directory.", (Object[])new Object[0]);
                            WarmUpDelegate.access$200(WarmUpDelegate.this).taskFinished(WarmUpScheduler.TaskType.WarmUp);
                            if (invoker == null) return;
                            WarmUpDelegate.access$600(WarmUpDelegate.this, invoker);
                            return;
                        }
                        invoker = WarmUpDelegate.access$300(WarmUpDelegate.this);
                        if (invoker == null) {
                            MatrixLog.w((String)"Matrix.WarmUpDelegate", (String)"Failed to acquire warm-up invoker", (Object[])new Object[0]);
                            if (invoker == null) return;
                            WarmUpDelegate.access$600(WarmUpDelegate.this, invoker);
                            return;
                        }
                        invokerFinal = invoker;
                        for (String directory : WarmUpDelegate.access$100((WarmUpDelegate)WarmUpDelegate.this).mWarmUpDirectoriesList) {
                            dir = new File(directory);
                            WarmUpUtility.iterateTargetDirectory(dir, cs, new FileFilter(){

                                @Override
                                public boolean accept(File file) {
                                    String absolutePath = file.getAbsolutePath();
                                    int offset = 0;
                                    if (file.exists() && !WarmUpDelegate.this.warmUpBlocked(absolutePath, offset) && (absolutePath.endsWith(".so") || absolutePath.endsWith(".odex") || absolutePath.endsWith(".oat") || absolutePath.endsWith(".dex"))) {
                                        MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Warming up so %s", (Object[])new Object[]{absolutePath});
                                        boolean ret = invokerFinal.warmUp(absolutePath, offset);
                                        if (!ret) {
                                            WarmUpDelegate.this.warmUpFailed(absolutePath, offset);
                                        }
                                    }
                                    return false;
                                }
                            });
                        }
                        ** if (invoker == null) goto lbl-1000
                    }
                    catch (OperationCanceledException exception) {
                        cancelled = true;
                        break block16;
                        {
                            catch (Throwable var7_9) {
                                throw var7_9;
                            }
                        }
                        catch (Throwable t) {
                            MatrixLog.printErrStackTrace((String)"Matrix.WarmUpDelegate", (Throwable)t, (String)"", (Object[])new Object[0]);
                            ** if (invoker == null) goto lbl-1000
lbl-1000:
                            // 1 sources

                            {
                                WarmUpDelegate.access$600(WarmUpDelegate.this, invoker);
                            }
lbl-1000:
                            // 2 sources

                            {
                                break block16;
                            }
                        }
                    }
                    finally {
                        if (invoker != null) {
                            WarmUpDelegate.access$600(WarmUpDelegate.this, invoker);
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        WarmUpDelegate.access$600(WarmUpDelegate.this, invoker);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                if (!cancelled) {
                    WarmUpDelegate.access$200(WarmUpDelegate.this).taskFinished(WarmUpScheduler.TaskType.WarmUp);
                    WarmUpDelegate.access$700(WarmUpDelegate.this, WarmUpDelegate.access$100((WarmUpDelegate)WarmUpDelegate.this).mContext);
                    MatrixLog.i((String)"Matrix.WarmUpDelegate", (String)"Warm-up done.", (Object[])new Object[0]);
                    return;
                }
                MatrixLog.i((String)"Matrix.WarmUpDelegate", (String)"Warm-up cancelled.", (Object[])new Object[0]);
            }
        }, TASK_TAG_WARM_UP);
    }

    void cleaningUp(final CancellationSignal cs) {
        this.mThreadTaskExecutor.arrangeTask(new Runnable(){

            @Override
            public void run() {
                File savingDir = new File(WarmUpUtility.validateSavingPath(WarmUpDelegate.this.mConfiguration));
                MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Going to clean up saving path(%s)..", (Object[])new Object[]{savingDir.getAbsoluteFile()});
                if (!savingDir.isDirectory()) {
                    WarmUpDelegate.this.mWarmUpScheduler.taskFinished(WarmUpScheduler.TaskType.CleanUp);
                    return;
                }
                final HashMap visitedFiles = new HashMap();
                boolean cancelled = false;
                try {
                    WarmUpUtility.iterateTargetDirectory(savingDir, cs, new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            try {
                                String filename = pathname.getName();
                                String absolutePath = pathname.getAbsolutePath();
                                if (filename.contains("_malformed_") || filename.contains("_temp_")) {
                                    if (System.currentTimeMillis() - pathname.lastModified() >= 172800000L) {
                                        MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Delete malformed and temp file %s", (Object[])new Object[]{absolutePath});
                                        pathname.delete();
                                    }
                                } else {
                                    StructStat stat = Os.lstat((String)absolutePath);
                                    long lastAccessTime = Math.max(stat.st_atime, stat.st_mtime) * 1000L;
                                    MatrixLog.i((String)WarmUpDelegate.TAG, (String)"File(%s) last access time %s", (Object[])new Object[]{absolutePath, lastAccessTime});
                                    if (System.currentTimeMillis() - lastAccessTime > 259200000L) {
                                        pathname.delete();
                                        MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Delete long time no access file(%s)", (Object[])new Object[]{absolutePath});
                                    } else if (lastAccessTime >= System.currentTimeMillis()) {
                                        if (lastAccessTime - System.currentTimeMillis() >= 604800000L) {
                                            pathname.delete();
                                            MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Delete future file(%s)", (Object[])new Object[]{absolutePath});
                                        }
                                    } else {
                                        int indexOfDot = filename.lastIndexOf(46);
                                        if (indexOfDot == -1) {
                                            return false;
                                        }
                                        String elfName = filename.substring(0, indexOfDot);
                                        if (filename.endsWith(".hash")) {
                                            return false;
                                        }
                                        Pair pair = (Pair)visitedFiles.get(elfName);
                                        if (pair != null) {
                                            if (lastAccessTime > (Long)pair.second) {
                                                if (System.currentTimeMillis() - (Long)pair.second >= 172800000L) {
                                                    ((File)pair.first).delete();
                                                    MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Delete file(%s) cause %s is newer(%s vs %s).", (Object[])new Object[]{((File)pair.first).getName(), filename, pair.second, lastAccessTime});
                                                }
                                                visitedFiles.put(elfName, new Pair((Object)pathname, (Object)lastAccessTime));
                                            } else if (System.currentTimeMillis() - lastAccessTime >= 172800000L) {
                                                pathname.delete();
                                                MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Delete file(%s) cause %s is newer(%s vs %s).", (Object[])new Object[]{filename, ((File)pair.first).getName(), lastAccessTime, pair.second});
                                            }
                                        } else {
                                            visitedFiles.put(elfName, new Pair((Object)pathname, (Object)lastAccessTime));
                                        }
                                    }
                                }
                            }
                            catch (Throwable e) {
                                MatrixLog.printErrStackTrace((String)WarmUpDelegate.TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                            }
                            return false;
                        }
                    });
                }
                catch (OperationCanceledException exception) {
                    cancelled = true;
                }
                catch (Throwable t) {
                    MatrixLog.printErrStackTrace((String)WarmUpDelegate.TAG, (Throwable)t, (String)"", (Object[])new Object[0]);
                }
                if (!cancelled) {
                    WarmUpUtility.markCleanUpTimestamp(((WarmUpDelegate)WarmUpDelegate.this).mConfiguration.mContext);
                    WarmUpDelegate.this.mWarmUpScheduler.taskFinished(WarmUpScheduler.TaskType.CleanUp);
                    MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Clean up saving path(%s) done.", (Object[])new Object[]{savingDir.getAbsoluteFile()});
                    WarmUpReporter callback = sReporter;
                    if (callback != null) {
                        callback.onReport(WarmUpReporter.ReportEvent.CleanedUp, new Object[0]);
                    }
                } else {
                    MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Clean up saving path(%s) cancelled.", (Object[])new Object[]{savingDir.getAbsoluteFile()});
                }
            }
        }, TASK_TAG_CLEAN_UP);
    }

    void consumingRequestedQut(final CancellationSignal cs) {
        this.mThreadTaskExecutor.arrangeTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Going to consume requested QUT.", (Object[])new Object[0]);
                String[] arrayOfRequesting = WeChatBacktraceNative.consumeRequestedQut();
                WarmUpInvoker invoker = WarmUpDelegate.this.acquireWarmUpInvoker();
                if (invoker == null) {
                    WarmUpDelegate.this.mWarmUpScheduler.taskFinished(WarmUpScheduler.TaskType.RequestConsuming);
                    MatrixLog.w((String)WarmUpDelegate.TAG, (String)"Failed to acquire warm-up invoker.", (Object[])new Object[0]);
                    return;
                }
                try {
                    for (String path : arrayOfRequesting) {
                        int index = path.lastIndexOf(58);
                        String pathOfElf = path;
                        int offset = 0;
                        if (index != -1) {
                            try {
                                pathOfElf = path.substring(0, index);
                                offset = Integer.valueOf(path.substring(index + 1));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        boolean ret = false;
                        if (!WarmUpDelegate.this.warmUpBlocked(pathOfElf, offset) && !(ret = invoker.warmUp(pathOfElf, offset))) {
                            WarmUpDelegate.this.warmUpFailed(pathOfElf, offset);
                        }
                        MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Consumed requested QUT -> %s, ret = %s.", (Object[])new Object[]{path, ret});
                        if (cs == null || !cs.isCanceled()) continue;
                        MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Consume requested QUT canceled.", (Object[])new Object[0]);
                        break;
                    }
                    MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Consume requested QUT done.", (Object[])new Object[0]);
                }
                finally {
                    WarmUpDelegate.this.releaseWarmUpInvoker(invoker);
                    WarmUpDelegate.this.mWarmUpScheduler.taskFinished(WarmUpScheduler.TaskType.RequestConsuming);
                }
            }
        }, TASK_TAG_CONSUMING_UP);
    }

    void computeDiskUsage(final CancellationSignal cs) {
        this.mThreadTaskExecutor.arrangeTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                File file = new File(WarmUpDelegate.this.mSavingPath);
                if (!file.isDirectory()) {
                    WarmUpDelegate.this.mWarmUpScheduler.taskFinished(WarmUpScheduler.TaskType.DiskUsage);
                    return;
                }
                final long[] count = new long[2];
                try {
                    WarmUpUtility.iterateTargetDirectory(file, cs, new FileFilter(){

                        @Override
                        public boolean accept(File pathname) {
                            try {
                                StructStat stat = Os.lstat((String)pathname.getAbsolutePath());
                                count[0] = count[0] + 1L;
                                count[1] = count[1] + stat.st_blocks * stat.st_blksize;
                            }
                            catch (ErrnoException e) {
                                MatrixLog.printErrStackTrace((String)WarmUpDelegate.TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                            }
                            return false;
                        }
                    });
                }
                catch (OperationCanceledException | CancellationException e) {
                    WarmUpDelegate.this.mWarmUpScheduler.taskFinished(WarmUpScheduler.TaskType.DiskUsage);
                    WarmUpUtility.markComputeDiskUsageTimestamp(((WarmUpDelegate)WarmUpDelegate.this).mConfiguration.mContext);
                    MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Compute disk usage, file count(%s), disk usage(%s)", (Object[])new Object[]{count[0], count[1]});
                    return;
                }
                catch (Throwable throwable) {
                    WarmUpDelegate.this.mWarmUpScheduler.taskFinished(WarmUpScheduler.TaskType.DiskUsage);
                    WarmUpUtility.markComputeDiskUsageTimestamp(((WarmUpDelegate)WarmUpDelegate.this).mConfiguration.mContext);
                    MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Compute disk usage, file count(%s), disk usage(%s)", (Object[])new Object[]{count[0], count[1]});
                    throw throwable;
                }
                WarmUpDelegate.this.mWarmUpScheduler.taskFinished(WarmUpScheduler.TaskType.DiskUsage);
                WarmUpUtility.markComputeDiskUsageTimestamp(((WarmUpDelegate)WarmUpDelegate.this).mConfiguration.mContext);
                MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Compute disk usage, file count(%s), disk usage(%s)", (Object[])new Object[]{count[0], count[1]});
                WarmUpReporter reporter = sReporter;
                if (reporter != null) {
                    reporter.onReport(WarmUpReporter.ReportEvent.DiskUsage, count[0], count[1]);
                }
            }
        }, TASK_TAG_COMPUTE_DISK_USAGE);
    }

    private boolean warmUpBlocked(String pathOfElf, int offset) {
        boolean blocked;
        boolean bl = blocked = !WarmUpUtility.UnfinishedManagement.check(this.mConfiguration.mContext, pathOfElf, offset);
        if (blocked) {
            MatrixLog.w((String)TAG, (String)"Elf file %s:%s has blocked and will not do warm-up.", (Object[])new Object[]{pathOfElf, offset});
        }
        return blocked;
    }

    private void warmUpFailed(String pathOfElf, int offset) {
        WarmUpReporter reporter = sReporter;
        if (reporter != null) {
            reporter.onReport(WarmUpReporter.ReportEvent.WarmUpFailed, pathOfElf, offset);
        }
    }

    private static void updateBacktraceMode(WeChatBacktrace.Mode current) {
        if (current == WeChatBacktrace.Mode.FpUntilQuickenWarmedUp || current == WeChatBacktrace.Mode.DwarfUntilQuickenWarmedUp) {
            WeChatBacktraceNative.setBacktraceMode(WeChatBacktrace.Mode.Quicken.value);
        }
    }

    static /* synthetic */ void access$700(WarmUpDelegate x0, Context x1) {
        x0.broadcastWarmedUp(x1);
    }

    static final class ThreadTaskExecutor
    implements Runnable,
    Handler.Callback {
        private String mThreadName;
        private Thread mThreadExecutor;
        private HashMap<String, Runnable> mRunnableTasks = new HashMap();
        private Queue<String> mTaskQueue = new LinkedList<String>();
        private Handler mBlockedChecker = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        private static final int MSG_BLOCKED_CHECK = 1;
        private static final long BLOCKED_CHECK_INTERVAL = 300000L;
        private boolean mThreadBlocked = false;
        long[] mTaskStartTS = new long[]{0L};

        ThreadTaskExecutor(String threadName) {
            this.mThreadName = threadName;
        }

        boolean isThreadBlocked() {
            return this.mThreadBlocked;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void arrangeTask(Runnable runnable, String tag) {
            Object object = this.mTaskQueue;
            synchronized (object) {
                if (this.mTaskQueue.contains(tag)) {
                    return;
                }
                this.mTaskQueue.add(tag);
                this.mRunnableTasks.put(tag, runnable);
            }
            object = this;
            synchronized (object) {
                if (this.mThreadExecutor == null || !this.mThreadExecutor.isAlive()) {
                    this.mThreadExecutor = new Thread((Runnable)this, this.mThreadName);
                    this.mThreadExecutor.start();
                    this.mBlockedChecker.removeMessages(1);
                    this.mBlockedChecker.sendEmptyMessageDelayed(1, 300000L);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.mThreadBlocked = false;
            long[] lArray = this.mTaskStartTS;
            synchronized (this.mTaskStartTS) {
                this.mTaskStartTS[0] = System.currentTimeMillis();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                try {
                    Runnable runnable = null;
                    String tag = null;
                    do {
                        if (runnable != null) {
                            long start = System.currentTimeMillis();
                            MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Before '%s' task execution..", (Object[])new Object[]{tag});
                            runnable.run();
                            MatrixLog.i((String)WarmUpDelegate.TAG, (String)"After '%s' task execution..", (Object[])new Object[]{tag});
                            long duration = System.currentTimeMillis() - start;
                            WarmUpReporter callback = sReporter;
                            if (callback != null) {
                                if (WarmUpDelegate.TASK_TAG_WARM_UP.equalsIgnoreCase(tag)) {
                                    callback.onReport(WarmUpReporter.ReportEvent.WarmUpDuration, duration);
                                } else if (WarmUpDelegate.TASK_TAG_CONSUMING_UP.equalsIgnoreCase(tag)) {
                                    callback.onReport(WarmUpReporter.ReportEvent.ConsumeRequestDuration, duration);
                                }
                            }
                        }
                        Queue<String> queue = this.mTaskQueue;
                        synchronized (queue) {
                            block26: {
                                tag = this.mTaskQueue.poll();
                                if (tag != null) break block26;
                                return;
                            }
                            runnable = this.mRunnableTasks.remove(tag);
                        }
                    } while (runnable != null);
                }
                finally {
                    long[] lArray2 = this.mTaskStartTS;
                    synchronized (this.mTaskStartTS) {
                        this.mTaskStartTS[0] = 0L;
                        // ** MonitorExit[var4_8] (shouldn't be in output)
                        this.mBlockedChecker.removeMessages(1);
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean handleMessage(Message msg) {
            if (msg.what != 1) return false;
            long[] lArray = this.mTaskStartTS;
            synchronized (this.mTaskStartTS) {
                if (this.mTaskStartTS[0] == 0L) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                this.mThreadBlocked = true;
                WarmUpReporter callback = sReporter;
                if (callback == null) return false;
                callback.onReport(WarmUpReporter.ReportEvent.WarmUpThreadBlocked, new Object[0]);
                return false;
            }
        }
    }

    private static final class WarmedUpReceiver
    extends BroadcastReceiver {
        private WeChatBacktrace.Mode mCurrentBacktraceMode;

        WarmedUpReceiver(WeChatBacktrace.Mode mode) {
            this.mCurrentBacktraceMode = mode;
        }

        public void onReceive(Context context, Intent intent) {
            MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Warm-up received.", (Object[])new Object[0]);
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            switch (action) {
                case "action.backtrace.warmed-up": {
                    WeChatBacktraceNative.setWarmedUp(true);
                    WarmUpDelegate.updateBacktraceMode(this.mCurrentBacktraceMode);
                    try {
                        context.unregisterReceiver((BroadcastReceiver)this);
                        break;
                    }
                    catch (Throwable e) {
                        MatrixLog.printErrStackTrace((String)WarmUpDelegate.TAG, (Throwable)e, (String)"Unregister receiver twice.", (Object[])new Object[0]);
                    }
                }
            }
        }
    }

    private static final class LocalWarmUpInvoker
    implements WarmUpInvoker {
        private LocalWarmUpInvoker() {
        }

        @Override
        public boolean warmUp(String pathOfElf, int offset) {
            return WarmUpDelegate.internalWarmUpSoPath(pathOfElf, offset, false);
        }
    }

    private static final class RemoteWarmUpInvoker
    implements WarmUpInvoker,
    WarmUpService.RemoteConnection {
        WarmUpService.RemoteInvokerImpl mImpl = new WarmUpService.RemoteInvokerImpl();
        private final String mSavingPath;
        private Context mContext;
        private Bundle mArgs;

        RemoteWarmUpInvoker(String savingPath) {
            this.mSavingPath = savingPath;
        }

        @Override
        public boolean isConnected() {
            return this.mImpl.isConnected();
        }

        @Override
        public boolean connect(Context context, Bundle args) {
            this.mContext = context;
            this.mArgs = args;
            return this.mImpl.connect(context, args);
        }

        @Override
        public void disconnect(Context context) {
            this.mImpl.disconnect(context);
        }

        @Override
        public boolean warmUp(String pathOfElf, int offset) {
            boolean ret;
            if (!this.isConnected() && !this.connect(this.mContext, this.mArgs)) {
                return false;
            }
            Bundle args = new Bundle();
            args.putString("saving-path", this.mSavingPath);
            args.putString("path-of-elf", pathOfElf);
            args.putInt("elf-start-offset", offset);
            Bundle result = this.mImpl.call(100, args);
            int retCode = result != null ? result.getInt("warm-up-result") : -100;
            boolean bl = ret = retCode == 0;
            if (ret) {
                WeChatBacktraceNative.notifyWarmedUp(pathOfElf, offset);
            }
            MatrixLog.i((String)WarmUpDelegate.TAG, (String)"Warm-up %s:%s - retCode %s", (Object[])new Object[]{pathOfElf, offset, retCode});
            return ret;
        }
    }
}

