/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.backtrace;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import com.tencent.matrix.backtrace.WarmUpDelegate;
import com.tencent.matrix.backtrace.WarmUpUtility;
import com.tencent.matrix.backtrace.WeChatBacktrace;
import com.tencent.matrix.util.MatrixLog;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class WarmUpScheduler
implements Handler.Callback {
    private static final String TAG = "Matrix.WarmUpScheduler";
    static final long DELAY_SHORTLY = 3000L;
    static final long DELAY_CLEAN_UP = 3000L;
    static final long DELAY_WARM_UP = 3000L;
    static final long DELAY_CONSUME_REQ_QUT = 3000L;
    private static final int MSG_WARM_UP = 1;
    private static final int MSG_CONSUME_REQ_QUT = 2;
    private static final int MSG_CLEAN_UP = 3;
    private static final int MSG_COMPUTE_DISK_USAGE = 4;
    private IdleReceiver mIdleReceiver;
    private WarmUpDelegate mDelegate;
    private Handler mHandler;
    private Context mContext;
    private WeChatBacktrace.WarmUpTiming mTiming;
    private long mWarmUpDelay = 0L;

    WarmUpScheduler(WarmUpDelegate delegate, Context context, WeChatBacktrace.WarmUpTiming timing, long delay) {
        this.mDelegate = delegate;
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper(), (Handler.Callback)this);
        }
        this.mContext = context;
        this.mTiming = timing;
        this.mWarmUpDelay = Math.max(delay, 3000L);
    }

    void scheduleTask(final TaskType type) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                WarmUpScheduler.this.scheduleTaskImpl(type);
            }
        });
    }

    void scheduleTaskImpl(TaskType type) {
        switch (this.mTiming) {
            case PostStartup: {
                this.arrangeTaskDirectly(type);
                break;
            }
            case WhileCharging: 
            case WhileScreenOff: {
                this.arrangeTaskToIdleReceiver(this.mContext, type);
                break;
            }
        }
    }

    void taskFinished(TaskType type) {
        switch (this.mTiming) {
            case WhileCharging: 
            case WhileScreenOff: {
                this.finishTaskToIdleReceiver(this.mContext, type);
                break;
            }
        }
    }

    private void arrangeTaskDirectly(TaskType type) {
        switch (type) {
            case WarmUp: {
                MatrixLog.i((String)TAG, (String)"Schedule warm-up in %ss", (Object[])new Object[]{this.mWarmUpDelay / 1000L});
                this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)1, (Object)new CancellationSignal()), this.mWarmUpDelay);
                break;
            }
            case CleanUp: {
                MatrixLog.i((String)TAG, (String)"Schedule clean-up in %ss", (Object[])new Object[]{this.mWarmUpDelay / 1000L});
                this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)3, (Object)new CancellationSignal()), this.mWarmUpDelay);
                break;
            }
            case RequestConsuming: {
                MatrixLog.i((String)TAG, (String)"Schedule request consuming in %ss", (Object[])new Object[]{this.mWarmUpDelay / 1000L});
                this.mHandler.sendMessageDelayed(Message.obtain((Handler)this.mHandler, (int)2, (Object)new CancellationSignal()), this.mWarmUpDelay);
            }
        }
    }

    private synchronized void arrangeTaskToIdleReceiver(Context context, TaskType type) {
        if (this.mIdleReceiver != null) {
            this.mIdleReceiver.arrange(type);
            return;
        }
        this.mIdleReceiver = new IdleReceiver(context, this.mHandler, this.mTiming, this.mWarmUpDelay);
        this.mIdleReceiver.arrange(type);
        MatrixLog.i((String)TAG, (String)"Register idle receiver.", (Object[])new Object[0]);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.ACTION_POWER_CONNECTED");
        filter.addAction("android.intent.action.ACTION_POWER_DISCONNECTED");
        context.registerReceiver((BroadcastReceiver)this.mIdleReceiver, filter);
        this.mIdleReceiver.refreshIdleStatus(context);
    }

    private synchronized void finishTaskToIdleReceiver(Context context, TaskType type) {
        if (this.mIdleReceiver != null && this.mIdleReceiver.finish(type) == 0) {
            MatrixLog.i((String)TAG, (String)"Unregister idle receiver.", (Object[])new Object[0]);
            context.unregisterReceiver((BroadcastReceiver)this.mIdleReceiver);
            this.mIdleReceiver = null;
        }
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                CancellationSignal cs = (CancellationSignal)msg.obj;
                this.mDelegate.warmingUp(cs);
                break;
            }
            case 2: {
                CancellationSignal cs = (CancellationSignal)msg.obj;
                this.mDelegate.consumingRequestedQut(cs);
                break;
            }
            case 3: {
                CancellationSignal cs = (CancellationSignal)msg.obj;
                this.mDelegate.cleaningUp(cs);
                break;
            }
            case 4: {
                CancellationSignal cs = (CancellationSignal)msg.obj;
                this.mDelegate.computeDiskUsage(cs);
                break;
            }
        }
        return false;
    }

    private static final class IdleReceiver
    extends BroadcastReceiver {
        private CancellationSignal mCancellationSignal;
        Handler mIdleHandler;
        Context mContext;
        private final WeChatBacktrace.WarmUpTiming mTiming;
        private final long mWarmUpDelay;
        private final Set<TaskType> mTasks = new HashSet<TaskType>();

        IdleReceiver(Context context, Handler idleHandler, WeChatBacktrace.WarmUpTiming timing, long delay) {
            this.mContext = context;
            this.mIdleHandler = idleHandler;
            this.mTiming = timing;
            this.mWarmUpDelay = delay;
        }

        synchronized void arrange(TaskType type) {
            if (this.mTasks.contains((Object)type)) {
                return;
            }
            this.mTasks.add(type);
        }

        synchronized int finish(TaskType type) {
            this.mTasks.remove((Object)type);
            return this.mTasks.size();
        }

        private synchronized void triggerIdle(boolean isInteractive, boolean isCharging) {
            boolean isIdle;
            MatrixLog.i((String)WarmUpScheduler.TAG, (String)"Idle status changed: interactive = %s, charging = %s", (Object[])new Object[]{isInteractive, isCharging});
            boolean bl = isIdle = !isInteractive && (this.mTiming == WeChatBacktrace.WarmUpTiming.WhileScreenOff || !isCharging);
            if (isIdle && this.mCancellationSignal == null) {
                this.mCancellationSignal = new CancellationSignal();
                Iterator<TaskType> it = this.mTasks.iterator();
                while (it.hasNext()) {
                    TaskType type = it.next();
                    switch (type) {
                        case WarmUp: {
                            if (!WarmUpUtility.hasWarmedUp(this.mContext)) {
                                this.mIdleHandler.sendMessageDelayed(Message.obtain((Handler)this.mIdleHandler, (int)1, (Object)this.mCancellationSignal), this.mWarmUpDelay);
                                MatrixLog.i((String)WarmUpScheduler.TAG, (String)"System idle, trigger warm up in %s seconds.", (Object[])new Object[]{this.mWarmUpDelay / 1000L});
                                break;
                            }
                            it.remove();
                            break;
                        }
                        case RequestConsuming: {
                            this.mIdleHandler.sendMessageDelayed(Message.obtain((Handler)this.mIdleHandler, (int)2, (Object)this.mCancellationSignal), this.mWarmUpDelay);
                            MatrixLog.i((String)WarmUpScheduler.TAG, (String)"System idle, trigger consume requested qut in %s seconds.", (Object[])new Object[]{this.mWarmUpDelay / 1000L});
                            break;
                        }
                        case CleanUp: {
                            if (WarmUpUtility.needCleanUp(this.mContext)) {
                                this.mIdleHandler.sendMessageDelayed(Message.obtain((Handler)this.mIdleHandler, (int)3, (Object)this.mCancellationSignal), 3000L);
                            } else {
                                it.remove();
                            }
                            MatrixLog.i((String)WarmUpScheduler.TAG, (String)"System idle, trigger clean up in %s seconds.", (Object[])new Object[]{3L});
                            break;
                        }
                        case DiskUsage: {
                            if (WarmUpUtility.shouldComputeDiskUsage(this.mContext)) {
                                this.mIdleHandler.sendMessageDelayed(Message.obtain((Handler)this.mIdleHandler, (int)4, (Object)this.mCancellationSignal), 3000L);
                            } else {
                                it.remove();
                            }
                            MatrixLog.i((String)WarmUpScheduler.TAG, (String)"System idle, trigger disk usage in %s seconds.", (Object[])new Object[]{3L});
                        }
                    }
                }
            } else if (!isIdle && this.mCancellationSignal != null) {
                this.mIdleHandler.removeMessages(1);
                this.mIdleHandler.removeMessages(2);
                this.mIdleHandler.removeMessages(3);
                this.mIdleHandler.removeMessages(4);
                this.mCancellationSignal.cancel();
                this.mCancellationSignal = null;
                MatrixLog.i((String)WarmUpScheduler.TAG, (String)"Exit idle state, task cancelled.", (Object[])new Object[0]);
            }
        }

        synchronized void refreshIdleStatus(Context context) {
            PowerManager pm = (PowerManager)context.getSystemService("power");
            boolean isInteractive = pm.isInteractive();
            boolean isCharging = false;
            IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
            Intent intent = context.registerReceiver(null, filter);
            if (intent != null) {
                int status = intent.getIntExtra("status", -1);
                isCharging = status == 2 || status == 5;
            }
            this.triggerIdle(isInteractive, isCharging);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            boolean isInteractive = false;
            boolean isCharging = false;
            IdleReceiver idleReceiver = this;
            synchronized (idleReceiver) {
                switch (action) {
                    case "android.intent.action.SCREEN_ON": {
                        isInteractive = true;
                        break;
                    }
                    case "android.intent.action.SCREEN_OFF": {
                        isInteractive = false;
                        break;
                    }
                    case "android.intent.action.ACTION_POWER_CONNECTED": {
                        isCharging = true;
                        break;
                    }
                    case "android.intent.action.ACTION_POWER_DISCONNECTED": {
                        isCharging = false;
                    }
                }
                this.triggerIdle(isInteractive, isCharging);
            }
        }
    }

    static enum TaskType {
        WarmUp,
        CleanUp,
        RequestConsuming,
        DiskUsage;

    }
}

