/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.backtrace;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Process;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import com.tencent.matrix.backtrace.WarmUpDelegate;
import com.tencent.matrix.backtrace.WarmUpUtility;
import com.tencent.matrix.backtrace.WeChatBacktrace;
import com.tencent.matrix.backtrace.WeChatBacktraceNative;
import com.tencent.matrix.util.MatrixHandlerThread;
import com.tencent.matrix.util.MatrixLog;
import com.tencent.matrix.xlog.XLogNative;
import java.util.concurrent.atomic.AtomicInteger;

public class WarmUpService
extends Service {
    private static final String TAG = "Matrix.WarmUpService";
    private static final String INVOKE_ARGS = "invoke-args";
    private static final String INVOKE_RESP = "invoke-resp";
    static final String BIND_ARGS_PATH_OF_XLOG_SO = "path-of-xlog-so";
    static final String BIND_ARGS_ENABLE_LOGGER = "enable-logger";
    static final String ARGS_WARM_UP_SAVING_PATH = "saving-path";
    static final String ARGS_WARM_UP_PATH_OF_ELF = "path-of-elf";
    static final String ARGS_WARM_UP_ELF_START_OFFSET = "elf-start-offset";
    static final String RESULT_OF_WARM_UP = "warm-up-result";
    static final int CMD_WARM_UP_SINGLE_ELF_FILE = 100;
    @SuppressLint(value={"HandlerLeak"})
    private final Messenger mMessenger = new Messenger(new Handler(MatrixHandlerThread.getDefaultHandlerThread().getLooper()){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.obj instanceof Bundle) {
                Bundle wrap = (Bundle)msg.obj;
                Bundle args = wrap.getBundle(WarmUpService.INVOKE_ARGS);
                IBinder binder = wrap.getBinder(WarmUpService.INVOKE_RESP);
                Bundle result = WarmUpService.this.call(msg.what, args);
                Messenger messenger = new Messenger(binder);
                try {
                    messenger.send(Message.obtain(null, (int)msg.what, (Object)result));
                }
                catch (RemoteException e) {
                    MatrixLog.printErrStackTrace((String)WarmUpService.TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                }
            }
        }
    });
    static final int OK = 0;
    public static final int INVALID_ARGUMENT = -1;
    public static final int WARM_UP_FAILED = -2;
    public static final int WARM_UP_FAILED_TOO_MANY_TIMES = -3;
    private static volatile boolean sHasInitiated = false;
    private static volatile boolean sHasLoaded = false;
    private static HandlerThread sRecycler;
    private static Handler sRecyclerHandler;
    private static final AtomicInteger sWorkingCall;
    private static final byte[] sRecyclerLock;
    private final WarmUpDelegate mWarmUpDelegate = new WarmUpDelegate();
    private static final int MSG_SUICIDE = 1;
    private static final long INTERVAL_OF_CHECK = 60000L;

    private static synchronized void loadLibrary(Intent intent) {
        if (sHasLoaded) {
            return;
        }
        MatrixLog.i((String)TAG, (String)"Init called.", (Object[])new Object[0]);
        WeChatBacktrace.loadLibrary();
        boolean enableLogger = intent.getBooleanExtra(BIND_ARGS_ENABLE_LOGGER, false);
        String pathOfXLogSo = intent.getStringExtra(BIND_ARGS_PATH_OF_XLOG_SO);
        MatrixLog.i((String)TAG, (String)"Enable logger: %s", (Object[])new Object[]{enableLogger});
        MatrixLog.i((String)TAG, (String)"Path of XLog: %s", (Object[])new Object[]{pathOfXLogSo});
        XLogNative.setXLogger(pathOfXLogSo);
        WeChatBacktrace.enableLogger(enableLogger);
        sHasLoaded = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void init() {
        if (sHasInitiated) {
            return;
        }
        byte[] byArray = sRecyclerLock;
        synchronized (sRecyclerLock) {
            if (sRecycler == null) {
                sRecycler = new HandlerThread("backtrace-recycler");
                sRecycler.start();
                sRecyclerHandler = new Handler(sRecycler.getLooper(), (Handler.Callback)new RecyclerCallback());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            WarmUpService.scheduleSuicide(true);
            sHasInitiated = true;
            return;
        }
    }

    private boolean isNullOrNil(String string) {
        return string == null || string.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleSuicide(boolean onCreate) {
        MatrixLog.i((String)TAG, (String)"Schedule suicide", (Object[])new Object[0]);
        byte[] byArray = sRecyclerLock;
        synchronized (sRecyclerLock) {
            if (onCreate) {
                sRecyclerHandler.sendEmptyMessageDelayed(1, 60000L);
            } else if (sWorkingCall.decrementAndGet() == 0) {
                sRecyclerHandler.sendEmptyMessageDelayed(1, 60000L);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeScheduledSuicide() {
        MatrixLog.i((String)TAG, (String)"Remove scheduled suicide", (Object[])new Object[0]);
        byte[] byArray = sRecyclerLock;
        synchronized (sRecyclerLock) {
            sRecyclerHandler.removeMessages(1);
            sWorkingCall.getAndIncrement();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Bundle call(int cmd, Bundle args) {
        this.removeScheduledSuicide();
        try {
            Bundle result = new Bundle();
            result.putInt(RESULT_OF_WARM_UP, -1);
            if (args == null) {
                MatrixLog.i((String)TAG, (String)"Args is null.", (Object[])new Object[0]);
                Bundle bundle = result;
                return bundle;
            }
            String savingPath = args.getString(ARGS_WARM_UP_SAVING_PATH, null);
            MatrixLog.i((String)TAG, (String)"Invoke from client with savingPath: %s.", (Object[])new Object[]{savingPath});
            if (this.isNullOrNil(savingPath)) {
                MatrixLog.i((String)TAG, (String)"Saving path is empty.", (Object[])new Object[0]);
                Bundle bundle = result;
                return bundle;
            }
            this.mWarmUpDelegate.setSavingPath(savingPath);
            if (cmd == 100) {
                String pathOfSo = args.getString(ARGS_WARM_UP_PATH_OF_ELF, null);
                if (this.isNullOrNil(pathOfSo)) {
                    MatrixLog.i((String)TAG, (String)"Warm-up so path is empty.", (Object[])new Object[0]);
                    Bundle bundle = result;
                    return bundle;
                }
                int offset = args.getInt(ARGS_WARM_UP_ELF_START_OFFSET, 0);
                MatrixLog.i((String)TAG, (String)"Warm up so path %s offset %s.", (Object[])new Object[]{pathOfSo, offset});
                int ret = 0;
                if (!WarmUpUtility.UnfinishedManagement.checkAndMark((Context)this, pathOfSo, offset)) {
                    ret = -3;
                } else {
                    boolean success = WarmUpDelegate.internalWarmUpSoPath(pathOfSo, offset, true);
                    if (!WeChatBacktraceNative.testLoadQut(pathOfSo, offset)) {
                        MatrixLog.w((String)TAG, (String)"Warm up elf %s:%s success, but test load qut failed!", (Object[])new Object[]{pathOfSo, offset});
                        success = false;
                    }
                    WarmUpUtility.UnfinishedManagement.result((Context)this, pathOfSo, offset, success);
                    ret = success ? 0 : -2;
                }
                result.putInt(RESULT_OF_WARM_UP, ret);
            } else {
                MatrixLog.w((String)TAG, (String)"Unknown cmd: %s", (Object[])new Object[]{cmd});
            }
            Bundle bundle = result;
            return bundle;
        }
        finally {
            WarmUpService.scheduleSuicide(false);
        }
    }

    public void onCreate() {
        super.onCreate();
        if (!sHasInitiated) {
            WarmUpService.init();
        }
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        if (!sHasLoaded) {
            WarmUpService.loadLibrary(intent);
        }
        return this.mMessenger.getBinder();
    }

    static {
        sWorkingCall = new AtomicInteger(0);
        sRecyclerLock = new byte[0];
    }

    private static final class RecyclerCallback
    implements Handler.Callback {
        private RecyclerCallback() {
        }

        public boolean handleMessage(Message msg) {
            if (msg.what == 1) {
                MatrixLog.i((String)WarmUpService.TAG, (String)"Suicide.", (Object[])new Object[0]);
                Process.killProcess((int)Process.myPid());
                System.exit(0);
            }
            return false;
        }
    }

    static final class RemoteInvokerImpl
    implements RemoteInvoker,
    RemoteConnection {
        private static final String TAG = "Matrix.WarmUpInvoker";
        volatile Messenger mResp;
        volatile Messenger mReq;
        final Bundle[] mResult = new Bundle[]{null};
        final HandlerThread[] mHandlerThread = new HandlerThread[]{null};
        ServiceConnection mConnection = new ServiceConnection(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName name, IBinder service) {
                RemoteInvokerImpl.this.mReq = new Messenger(service);
                boolean[] blArray = RemoteInvokerImpl.this.mBound;
                synchronized (blArray) {
                    ((RemoteInvokerImpl)RemoteInvokerImpl.this).mBound[0] = true;
                    RemoteInvokerImpl.this.mBound.notifyAll();
                }
                MatrixLog.i((String)RemoteInvokerImpl.TAG, (String)"This remote invoker(%s) connected.", (Object[])new Object[]{this});
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName name) {
                RemoteInvokerImpl.this.mReq = null;
                Object[] objectArray = RemoteInvokerImpl.this.mBound;
                synchronized (objectArray) {
                    ((RemoteInvokerImpl)RemoteInvokerImpl.this).mBound[0] = false;
                    RemoteInvokerImpl.this.mBound.notifyAll();
                }
                MatrixLog.i((String)RemoteInvokerImpl.TAG, (String)"This remote invoker(%s) disconnected.", (Object[])new Object[]{this});
                objectArray = RemoteInvokerImpl.this.mResult;
                synchronized (RemoteInvokerImpl.this.mResult) {
                    RemoteInvokerImpl.this.mResult[0] = null;
                    RemoteInvokerImpl.this.mResult.notifyAll();
                    // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                    return;
                }
            }
        };
        private final boolean[] mBound = new boolean[]{false};

        RemoteInvokerImpl() {
        }

        private void checkThread() {
            if (Looper.getMainLooper() == Looper.myLooper()) {
                throw new RuntimeException("Should not call this from main thread!");
            }
        }

        @Override
        public boolean isConnected() {
            return this.mBound[0];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean connect(Context context, Bundle args) {
            this.checkThread();
            if (this.mBound[0]) {
                return true;
            }
            MatrixLog.i((String)TAG, (String)"Start connecting to remote. (%s)", (Object[])new Object[]{this.hashCode()});
            HandlerThread[] handlerThreadArray = this.mHandlerThread;
            synchronized (this.mHandlerThread) {
                if (this.mHandlerThread[0] != null) {
                    this.mHandlerThread[0].quitSafely();
                    this.mHandlerThread[0] = null;
                }
                this.mHandlerThread[0] = new HandlerThread("warm-up-remote-invoker-" + this.hashCode());
                this.mHandlerThread[0].start();
                this.mResp = new Messenger(new Handler(this.mHandlerThread[0].getLooper()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void handleMessage(Message msg) {
                        if (!(msg.obj instanceof Bundle)) return;
                        Bundle bundle = (Bundle)msg.obj;
                        Bundle[] bundleArray = RemoteInvokerImpl.this.mResult;
                        synchronized (RemoteInvokerImpl.this.mResult) {
                            RemoteInvokerImpl.this.mResult[0] = bundle;
                            RemoteInvokerImpl.this.mResult.notifyAll();
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return;
                        }
                    }
                });
                // ** MonitorExit[var3_3] (shouldn't be in output)
                Intent intent = new Intent();
                intent.setComponent(new ComponentName(context, WarmUpService.class));
                intent.putExtra(WarmUpService.BIND_ARGS_ENABLE_LOGGER, args.getBoolean(WarmUpService.BIND_ARGS_ENABLE_LOGGER, false));
                intent.putExtra(WarmUpService.BIND_ARGS_PATH_OF_XLOG_SO, args.getString(WarmUpService.BIND_ARGS_PATH_OF_XLOG_SO, null));
                context.bindService(intent, this.mConnection, 1);
                try {
                    boolean[] blArray = this.mBound;
                    synchronized (this.mBound) {
                        if (!this.mBound[0]) {
                            this.mBound.wait(60000L);
                        }
                        // ** MonitorExit[var4_5] (shouldn't be in output)
                    }
                }
                catch (InterruptedException e) {
                    MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                }
                {
                    if (!this.mBound[0]) {
                        this.disconnect(context);
                    }
                    return this.mBound[0];
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disconnect(Context context) {
            try {
                context.unbindService(this.mConnection);
            }
            catch (Throwable e) {
                MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
            }
            MatrixLog.i((String)TAG, (String)"Start disconnecting to remote. (%s)", (Object[])new Object[]{this.hashCode()});
            HandlerThread[] handlerThreadArray = this.mHandlerThread;
            synchronized (this.mHandlerThread) {
                if (this.mHandlerThread[0] != null) {
                    this.mHandlerThread[0].quitSafely();
                    this.mHandlerThread[0] = null;
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                handlerThreadArray = this.mResult;
                synchronized (this.mResult) {
                    this.mResult[0] = null;
                    this.mResult.notifyAll();
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Bundle call(int cmd, Bundle args) {
            try {
                Messenger req = this.mReq;
                if (req != null) {
                    Bundle wrap = new Bundle();
                    wrap.putBundle(WarmUpService.INVOKE_ARGS, args);
                    wrap.putBinder(WarmUpService.INVOKE_RESP, this.mResp.getBinder());
                    req.send(Message.obtain(null, (int)cmd, (Object)wrap));
                    Bundle[] bundleArray = this.mResult;
                    synchronized (this.mResult) {
                        this.mResult[0] = null;
                        this.mResult.wait(300000L);
                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        return this.mResult[0];
                    }
                }
            }
            catch (RemoteException | InterruptedException e) {
                MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
            }
            return null;
        }
    }

    static interface RemoteConnection {
        public boolean isConnected();

        public boolean connect(Context var1, Bundle var2);

        public void disconnect(Context var1);
    }

    static interface RemoteInvoker {
        public Bundle call(int var1, Bundle var2);
    }
}

