/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.backtrace;

import android.content.Context;
import android.os.CancellationSignal;
import com.tencent.matrix.backtrace.WeChatBacktrace;
import com.tencent.matrix.util.MatrixLog;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

class WarmUpUtility {
    private static final String TAG = "Matrix.Backtrace.WarmUp";
    private static final String DIR_WECHAT_BACKTRACE = "wechat-backtrace";
    private static final String FILE_DEFAULT_SAVING_PATH = "saving-cache";
    private static final String FILE_WARMED_UP = "warmed-up";
    private static final String FILE_DISK_USAGE = "disk-usage.timestamp";
    private static final String FILE_CLEAN_UP_TIMESTAMP = "clean-up.timestamp";
    private static final String FILE_BLOCKED_LIST = "blocked-list";
    private static final String FILE_UNFINISHED = "unfinished";
    static final long DURATION_LAST_ACCESS_FAR_FUTURE = 604800000L;
    static final long DURATION_LAST_ACCESS_EXPIRED = 259200000L;
    static final long DURATION_CLEAN_UP_EXPIRED = 172800000L;
    static final long DURATION_CLEAN_UP = 172800000L;
    static final long DURATION_DISK_USAGE_COMPUTATION = 259200000L;
    static final int WARM_UP_FILE_MAX_RETRY = 3;
    static final String UNFINISHED_KEY_SPLIT = ":";
    static final String UNFINISHED_RETRY_SPLIT = "|";

    WarmUpUtility() {
    }

    static File cleanUpTimestampFile(Context context) {
        File file = new File(context.getFilesDir().getAbsolutePath() + "/" + DIR_WECHAT_BACKTRACE + "/" + FILE_CLEAN_UP_TIMESTAMP);
        file.getParentFile().mkdirs();
        return file;
    }

    static File warmUpMarkedFile(Context context) {
        File file = new File(context.getFilesDir().getAbsolutePath() + "/" + DIR_WECHAT_BACKTRACE + "/" + FILE_WARMED_UP);
        file.getParentFile().mkdirs();
        return file;
    }

    static File diskUsageFile(Context context) {
        File file = new File(context.getFilesDir().getAbsolutePath() + "/" + DIR_WECHAT_BACKTRACE + "/" + FILE_DISK_USAGE);
        file.getParentFile().mkdirs();
        return file;
    }

    static String defaultSavingPath(WeChatBacktrace.Configuration configuration) {
        return configuration.mContext.getFilesDir().getAbsolutePath() + "/" + DIR_WECHAT_BACKTRACE + "/" + FILE_DEFAULT_SAVING_PATH + "/";
    }

    static String validateSavingPath(WeChatBacktrace.Configuration configuration) {
        if (WarmUpUtility.pathValidation(configuration)) {
            return configuration.mSavingPath;
        }
        return WarmUpUtility.defaultSavingPath(configuration);
    }

    static boolean pathValidation(WeChatBacktrace.Configuration configuration) {
        if (configuration.mSavingPath == null) {
            return false;
        }
        File savingPath = new File(configuration.mSavingPath);
        try {
            if (savingPath.getCanonicalPath().startsWith(configuration.mContext.getFilesDir().getParentFile().getCanonicalFile().getAbsolutePath())) {
                return true;
            }
            MatrixLog.e((String)TAG, (String)"Saving path should under private storage path %s", (Object[])new Object[]{configuration.mContext.getFilesDir().getParentFile().getAbsolutePath()});
        }
        catch (IOException e) {
            MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
        }
        return false;
    }

    static File unfinishedFile(Context context) {
        File file = new File(context.getFilesDir().getAbsolutePath() + "/" + DIR_WECHAT_BACKTRACE + "/" + FILE_UNFINISHED);
        file.getParentFile().mkdirs();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
            }
        }
        return file;
    }

    static String unfinishedKey(String pathOfElf, int offset) {
        return pathOfElf + UNFINISHED_KEY_SPLIT + offset;
    }

    static void flushUnfinishedMaps(Context context, Map<String, Integer> unfinished) {
        File file = WarmUpUtility.unfinishedFile(context);
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Integer> entry : unfinished.entrySet()) {
            sb.append(entry.getKey() + UNFINISHED_RETRY_SPLIT + entry.getValue() + "\n");
        }
        WarmUpUtility.writeContentToFile(file, sb.toString());
    }

    static Map<String, Integer> readUnfinishedMaps(Context context) {
        HashMap<String, Integer> maps = new HashMap<String, Integer>();
        File file = WarmUpUtility.unfinishedFile(context);
        String content = WarmUpUtility.readFileContent(file, 512000);
        if (content == null) {
            MatrixLog.w((String)TAG, (String)"Read unfinished maps file failed, file size %s", (Object[])new Object[]{file.length()});
            if (file.length() > 512000L) {
                file.delete();
            }
        } else {
            String[] lines;
            for (String line : lines = content.split("\n")) {
                int index = line.lastIndexOf(UNFINISHED_RETRY_SPLIT);
                if (index < 0) continue;
                try {
                    String key = line.substring(0, index);
                    String value = line.substring(index + 1);
                    maps.put(key, Integer.parseInt(value));
                }
                catch (Throwable ignore) {
                    MatrixLog.printErrStackTrace((String)TAG, (Throwable)ignore, (String)"", (Object[])new Object[0]);
                }
            }
        }
        return maps;
    }

    static boolean needCleanUp(Context context) {
        File timestamp = WarmUpUtility.cleanUpTimestampFile(context);
        if (!timestamp.exists()) {
            try {
                timestamp.createNewFile();
            }
            catch (IOException e) {
                MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
            }
            return false;
        }
        return System.currentTimeMillis() - timestamp.lastModified() >= 172800000L;
    }

    static boolean shouldComputeDiskUsage(Context context) {
        File timestamp = WarmUpUtility.diskUsageFile(context);
        if (!timestamp.exists()) {
            try {
                timestamp.createNewFile();
            }
            catch (IOException e) {
                MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
            }
            return false;
        }
        return System.currentTimeMillis() - timestamp.lastModified() >= 259200000L;
    }

    static void markComputeDiskUsageTimestamp(Context context) {
        File timestamp = WarmUpUtility.diskUsageFile(context);
        try {
            timestamp.createNewFile();
            timestamp.setLastModified(System.currentTimeMillis());
        }
        catch (IOException e) {
            MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
        }
    }

    static boolean hasWarmedUp(Context context) {
        return WarmUpUtility.warmUpMarkedFile(context).exists();
    }

    static void markCleanUpTimestamp(Context context) {
        File timestamp = WarmUpUtility.cleanUpTimestampFile(context);
        try {
            timestamp.createNewFile();
            timestamp.setLastModified(System.currentTimeMillis());
        }
        catch (IOException e) {
            MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
        }
    }

    static void iterateTargetDirectory(File target, CancellationSignal cs, FileFilter filter) {
        if (target.isDirectory()) {
            File[] files = target.listFiles();
            if (files != null) {
                for (File file : files) {
                    WarmUpUtility.iterateTargetDirectory(file, cs, filter);
                    cs.throwIfCanceled();
                }
            }
        } else {
            filter.accept(target);
            cs.throwIfCanceled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readFileContent(File file, int max) {
        if (file.isFile()) {
            InputStreamReader reader = null;
            try {
                int len;
                StringBuilder sb = new StringBuilder(4096);
                reader = new FileReader(file);
                char[] buffer = new char[1024];
                int accumulated = 0;
                while ((len = reader.read(buffer)) > 0) {
                    sb.append(buffer, 0, len);
                    if ((accumulated += len) <= max) continue;
                    String string = null;
                    return string;
                }
                String string = sb.toString();
                return string;
            }
            catch (Exception e) {
                MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean writeContentToFile(File file, String content) {
        if (file.isFile()) {
            FileWriter writer = null;
            try {
                writer = new FileWriter(file);
                writer.write(content);
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                    }
                }
            }
        }
        return false;
    }

    static class UnfinishedManagement {
        private static Map<String, Integer> mUnfinishedWarmUp;

        UnfinishedManagement() {
        }

        private static int retryCount(Context context, String key) {
            Integer value;
            if (mUnfinishedWarmUp == null) {
                mUnfinishedWarmUp = WarmUpUtility.readUnfinishedMaps(context);
            }
            return (value = mUnfinishedWarmUp.get(key)) != null ? value : 0;
        }

        public static boolean check(Context context, String pathOfElf, int offset) {
            String key = WarmUpUtility.unfinishedKey(pathOfElf, offset);
            int retryCount = UnfinishedManagement.retryCount(context, key);
            return retryCount < 3;
        }

        public static boolean checkAndMark(Context context, String pathOfElf, int offset) {
            String key = WarmUpUtility.unfinishedKey(pathOfElf, offset);
            int retryCount = UnfinishedManagement.retryCount(context, key);
            if (retryCount >= 3) {
                return false;
            }
            mUnfinishedWarmUp.put(key, retryCount + 1);
            WarmUpUtility.flushUnfinishedMaps(context, mUnfinishedWarmUp);
            return true;
        }

        public static void result(Context context, String pathOfElf, int offset, boolean success) {
            String key = WarmUpUtility.unfinishedKey(pathOfElf, offset);
            int retryCount = UnfinishedManagement.retryCount(context, key);
            if (success) {
                mUnfinishedWarmUp.remove(key);
            } else {
                mUnfinishedWarmUp.put(key, retryCount + 1);
            }
            WarmUpUtility.flushUnfinishedMaps(context, mUnfinishedWarmUp);
        }
    }
}

