/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.backtrace;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.tencent.matrix.backtrace.ProcessUtil;
import com.tencent.matrix.backtrace.WarmUpDelegate;
import com.tencent.matrix.backtrace.WarmUpReporter;
import com.tencent.matrix.backtrace.WarmUpUtility;
import com.tencent.matrix.backtrace.WeChatBacktraceNative;
import com.tencent.matrix.util.MatrixLog;
import com.tencent.matrix.xlog.XLogNative;
import java.io.File;
import java.util.HashSet;

public class WeChatBacktrace {
    private static final String TAG = "Matrix.Backtrace";
    private static final String SYSTEM_LIBRARY_PATH_Q = "/apex/com.android.runtime/lib/";
    private static final String SYSTEM_LIBRARY_PATH_Q_64 = "/apex/com.android.runtime/lib64/";
    private static final String SYSTEM_LIBRARY_PATH = "/system/lib/";
    private static final String SYSTEM_LIBRARY_PATH_64 = "/system/lib64/";
    private static final String SYSTEM_BOOT_OAT_PATH = "/system/framework/arm/";
    private static final String SYSTEM_BOOT_OAT_PATH_64 = "/system/framework/arm64/";
    public static final String ISOLATE_PROCESS_SUFFIX = ":backtrace__";
    private static final String BACKTRACE_LIBRARY_NAME = "wechatbacktrace";
    private volatile boolean mInitialized;
    private volatile boolean mConfigured;
    private volatile Configuration mConfiguration;
    private final WarmUpDelegate mWarmUpDelegate = new WarmUpDelegate();
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private static boolean sLibraryLoaded = false;
    private boolean mScheduleQutGenerationRequestsRunning = false;

    public static boolean is64BitRuntime() {
        String currRuntimeABI = Build.CPU_ABI;
        return "arm64-v8a".equalsIgnoreCase(currRuntimeABI) || "x86_64".equalsIgnoreCase(currRuntimeABI) || "mips64".equalsIgnoreCase(currRuntimeABI);
    }

    public static String getSystemLibraryPath() {
        if (Build.VERSION.SDK_INT >= 29) {
            return !WeChatBacktrace.is64BitRuntime() ? SYSTEM_LIBRARY_PATH_Q : SYSTEM_LIBRARY_PATH_Q_64;
        }
        return !WeChatBacktrace.is64BitRuntime() ? SYSTEM_LIBRARY_PATH : SYSTEM_LIBRARY_PATH_64;
    }

    public static String getSystemFrameworkOATPath() {
        return !WeChatBacktrace.is64BitRuntime() ? SYSTEM_BOOT_OAT_PATH : SYSTEM_BOOT_OAT_PATH_64;
    }

    public static String getBaseODEXPath(Context context) {
        String abiName = !WeChatBacktrace.is64BitRuntime() ? "arm" : "arm64";
        return new File(new File(context.getApplicationInfo().nativeLibraryDir).getParentFile().getParentFile(), "/oat/" + abiName + "/base.odex").getAbsolutePath();
    }

    public static void setReporter(WarmUpReporter reporter) {
        WarmUpDelegate.sReporter = reporter;
    }

    public static WeChatBacktrace instance() {
        return Singleton.INSTANCE;
    }

    public boolean isBacktraceThreadBlocked() {
        return this.mWarmUpDelegate.isBacktraceThreadBlocked();
    }

    private void requestQutGenerate() {
        if (!this.mInitialized || !this.mConfigured) {
            return;
        }
        this.mWarmUpDelegate.requestConsuming();
    }

    private void startScheduleQutGenerationRequests() {
        if (this.mScheduleQutGenerationRequestsRunning) {
            return;
        }
        this.mScheduleQutGenerationRequestsRunning = false;
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                WeChatBacktrace.this.requestQutGenerate();
                WeChatBacktrace.this.mScheduleQutGenerationRequestsRunning = false;
                WeChatBacktrace.this.startScheduleQutGenerationRequests();
            }
        }, 21600000L);
    }

    public synchronized Configuration configure(Context context) {
        if (this.mConfiguration != null) {
            return this.mConfiguration;
        }
        this.mConfiguration = new Configuration(context, this);
        this.mInitialized = true;
        return this.mConfiguration;
    }

    public String getSavingPath() {
        return this.mWarmUpDelegate.mSavingPath;
    }

    public static void loadLibrary(LibraryLoader loader) {
        if (sLibraryLoaded) {
            return;
        }
        if (loader == null) {
            WeChatBacktrace.loadLibrary();
        } else {
            MatrixLog.i((String)TAG, (String)"Using custom library loader: %s.", (Object[])new Object[]{loader});
            loader.load(BACKTRACE_LIBRARY_NAME);
        }
        sLibraryLoaded = true;
    }

    static void loadLibrary() {
        System.loadLibrary(BACKTRACE_LIBRARY_NAME);
    }

    static void enableLogger(boolean enableLogger) {
        WeChatBacktraceNative.enableLogger(enableLogger);
    }

    private void dealWithCoolDown(Configuration configuration) {
        if (configuration.mIsWarmUpProcess) {
            File markFile = WarmUpUtility.warmUpMarkedFile(configuration.mContext);
            if (configuration.mCoolDownIfApkUpdated && markFile.exists()) {
                String content = WarmUpUtility.readFileContent(markFile, 4096);
                if (content == null) {
                    configuration.mCoolDown = true;
                } else {
                    String lastNativeLibraryPath = content.split("\n")[0];
                    if (!lastNativeLibraryPath.equalsIgnoreCase(configuration.mContext.getApplicationInfo().nativeLibraryDir)) {
                        MatrixLog.i((String)TAG, (String)"Apk updated, remove warmed-up file.", (Object[])new Object[0]);
                        configuration.mCoolDown = true;
                    }
                }
            }
            if (configuration.mCoolDown) {
                markFile.delete();
                File unfinishedFile = WarmUpUtility.unfinishedFile(configuration.mContext);
                unfinishedFile.delete();
            }
        }
    }

    private boolean runningInIsolateProcess(Configuration configuration) {
        String processName = ProcessUtil.getProcessNameByPid(configuration.mContext);
        return processName != null && processName.endsWith(ISOLATE_PROCESS_SUFFIX);
    }

    private void configure(Configuration configuration) {
        if (this.runningInIsolateProcess(configuration)) {
            MatrixLog.i((String)TAG, (String)"Isolate process does not need any configuration.", (Object[])new Object[0]);
            return;
        }
        if (configuration.mWarmUpInIsolateProcess && configuration.mLibraryLoader != null) {
            throw new ConfigurationException("Custom library loader is not supported in isolate process warm-up mode.");
        }
        WeChatBacktrace.loadLibrary(configuration.mLibraryLoader);
        XLogNative.setXLogger(configuration.mPathOfXLogSo);
        WeChatBacktrace.enableLogger(configuration.mEnableLog);
        MatrixLog.i((String)TAG, (String)configuration.toString(), (Object[])new Object[0]);
        if (configuration.mBacktraceMode == Mode.Fp || configuration.mBacktraceMode == Mode.Dwarf) {
            WeChatBacktraceNative.setBacktraceMode(configuration.mBacktraceMode.value);
        }
        if (configuration.mBacktraceMode == Mode.Quicken || configuration.mBacktraceMode == Mode.FpUntilQuickenWarmedUp || configuration.mBacktraceMode == Mode.DwarfUntilQuickenWarmedUp || configuration.mQuickenAlwaysOn) {
            String savingPath = WarmUpUtility.validateSavingPath(configuration);
            MatrixLog.i((String)TAG, (String)"Set saving path: %s", (Object[])new Object[]{savingPath});
            File file = new File(savingPath);
            file.mkdirs();
            if (!savingPath.endsWith(File.separator)) {
                savingPath = savingPath + File.separator;
            }
            this.mWarmUpDelegate.setSavingPath(savingPath);
            this.dealWithCoolDown(configuration);
            this.mWarmUpDelegate.prepare(configuration);
            boolean hasWarmedUp = WarmUpUtility.hasWarmedUp(configuration.mContext);
            if (configuration.mBacktraceMode == Mode.Quicken || !configuration.mQuickenAlwaysOn) {
                Mode mode = Mode.Quicken;
                if (!hasWarmedUp) {
                    if (configuration.mBacktraceMode == Mode.FpUntilQuickenWarmedUp) {
                        mode = Mode.Fp;
                    } else if (configuration.mBacktraceMode == Mode.DwarfUntilQuickenWarmedUp) {
                        mode = Mode.Dwarf;
                    }
                }
                WeChatBacktraceNative.setBacktraceMode(mode.value);
            }
            MatrixLog.i((String)TAG, (String)"Has warmed up: %s", (Object[])new Object[]{hasWarmedUp});
            WeChatBacktraceNative.setWarmedUp(hasWarmedUp);
            this.startScheduleQutGenerationRequests();
            if (!configuration.mIsWarmUpProcess) {
                this.mWarmUpDelegate.registerWarmedUpReceiver(configuration, configuration.mBacktraceMode);
            }
        }
        this.mConfigured = true;
    }

    public static boolean hasWarmedUp(Context context) {
        return WarmUpUtility.hasWarmedUp(context);
    }

    public static int[] doStatistic(String pathOfSo) {
        return WeChatBacktraceNative.statistic(pathOfSo);
    }

    public static final class Configuration {
        Context mContext;
        String mSavingPath;
        HashSet<String> mWarmUpDirectoriesList = new HashSet();
        Mode mBacktraceMode = Mode.Quicken;
        LibraryLoader mLibraryLoader = null;
        boolean mCoolDown = false;
        boolean mQuickenAlwaysOn = false;
        boolean mCoolDownIfApkUpdated = true;
        boolean mIsWarmUpProcess = false;
        boolean mWarmUpInIsolateProcess = true;
        WarmUpTiming mWarmUpTiming = WarmUpTiming.WhileScreenOff;
        long mWarmUpDelay = 3000L;
        boolean mEnableLog = false;
        boolean mEnableIsolateProcessLog = false;
        String mPathOfXLogSo = null;
        private boolean mCommitted = false;
        private final WeChatBacktrace mWeChatBacktrace;

        Configuration(Context context, WeChatBacktrace backtrace) {
            this.mContext = context;
            this.mWeChatBacktrace = backtrace;
            this.mWarmUpDirectoriesList.add(context.getApplicationInfo().nativeLibraryDir);
            this.mWarmUpDirectoriesList.add(WeChatBacktrace.getSystemLibraryPath());
            this.mWarmUpDirectoriesList.add(WeChatBacktrace.getBaseODEXPath(context));
            this.mIsWarmUpProcess = ProcessUtil.isMainProcess(this.mContext);
        }

        public Configuration savingPath(String savingPath) {
            if (this.mCommitted) {
                return this;
            }
            this.mSavingPath = savingPath;
            return this;
        }

        public Configuration setBacktraceMode(Mode mode) {
            if (this.mCommitted) {
                return this;
            }
            if (mode != null) {
                this.mBacktraceMode = mode;
            }
            return this;
        }

        public Configuration setQuickenAlwaysOn() {
            if (this.mCommitted) {
                return this;
            }
            this.mQuickenAlwaysOn = true;
            return this;
        }

        public Configuration setLibraryLoader(LibraryLoader loader) {
            if (this.mCommitted) {
                return this;
            }
            this.mLibraryLoader = loader;
            return this;
        }

        public Configuration directoryToWarmUp(String directory) {
            if (this.mCommitted) {
                return this;
            }
            this.mWarmUpDirectoriesList.add(directory);
            return this;
        }

        public Configuration clearWarmUpDirectorySet() {
            if (this.mCommitted) {
                return this;
            }
            this.mWarmUpDirectoriesList.clear();
            return this;
        }

        public Configuration coolDown(boolean coolDown) {
            if (this.mCommitted) {
                return this;
            }
            this.mCoolDown = coolDown;
            return this;
        }

        public Configuration coolDownIfApkUpdated(boolean ifApkUpdated) {
            if (this.mCommitted) {
                return this;
            }
            this.mCoolDownIfApkUpdated = ifApkUpdated;
            return this;
        }

        public Configuration isWarmUpProcess(boolean isWarmUpProcess) {
            if (this.mCommitted) {
                return this;
            }
            this.mIsWarmUpProcess = isWarmUpProcess;
            return this;
        }

        public Configuration warmUpInIsolateProcess(boolean isolateProcess) {
            if (this.mCommitted) {
                return this;
            }
            this.mWarmUpInIsolateProcess = isolateProcess;
            return this;
        }

        public Configuration warmUpSettings(WarmUpTiming timing, long delayMs) {
            if (this.mCommitted) {
                return this;
            }
            this.mWarmUpTiming = timing;
            this.mWarmUpDelay = delayMs;
            return this;
        }

        public Configuration xLoggerPath(String pathOfXLogSo) {
            if (this.mCommitted) {
                return this;
            }
            this.mPathOfXLogSo = pathOfXLogSo;
            return this;
        }

        public Configuration enableOtherProcessLogger(boolean enable) {
            if (this.mCommitted) {
                return this;
            }
            this.mEnableLog = enable;
            return this;
        }

        public Configuration enableIsolateProcessLogger(boolean enable) {
            if (this.mCommitted) {
                return this;
            }
            this.mEnableIsolateProcessLog = enable;
            return this;
        }

        public void commit() {
            if (this.mCommitted) {
                return;
            }
            this.mCommitted = true;
            this.mWeChatBacktrace.configure(this);
        }

        public String toString() {
            return "\nWeChat backtrace configurations: \n>>> Backtrace Mode: " + (Object)((Object)this.mBacktraceMode) + "\n>>> Quicken always on: " + this.mQuickenAlwaysOn + "\n>>> Saving Path: " + (this.mSavingPath != null ? this.mSavingPath : WarmUpUtility.defaultSavingPath(this)) + "\n>>> Custom Library Loader: " + (this.mLibraryLoader != null) + "\n>>> Directories to Warm-up: " + this.mWarmUpDirectoriesList.toString() + "\n>>> Is Warm-up Process: " + this.mIsWarmUpProcess + "\n>>> Warm-up Timing: " + (Object)((Object)this.mWarmUpTiming) + "\n>>> Warm-up Delay: " + this.mWarmUpDelay + "ms\n>>> Warm-up in isolate process: " + this.mWarmUpInIsolateProcess + "\n>>> Enable logger: " + this.mEnableLog + "\n>>> Enable Isolate Process logger: " + this.mEnableIsolateProcessLog + "\n>>> Path of XLog: " + this.mPathOfXLogSo + "\n>>> Cool-down: " + this.mCoolDown + "\n>>> Cool-down if Apk Updated: " + this.mCoolDownIfApkUpdated + "\n";
        }
    }

    public static enum WarmUpTiming {
        WhileScreenOff,
        WhileCharging,
        PostStartup;

    }

    public static enum Mode {
        Fp(0),
        Quicken(1),
        Dwarf(2),
        FpUntilQuickenWarmedUp(3),
        DwarfUntilQuickenWarmedUp(4);

        int value;

        private Mode(int mode) {
            this.value = mode;
        }

        public String toString() {
            switch (this) {
                case Fp: {
                    return "FramePointer-based.";
                }
                case Quicken: {
                    return "WeChat QuickenUnwindTable-based.";
                }
                case Dwarf: {
                    return "Dwarf-based.";
                }
                case FpUntilQuickenWarmedUp: {
                    return "Use fp-based backtrace before quicken has warmed up.";
                }
                case DwarfUntilQuickenWarmedUp: {
                    return "Use dwarf-based backtrace before quicken has warmed up.";
                }
            }
            return "Unreachable.";
        }
    }

    public static final class ConfigurationException
    extends RuntimeException {
        public ConfigurationException(String message) {
            super(message);
        }
    }

    private static final class Singleton {
        public static final WeChatBacktrace INSTANCE = new WeChatBacktrace();

        private Singleton() {
        }
    }

    public static interface LibraryLoader {
        public void load(String var1);
    }
}

