/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.javalib.util;

import com.tencent.matrix.javalib.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    private static final String TAG = "Matrix.FileUtil";
    public static final int BUFFER_SIZE = 16384;

    public static final boolean isLegalFile(File file) {
        return file != null && file.exists() && file.canRead() && file.isFile() && file.length() > 0L;
    }

    public static final boolean isLegalFile(String filename) {
        File file = new File(filename);
        return FileUtil.isLegalFile(file);
    }

    public static long getFileOrDirectorySize(File directory) {
        if (directory == null || !directory.exists()) {
            return 0L;
        }
        if (directory.isFile()) {
            return directory.length();
        }
        long totalSize = 0L;
        File[] fileList = directory.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (file.isDirectory()) {
                    totalSize += FileUtil.getFileOrDirectorySize(file);
                    continue;
                }
                totalSize += file.length();
            }
        }
        return totalSize;
    }

    public static final boolean safeDeleteFile(File file) {
        if (file == null) {
            return true;
        }
        if (file.exists()) {
            boolean deleted = file.delete();
            if (!deleted) {
                Log.e(TAG, "Failed to delete file, try to delete when exit. path: " + file.getPath(), new Object[0]);
                file.deleteOnExit();
            }
            return deleted;
        }
        return true;
    }

    public static final boolean deleteDir(String dir) {
        if (dir == null) {
            return false;
        }
        return FileUtil.deleteDir(new File(dir));
    }

    public static final boolean deleteDir(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isFile()) {
            FileUtil.safeDeleteFile(file);
        } else if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File subFile : files) {
                FileUtil.deleteDir(subFile);
            }
            FileUtil.safeDeleteFile(file);
        }
        return true;
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            Log.w(TAG, "Failed to close resource", e);
        }
    }

    public static void closeZip(ZipFile zipFile) {
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException e) {
            Log.w(TAG, "Failed to close resource", e);
        }
    }

    public static void ensureFileDirectory(File file) {
        if (file == null) {
            return;
        }
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyResourceUsingStream(String name, File dest) throws IOException {
        FileOutputStream os = null;
        File parent = dest.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        InputStream is = null;
        try {
            int length;
            is = FileUtil.class.getResourceAsStream("/" + name);
            os = new FileOutputStream(dest, false);
            byte[] buffer = new byte[16384];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietly(is);
            FileUtil.closeQuietly(os);
            throw throwable;
        }
        FileUtil.closeQuietly(is);
        FileUtil.closeQuietly(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingStream(File source, File dest) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        File parent = dest.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest, false);
            byte[] buffer = new byte[16384];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            FileUtil.closeQuietly(is);
            FileUtil.closeQuietly(os);
            throw throwable;
        }
        FileUtil.closeQuietly(is);
        FileUtil.closeQuietly(os);
    }

    public static boolean checkDirectory(String dir) {
        File dirObj = new File(dir);
        FileUtil.deleteDir(dirObj);
        if (!dirObj.exists()) {
            dirObj.mkdirs();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String readFileAsString(String filePath) {
        StringBuffer fileData;
        block12: {
            if (!new File(filePath).exists()) {
                return "";
            }
            fileData = new StringBuffer();
            InputStreamReader fileReader = null;
            FileInputStream inputStream = null;
            inputStream = new FileInputStream(filePath);
            fileReader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            char[] buf = new char[16384];
            int numRead = 0;
            while ((numRead = fileReader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
            }
            try {
                FileUtil.closeQuietly(fileReader);
                FileUtil.closeQuietly(inputStream);
            }
            catch (Exception e) {
                Log.e(TAG, "file op readFileAsString close e type:%s, e msg:%s, filePath:%s", e.getClass().getSimpleName(), e.getMessage(), filePath);
            }
            break block12;
            catch (Exception e) {
                String string;
                try {
                    Log.e(TAG, "file op readFileAsString e type:%s, e msg:%s, filePath:%s", e.getClass().getSimpleName(), e.getMessage(), filePath);
                    string = "";
                }
                catch (Throwable throwable) {
                    try {
                        FileUtil.closeQuietly(fileReader);
                        FileUtil.closeQuietly(inputStream);
                    }
                    catch (Exception e2) {
                        Log.e(TAG, "file op readFileAsString close e type:%s, e msg:%s, filePath:%s", e2.getClass().getSimpleName(), e2.getMessage(), filePath);
                    }
                    throw throwable;
                }
                try {
                    FileUtil.closeQuietly(fileReader);
                    FileUtil.closeQuietly(inputStream);
                }
                catch (Exception e3) {
                    Log.e(TAG, "file op readFileAsString close e type:%s, e msg:%s, filePath:%s", e3.getClass().getSimpleName(), e3.getMessage(), filePath);
                }
                return string;
            }
        }
        return fileData.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void unzip(String filePath, String destFolder) {
        ZipFile zipFile = null;
        BufferedOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            zipFile = new ZipFile(filePath);
            Enumeration<? extends ZipEntry> emu = zipFile.entries();
            while (emu.hasMoreElements()) {
                int count;
                ZipEntry entry = emu.nextElement();
                if (entry.isDirectory()) {
                    new File(destFolder, entry.getName()).mkdirs();
                    continue;
                }
                bis = new BufferedInputStream(zipFile.getInputStream(entry));
                File file = new File(destFolder, entry.getName());
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                }
                byte[] data = new byte[16384];
                bos = new BufferedOutputStream(new FileOutputStream(file), data.length);
                while ((count = bis.read(data, 0, data.length)) != -1) {
                    bos.write(data, 0, count);
                }
                bos.flush();
            }
        }
        catch (Exception exception) {
            FileUtil.closeQuietly(zipFile);
            FileUtil.closeQuietly(bis);
            FileUtil.closeQuietly(bos);
            catch (Throwable throwable) {
                FileUtil.closeQuietly(zipFile);
                FileUtil.closeQuietly(bis);
                FileUtil.closeQuietly(bos);
                throw throwable;
            }
        }
        FileUtil.closeQuietly(zipFile);
        FileUtil.closeQuietly(bis);
        FileUtil.closeQuietly(bos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(String srcFolder, String destZip) {
        block7: {
            FileOutputStream fos = null;
            ZipOutputStream zos = null;
            try {
                File dir = new File(srcFolder);
                ArrayList<String> filesListInDir = new ArrayList<String>();
                FileUtil.populateFilesList(filesListInDir, dir);
                fos = new FileOutputStream(destZip);
                zos = new ZipOutputStream(fos);
                for (String filePath : filesListInDir) {
                    int len;
                    ZipEntry ze = new ZipEntry(filePath.substring(dir.getAbsolutePath().length() + 1, filePath.length()));
                    zos.putNextEntry(ze);
                    FileInputStream fis = new FileInputStream(filePath);
                    byte[] buffer = new byte[16384];
                    while ((len = fis.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                    zos.closeEntry();
                    fis.close();
                }
                zos.close();
                fos.close();
                FileUtil.closeQuietly(zos);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                FileUtil.closeQuietly(zos);
                FileUtil.closeQuietly(fos);
            }
            FileUtil.closeQuietly(fos);
        }
    }

    private static void populateFilesList(List<String> filesListInDir, File dir) throws IOException {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                filesListInDir.add(file.getAbsolutePath());
                continue;
            }
            FileUtil.populateFilesList(filesListInDir, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addZipEntry(ZipOutputStream zipOutputStream, ZipEntry zipEntry, InputStream inputStream) throws Exception {
        try {
            zipOutputStream.putNextEntry(zipEntry);
            byte[] buffer = new byte[16384];
            int length = -1;
            while ((length = inputStream.read(buffer, 0, buffer.length)) != -1) {
                zipOutputStream.write(buffer, 0, length);
                zipOutputStream.flush();
            }
        }
        catch (ZipException e) {
            Log.e(TAG, "addZipEntry err!", new Object[0]);
        }
        finally {
            FileUtil.closeQuietly(inputStream);
            zipOutputStream.closeEntry();
        }
    }

    public static boolean isClassFile(String string) {
        String regex = "^[\\S|\\s]*.class$";
        boolean result = false;
        if (string != null && regex != null) {
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(string);
            result = matcher.find();
        }
        return result;
    }
}

