/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.javalib.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.zip.ZipFile;

public final class IOUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRealZipOrJar(File input) {
        boolean bl;
        ZipFile zf = null;
        try {
            zf = new ZipFile(input);
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(zf);
                throw throwable;
            }
            IOUtil.closeQuietly(zf);
            return bl2;
        }
        IOUtil.closeQuietly(zf);
        return bl;
    }

    public static void copyFile(File src, File dest) throws IOException {
        if (!dest.exists()) {
            dest.getParentFile().mkdirs();
        }
        Files.copy(src.toPath(), dest.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyStream(InputStream is, OutputStream os, byte[] buffer) throws IOException {
        int bytesCopied;
        if (buffer == null || buffer.length == 0) {
            buffer = new byte[4096];
        }
        while ((bytesCopied = is.read(buffer)) >= 0) {
            os.write(buffer, 0, bytesCopied);
        }
        os.flush();
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        IOUtil.copyStream(is, os, null);
    }

    public static void closeQuietly(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Closeable) {
            try {
                ((Closeable)obj).close();
            }
            catch (Throwable throwable) {}
        } else if (obj instanceof AutoCloseable) {
            try {
                ((AutoCloseable)obj).close();
            }
            catch (Throwable throwable) {}
        } else if (obj instanceof ZipFile) {
            try {
                ((ZipFile)obj).close();
            }
            catch (Throwable throwable) {}
        } else {
            throw new IllegalArgumentException("obj " + obj + " is not closeable");
        }
    }

    private IOUtil() {
        throw new UnsupportedOperationException();
    }
}

