/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.hook.pthread;

import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.matrix.hook.AbsHook;
import com.tencent.matrix.hook.HookManager;
import com.tencent.matrix.util.MatrixLog;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PthreadHook
extends AbsHook {
    private static final String TAG = "Matrix.Pthread";
    public static final PthreadHook INSTANCE = new PthreadHook();
    private Set<String> mHookThreadName = new HashSet<String>();
    private boolean mEnableQuicken = false;
    private boolean mEnableLog = false;
    private boolean mConfigured = false;
    private boolean mThreadTraceEnabled = false;
    private ThreadStackShrinkConfig mThreadStackShrinkConfig = null;
    private boolean mHookInstalled = false;
    private boolean mEnableTracePthreadRelease = false;

    private PthreadHook() {
    }

    public PthreadHook addHookThread(String regex) {
        if (TextUtils.isEmpty((CharSequence)regex)) {
            MatrixLog.e((String)TAG, (String)"thread regex is empty!!!", (Object[])new Object[0]);
        } else {
            this.mHookThreadName.add(regex);
        }
        return this;
    }

    public PthreadHook addHookThread(String ... regexArr) {
        for (String regex : regexArr) {
            this.addHookThread(regex);
        }
        return this;
    }

    public PthreadHook setThreadTraceEnabled(boolean enabled) {
        this.mThreadTraceEnabled = enabled;
        return this;
    }

    public PthreadHook enableTracePthreadRelease(boolean enabled) {
        this.mEnableTracePthreadRelease = enabled;
        return this;
    }

    public PthreadHook setThreadStackShrinkConfig(@Nullable ThreadStackShrinkConfig config) {
        this.mThreadStackShrinkConfig = config;
        return this;
    }

    public void hook() throws HookManager.HookFailedException {
        HookManager.INSTANCE.clearHooks().addHook(this).commitHooks();
    }

    public void dump(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            throw new IllegalArgumentException("path NOT valid: " + path);
        }
        if (this.getStatus() == AbsHook.Status.COMMIT_SUCCESS) {
            this.dumpNative(path);
        }
    }

    public void enableQuicken(boolean enable) {
        this.mEnableQuicken = enable;
        if (this.mConfigured) {
            this.enableQuickenNative(this.mEnableQuicken);
        }
    }

    public void enableLogger(boolean enable) {
        this.mEnableLog = enable;
        if (this.mConfigured) {
            this.enableLoggerNative(this.mEnableLog);
        }
    }

    @Override
    @Nullable
    protected String getNativeLibraryName() {
        return "matrix-pthreadhook";
    }

    @Override
    public boolean onConfigure() {
        this.addHookThreadNameNative(this.mHookThreadName.toArray(new String[0]));
        this.enableQuickenNative(this.mEnableQuicken);
        this.enableLoggerNative(this.mEnableLog);
        this.enableTracePthreadReleaseNative(this.mEnableTracePthreadRelease);
        if (this.mThreadStackShrinkConfig != null) {
            String[] patterns = new String[this.mThreadStackShrinkConfig.ignoreCreatorSoPatterns.size()];
            if (this.setThreadStackShrinkIgnoredCreatorSoPatternsNative(this.mThreadStackShrinkConfig.ignoreCreatorSoPatterns.toArray(patterns))) {
                this.setThreadStackShrinkEnabledNative(this.mThreadStackShrinkConfig.enabled);
            } else {
                MatrixLog.e((String)TAG, (String)"setThreadStackShrinkIgnoredCreatorSoPatternsNative return false, do not enable ThreadStackShrinker.", (Object[])new Object[0]);
                this.setThreadStackShrinkEnabledNative(false);
            }
        } else {
            this.setThreadStackShrinkIgnoredCreatorSoPatternsNative(null);
            this.setThreadStackShrinkEnabledNative(false);
        }
        this.setThreadTraceEnabledNative(this.mThreadTraceEnabled);
        this.mConfigured = true;
        return true;
    }

    @Override
    protected boolean onHook(boolean enableDebug) {
        if ((this.mThreadTraceEnabled || this.mThreadStackShrinkConfig != null && this.mThreadStackShrinkConfig.enabled) && !this.mHookInstalled) {
            this.installHooksNative(enableDebug);
            this.mHookInstalled = true;
        }
        return true;
    }

    @Keep
    private native void addHookThreadNameNative(String[] var1);

    @Keep
    private native void setThreadTraceEnabledNative(boolean var1);

    @Keep
    private native void setThreadStackShrinkEnabledNative(boolean var1);

    @Keep
    private native boolean setThreadStackShrinkIgnoredCreatorSoPatternsNative(String[] var1);

    @Keep
    private native void enableLoggerNative(boolean var1);

    @Keep
    private native void enableQuickenNative(boolean var1);

    @Keep
    private native void dumpNative(String var1);

    @Keep
    private native void installHooksNative(boolean var1);

    @Keep
    private native void enableTracePthreadReleaseNative(boolean var1);

    public static class ThreadStackShrinkConfig {
        public boolean enabled = false;
        public final Set<String> ignoreCreatorSoPatterns = new HashSet<String>(5);

        public ThreadStackShrinkConfig setEnabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public ThreadStackShrinkConfig setIgnoreCreatorSoPatterns(String ... patterns) {
            if (patterns == null || patterns.length == 0) {
                this.ignoreCreatorSoPatterns.clear();
            } else {
                this.ignoreCreatorSoPatterns.addAll(Arrays.asList(patterns));
            }
            return this;
        }

        public ThreadStackShrinkConfig addIgnoreCreatorSoPatterns(@NonNull String pattern) {
            this.ignoreCreatorSoPatterns.add(pattern);
            return this;
        }
    }
}

