/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.hook;

import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tencent.matrix.hook.AbsHook;
import com.tencent.matrix.util.MatrixLog;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;

public class HookManager {
    private static final String TAG = "Matrix.HookManager";
    public static final HookManager INSTANCE = new HookManager();
    private volatile boolean mHasNativeInitialized = false;
    private byte[] mInitializeGuard = new byte[0];
    private final Set<AbsHook> mPendingHooks = new HashSet<AbsHook>();
    private volatile boolean mEnableDebug = false;
    private NativeLibraryLoader mNativeLibLoader = null;
    private boolean enableLibCxxSharedCheck = false;

    private HookManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitHooks() throws HookFailedException {
        byte[] byArray = this.mInitializeGuard;
        synchronized (this.mInitializeGuard) {
            Set<AbsHook> set = this.mPendingHooks;
            synchronized (set) {
                if (this.mPendingHooks.isEmpty()) {
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 4, 11] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
            if (!this.mHasNativeInitialized) {
                try {
                    if (this.mNativeLibLoader != null) {
                        this.mNativeLibLoader.loadLibrary("matrix-hookcommon");
                    } else {
                        System.loadLibrary("matrix-hookcommon");
                    }
                }
                catch (Throwable e) {
                    MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                if (!this.doPreHookInitializeNative(this.mEnableDebug)) {
                    throw new HookFailedException("Fail to do hook common pre-hook initialize.");
                }
                this.commitHooksLocked();
                this.doFinalInitializeNative(this.mEnableDebug);
                this.mHasNativeInitialized = true;
            } else {
                this.commitHooksLocked();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public HookManager enableLibCxxSharedCheck(boolean enable) {
        this.enableLibCxxSharedCheck = enable;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkLibCxxSharedLoaded() {
        if (Build.VERSION.SDK_INT != 21 && Build.VERSION.SDK_INT != 22) {
            return true;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/self/maps")));){
            String line;
            do {
                if ((line = br.readLine()) == null) return false;
            } while (!line.endsWith("libc++_shared.so"));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
        }
        return false;
    }

    private void ensureLibCxxSharedLoadedForLollipop() throws RuntimeException {
        if (!this.enableLibCxxSharedCheck) {
            return;
        }
        this.enableLibCxxSharedCheck = false;
        if (this.checkLibCxxSharedLoaded()) {
            return;
        }
        if (this.mNativeLibLoader != null) {
            this.mNativeLibLoader.loadLibrary("c++_shared");
        } else {
            System.loadLibrary("c++_shared");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitHooksLocked() throws HookFailedException {
        Set<AbsHook> set = this.mPendingHooks;
        synchronized (set) {
            for (AbsHook hook : this.mPendingHooks) {
                String nativeLibName = hook.getNativeLibraryName();
                if (TextUtils.isEmpty((CharSequence)nativeLibName)) continue;
                try {
                    this.ensureLibCxxSharedLoadedForLollipop();
                    if (this.mNativeLibLoader != null) {
                        this.mNativeLibLoader.loadLibrary(nativeLibName);
                        continue;
                    }
                    System.loadLibrary(nativeLibName);
                }
                catch (Throwable e) {
                    MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
                    MatrixLog.e((String)TAG, (String)"Fail to load native library for %s, skip next steps.", (Object[])new Object[]{hook.getClass().getName()});
                    hook.setStatus(AbsHook.Status.COMMIT_FAIL_ON_LOAD_LIB);
                }
            }
            for (AbsHook hook : this.mPendingHooks) {
                if (hook.getStatus() != AbsHook.Status.UNCOMMIT) {
                    MatrixLog.e((String)TAG, (String)"%s has failed steps before, skip calling onConfigure on it.", (Object[])new Object[]{hook.getClass().getName()});
                    continue;
                }
                if (hook.onConfigure()) continue;
                MatrixLog.e((String)TAG, (String)"Fail to configure %s, skip next steps", (Object[])new Object[]{hook.getClass().getName()});
                hook.setStatus(AbsHook.Status.COMMIT_FAIL_ON_CONFIGURE);
            }
            for (AbsHook hook : this.mPendingHooks) {
                if (hook.getStatus() != AbsHook.Status.UNCOMMIT) {
                    MatrixLog.e((String)TAG, (String)"%s has failed steps before, skip calling onHook on it.", (Object[])new Object[]{hook.getClass().getName()});
                    continue;
                }
                if (hook.onHook(this.mEnableDebug)) {
                    MatrixLog.i((String)TAG, (String)"%s is committed successfully.", (Object[])new Object[]{hook.getClass().getName()});
                    hook.setStatus(AbsHook.Status.COMMIT_SUCCESS);
                    continue;
                }
                MatrixLog.e((String)TAG, (String)"Fail to do hook in %s.", (Object[])new Object[]{hook.getClass().getName()});
                hook.setStatus(AbsHook.Status.COMMIT_FAIL_ON_HOOK);
            }
            this.mPendingHooks.clear();
        }
    }

    public HookManager setEnableDebug(boolean enabled) {
        this.mEnableDebug = enabled;
        return this;
    }

    public HookManager setNativeLibraryLoader(@Nullable NativeLibraryLoader loader) {
        this.mNativeLibLoader = loader;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HookManager addHook(@Nullable AbsHook hook) {
        if (hook != null && hook.getStatus() != AbsHook.Status.COMMIT_SUCCESS) {
            Set<AbsHook> set = this.mPendingHooks;
            synchronized (set) {
                this.mPendingHooks.add(hook);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HookManager clearHooks() {
        Set<AbsHook> set = this.mPendingHooks;
        synchronized (set) {
            this.mPendingHooks.clear();
            return this;
        }
    }

    @Keep
    public static String getStack() {
        try {
            return HookManager.stackTraceToString(Thread.currentThread().getStackTrace());
        }
        catch (Throwable e) {
            return "ERROR: " + HookManager.stackTraceToString(e.getStackTrace());
        }
    }

    private static String stackTraceToString(StackTraceElement[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement stackTraceElement : arr) {
            String className = stackTraceElement.getClassName();
            if (className.contains("java.lang.Thread")) continue;
            sb.append(stackTraceElement).append(';');
        }
        return sb.toString();
    }

    private native boolean doPreHookInitializeNative(boolean var1);

    private native void doFinalInitializeNative(boolean var1);

    public static class HookFailedException
    extends Exception {
        public HookFailedException(String message) {
            super(message);
        }
    }

    public static interface NativeLibraryLoader {
        public void loadLibrary(@NonNull String var1);
    }
}

