/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.hook.art;

import androidx.annotation.Nullable;
import com.tencent.matrix.hook.HookManager;
import com.tencent.matrix.util.MatrixLog;

public final class RuntimeVerifyMute {
    private static final String TAG = "Matrix.RuntimeVerifyMute";
    public static final RuntimeVerifyMute INSTANCE = new RuntimeVerifyMute();
    private HookManager.NativeLibraryLoader mNativeLibLoader = null;
    private boolean mNativeLibLoaded = false;

    public RuntimeVerifyMute setNativeLibraryLoader(@Nullable HookManager.NativeLibraryLoader loader) {
        this.mNativeLibLoader = loader;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureNativeLibLoaded() {
        RuntimeVerifyMute runtimeVerifyMute = this;
        synchronized (runtimeVerifyMute) {
            if (this.mNativeLibLoaded) {
                return true;
            }
            try {
                if (this.mNativeLibLoader != null) {
                    this.mNativeLibLoader.loadLibrary("matrix-hookcommon");
                    this.mNativeLibLoader.loadLibrary("matrix-artmisc");
                } else {
                    System.loadLibrary("matrix-hookcommon");
                    System.loadLibrary("matrix-artmisc");
                }
                this.mNativeLibLoaded = true;
            }
            catch (Throwable thr) {
                MatrixLog.printErrStackTrace((String)TAG, (Throwable)thr, (String)"Fail to load native library.", (Object[])new Object[0]);
                this.mNativeLibLoaded = false;
            }
            return this.mNativeLibLoaded;
        }
    }

    public boolean install() {
        if (!this.ensureNativeLibLoaded()) {
            return false;
        }
        return RuntimeVerifyMute.nativeInstall();
    }

    private static native boolean nativeInstall();

    private RuntimeVerifyMute() {
    }
}

