/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.hook.memory;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.tencent.matrix.hook.HookManager;
import com.tencent.matrix.util.MatrixLog;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public final class GCSemiSpaceTrimmer {
    private static final String TAG = "Matrix.GCSemiSpaceTrimmer";
    public static final GCSemiSpaceTrimmer INSTANCE = new GCSemiSpaceTrimmer();
    private static final Pattern NOT_NUM_PATTERN = Pattern.compile("[^0-9]");
    private static final long DEFAULT_VMSIZE_SAMPLE_INTERVAL = TimeUnit.MINUTES.toMillis(3L);
    private HookManager.NativeLibraryLoader mNativeLibLoader = null;
    private float mCriticalVmSizeRatio = 0.0f;
    private long mVmSizeSampleInterval = DEFAULT_VMSIZE_SAMPLE_INTERVAL;
    private HandlerThread mSampleThread = null;
    private Handler mSampleHandler = null;
    private boolean mNativeLibLoaded = false;
    private boolean mInstalled = false;
    private final Runnable mSampleTask = new Runnable(){

        @Override
        public void run() {
            long vmSize = GCSemiSpaceTrimmer.readVmSize();
            if (vmSize < 0L) {
                MatrixLog.e((String)GCSemiSpaceTrimmer.TAG, (String)"Fail to read vss size, skip checking this time.", (Object[])new Object[0]);
                GCSemiSpaceTrimmer.this.mSampleHandler.postDelayed((Runnable)this, GCSemiSpaceTrimmer.this.mVmSizeSampleInterval);
            } else if ((float)vmSize > 4.2949673E9f * GCSemiSpaceTrimmer.this.mCriticalVmSizeRatio) {
                MatrixLog.i((String)GCSemiSpaceTrimmer.TAG, (String)"VmSize usage reaches above critical level, trigger native install. vmsize: %s, critical_ratio: %s", (Object[])new Object[]{vmSize, Float.valueOf(GCSemiSpaceTrimmer.this.mCriticalVmSizeRatio)});
                boolean nativeInstallRes = GCSemiSpaceTrimmer.this.nativeInstall();
                if (nativeInstallRes) {
                    MatrixLog.i((String)GCSemiSpaceTrimmer.TAG, (String)"nativeInstall triggered successfully.", (Object[])new Object[0]);
                } else {
                    MatrixLog.i((String)GCSemiSpaceTrimmer.TAG, (String)"Fail to trigger nativeInstall.", (Object[])new Object[0]);
                }
            } else {
                MatrixLog.i((String)GCSemiSpaceTrimmer.TAG, (String)"VmSize usage is under critical level, check next time. vmsize: %s, critical_ratio: %s", (Object[])new Object[]{vmSize, Float.valueOf(GCSemiSpaceTrimmer.this.mCriticalVmSizeRatio)});
                GCSemiSpaceTrimmer.this.mSampleHandler.postDelayed((Runnable)this, GCSemiSpaceTrimmer.this.mVmSizeSampleInterval);
            }
        }
    };

    public GCSemiSpaceTrimmer setNativeLibraryLoader(@Nullable HookManager.NativeLibraryLoader loader) {
        this.mNativeLibLoader = loader;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureNativeLibLoaded() {
        GCSemiSpaceTrimmer gCSemiSpaceTrimmer = this;
        synchronized (gCSemiSpaceTrimmer) {
            if (this.mNativeLibLoaded) {
                return true;
            }
            try {
                if (this.mNativeLibLoader != null) {
                    this.mNativeLibLoader.loadLibrary("matrix-hookcommon");
                    this.mNativeLibLoader.loadLibrary("matrix-memoryhook");
                } else {
                    System.loadLibrary("matrix-hookcommon");
                    System.loadLibrary("matrix-memoryhook");
                }
                this.mNativeLibLoaded = true;
            }
            catch (Throwable thr) {
                MatrixLog.printErrStackTrace((String)TAG, (Throwable)thr, (String)"Fail to load native library.", (Object[])new Object[0]);
                this.mNativeLibLoaded = false;
            }
            return this.mNativeLibLoaded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompatible() {
        GCSemiSpaceTrimmer gCSemiSpaceTrimmer = this;
        synchronized (gCSemiSpaceTrimmer) {
            if (!this.ensureNativeLibLoaded()) {
                return false;
            }
            return this.nativeIsCompatible();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean install(float criticalVmSizeRatio, long vmsizeSampleInterval, @Nullable Looper vmSampleLooper) {
        GCSemiSpaceTrimmer gCSemiSpaceTrimmer = this;
        synchronized (gCSemiSpaceTrimmer) {
            if (this.mInstalled) {
                MatrixLog.e((String)TAG, (String)"Already installed.", (Object[])new Object[0]);
                return true;
            }
            if (!this.ensureNativeLibLoaded()) {
                MatrixLog.e((String)TAG, (String)"Fail to load native library.", (Object[])new Object[0]);
                return false;
            }
            this.mCriticalVmSizeRatio = criticalVmSizeRatio;
            if (vmsizeSampleInterval > 0L) {
                this.mVmSizeSampleInterval = vmsizeSampleInterval;
            } else if (vmsizeSampleInterval == 0L) {
                this.mVmSizeSampleInterval = DEFAULT_VMSIZE_SAMPLE_INTERVAL;
            } else {
                MatrixLog.e((String)TAG, (String)("vmsizeSampleInterval cannot less than zero. (value: " + vmsizeSampleInterval + ")"), (Object[])new Object[0]);
                return false;
            }
            if (vmSampleLooper != null) {
                this.mSampleHandler = new Handler(vmSampleLooper);
            } else {
                this.mSampleThread = new HandlerThread("Matrix.GCSST");
                this.mSampleThread.start();
                this.mSampleHandler = new Handler(this.mSampleThread.getLooper());
            }
            this.mSampleHandler.postDelayed(this.mSampleTask, this.mVmSizeSampleInterval);
            MatrixLog.i((String)TAG, (String)"Installed, critcal_vmsize_ratio: %s, vmsize_sample_interval: %s", (Object[])new Object[]{Float.valueOf(criticalVmSizeRatio), vmsizeSampleInterval});
            return true;
        }
    }

    private static long readVmSize() {
        long vssSize = -1L;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/self/status")));){
            String content;
            while ((content = br.readLine()) != null) {
                if (!(content = content.toLowerCase()).contains("vmsize")) continue;
                vssSize = Long.parseLong(NOT_NUM_PATTERN.matcher(content).replaceAll("").trim()) * 1024L;
                break;
            }
        }
        catch (Throwable thr) {
            MatrixLog.printErrStackTrace((String)TAG, (Throwable)thr, (String)"read proc status failed.", (Object[])new Object[0]);
        }
        return vssSize;
    }

    private native boolean nativeIsCompatible();

    private native boolean nativeInstall();

    private GCSemiSpaceTrimmer() {
    }
}

