/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.hook.memory;

import android.text.TextUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.tencent.matrix.hook.AbsHook;
import com.tencent.matrix.hook.HookManager;
import com.tencent.matrix.util.MatrixLog;
import java.util.HashSet;
import java.util.Set;

public class MemoryHook
extends AbsHook {
    private static final String TAG = "Matrix.MemoryHook";
    public static final MemoryHook INSTANCE = new MemoryHook();
    private final Set<String> mHookSoSet = new HashSet<String>();
    private final Set<String> mIgnoreSoSet = new HashSet<String>();
    private int mMinTraceSize;
    private int mMaxTraceSize;
    private int mStacktraceLogThreshold = 0xA00000;
    private boolean mEnableStacktrace;
    private boolean mEnableMmap;
    private boolean mMemGuardInstalled = false;
    private boolean mHookInstalled = false;

    private MemoryHook() {
    }

    public MemoryHook addHookSo(String regex) {
        if (TextUtils.isEmpty((CharSequence)regex)) {
            MatrixLog.e((String)TAG, (String)"thread regex is empty!!!", (Object[])new Object[0]);
        } else {
            this.mHookSoSet.add(regex);
        }
        return this;
    }

    public MemoryHook addHookSo(String ... regexArr) {
        for (String regex : regexArr) {
            this.addHookSo(regex);
        }
        return this;
    }

    public MemoryHook addIgnoreSo(String regex) {
        if (TextUtils.isEmpty((CharSequence)regex)) {
            return this;
        }
        this.mIgnoreSoSet.add(regex);
        return this;
    }

    public MemoryHook addIgnoreSo(String ... regexArr) {
        for (String regex : regexArr) {
            this.addIgnoreSo(regex);
        }
        return this;
    }

    public MemoryHook enableStacktrace(boolean enable) {
        this.mEnableStacktrace = enable;
        return this;
    }

    public MemoryHook tracingAllocSizeRange(int min, int max) {
        this.mMinTraceSize = min;
        this.mMaxTraceSize = max;
        return this;
    }

    public MemoryHook enableMmapHook(boolean enable) {
        this.mEnableMmap = enable;
        return this;
    }

    public MemoryHook stacktraceLogThreshold(int threshold) {
        this.mStacktraceLogThreshold = threshold;
        return this;
    }

    public void notifyMemGuardInstalled() {
        this.mMemGuardInstalled = true;
    }

    public void hook() throws HookManager.HookFailedException {
        HookManager.INSTANCE.clearHooks().addHook(this).commitHooks();
    }

    @Override
    @NonNull
    protected String getNativeLibraryName() {
        return "matrix-memoryhook";
    }

    @Override
    public boolean onConfigure() {
        if (this.mMemGuardInstalled) {
            MatrixLog.w((String)TAG, (String)"MemGuard has been installed, skip MemoryHook install logic.", (Object[])new Object[0]);
            return false;
        }
        if (this.mMinTraceSize < 0 || this.mMaxTraceSize != 0 && this.mMaxTraceSize < this.mMinTraceSize) {
            throw new IllegalArgumentException("sizes should not be negative and maxSize should be 0 or greater than minSize: min = " + this.mMinTraceSize + ", max = " + this.mMaxTraceSize);
        }
        MatrixLog.d((String)TAG, (String)("enable mmap? " + this.mEnableMmap), (Object[])new Object[0]);
        this.enableMmapHookNative(this.mEnableMmap);
        this.setTracingAllocSizeRangeNative(this.mMinTraceSize, this.mMaxTraceSize);
        this.setStacktraceLogThresholdNative(this.mStacktraceLogThreshold);
        this.enableStacktraceNative(this.mEnableStacktrace);
        return true;
    }

    @Override
    protected boolean onHook(boolean enableDebug) {
        if (!this.mHookInstalled) {
            this.installHooksNative(this.mHookSoSet.toArray(new String[0]), this.mIgnoreSoSet.toArray(new String[0]), enableDebug);
            this.mHookInstalled = true;
        }
        return true;
    }

    public void dump(String logPath, String jsonPath) {
        if (this.getStatus() == AbsHook.Status.COMMIT_SUCCESS) {
            this.dumpNative(logPath, jsonPath);
        }
    }

    @Keep
    private native void dumpNative(String var1, String var2);

    @Keep
    private native void setTracingAllocSizeRangeNative(int var1, int var2);

    @Keep
    private native void enableStacktraceNative(boolean var1);

    @Keep
    private native void enableMmapHookNative(boolean var1);

    @Keep
    private native void setStacktraceLogThresholdNative(int var1);

    @Keep
    private native void installHooksNative(String[] var1, String[] var2, boolean var3);
}

