/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.iocanary.detect;

import com.tencent.matrix.iocanary.detect.IOCloseLeakDetector;
import com.tencent.matrix.iocanary.detect.MatrixCloseGuard;
import com.tencent.matrix.report.IssuePublisher;
import com.tencent.matrix.util.MatrixLog;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class CloseGuardHooker {
    private static final String TAG = "Matrix.CloseGuardHooker";
    private volatile boolean mIsTryHook;
    private static volatile Object sOriginalReporter;
    private final IssuePublisher.OnIssueDetectListener issueListener;

    public CloseGuardHooker(IssuePublisher.OnIssueDetectListener issueListener) {
        this.issueListener = issueListener;
    }

    public void hook() {
        MatrixLog.i((String)TAG, (String)"hook sIsTryHook=%b", (Object[])new Object[]{this.mIsTryHook});
        if (!this.mIsTryHook) {
            boolean hookRet = this.tryHook();
            MatrixLog.i((String)TAG, (String)"hook hookRet=%b", (Object[])new Object[]{hookRet});
            this.mIsTryHook = true;
        }
    }

    public void unHook() {
        boolean unHookRet = this.tryUnHook();
        MatrixLog.i((String)TAG, (String)"unHook unHookRet=%b", (Object[])new Object[]{unHookRet});
        this.mIsTryHook = false;
    }

    private boolean tryHook() {
        try {
            Class<?> closeGuardCls = Class.forName("dalvik.system.CloseGuard");
            Class<?> closeGuardReporterCls = Class.forName("dalvik.system.CloseGuard$Reporter");
            Method methodGetReporter = closeGuardCls.getDeclaredMethod("getReporter", new Class[0]);
            Method methodSetReporter = closeGuardCls.getDeclaredMethod("setReporter", closeGuardReporterCls);
            Method methodSetEnabled = closeGuardCls.getDeclaredMethod("setEnabled", Boolean.TYPE);
            sOriginalReporter = methodGetReporter.invoke(null, new Object[0]);
            methodSetEnabled.invoke(null, true);
            MatrixCloseGuard.setEnabled(true);
            ClassLoader classLoader = closeGuardReporterCls.getClassLoader();
            if (classLoader == null) {
                return false;
            }
            methodSetReporter.invoke(null, Proxy.newProxyInstance(classLoader, new Class[]{closeGuardReporterCls}, (InvocationHandler)new IOCloseLeakDetector(this.issueListener, sOriginalReporter)));
            return true;
        }
        catch (Throwable e) {
            MatrixLog.e((String)TAG, (String)"tryHook exp=%s", (Object[])new Object[]{e});
            return false;
        }
    }

    private boolean tryUnHook() {
        try {
            Class<?> closeGuardCls = Class.forName("dalvik.system.CloseGuard");
            Class<?> closeGuardReporterCls = Class.forName("dalvik.system.CloseGuard$Reporter");
            Method methodSetReporter = closeGuardCls.getDeclaredMethod("setReporter", closeGuardReporterCls);
            Method methodSetEnabled = closeGuardCls.getDeclaredMethod("setEnabled", Boolean.TYPE);
            methodSetReporter.invoke(null, sOriginalReporter);
            methodSetEnabled.invoke(null, false);
            MatrixCloseGuard.setEnabled(false);
            return true;
        }
        catch (Throwable e) {
            MatrixLog.e((String)TAG, (String)"tryHook exp=%s", (Object[])new Object[]{e});
            return false;
        }
    }
}

