/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.iocanary.detect;

import com.tencent.matrix.iocanary.util.IOCanaryUtil;
import com.tencent.matrix.report.Issue;
import com.tencent.matrix.report.IssuePublisher;
import com.tencent.matrix.util.MatrixLog;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.json.JSONException;
import org.json.JSONObject;

public class IOCloseLeakDetector
extends IssuePublisher
implements InvocationHandler {
    private static final String TAG = "Matrix.CloseGuardInvocationHandler";
    private final Object originalReporter;

    public IOCloseLeakDetector(IssuePublisher.OnIssueDetectListener issueListener, Object originalReporter) {
        super(issueListener);
        this.originalReporter = originalReporter;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        MatrixLog.i((String)TAG, (String)"invoke method: %s", (Object[])new Object[]{method.getName()});
        if (method.getName().equals("report")) {
            if (args.length != 2) {
                MatrixLog.e((String)TAG, (String)"closeGuard report should has 2 params, current: %d", (Object[])new Object[]{args.length});
                return null;
            }
            if (!(args[1] instanceof Throwable)) {
                MatrixLog.e((String)TAG, (String)"closeGuard report args 1 should be throwable, current: %s", (Object[])new Object[]{args[1]});
                return null;
            }
            Throwable throwable = (Throwable)args[1];
            String stackKey = IOCanaryUtil.getThrowableStack(throwable);
            if (this.isPublished(stackKey)) {
                MatrixLog.d((String)TAG, (String)"close leak issue already published; key:%s", (Object[])new Object[]{stackKey});
            } else {
                Issue ioIssue = new Issue(4);
                ioIssue.setKey(stackKey);
                JSONObject content = new JSONObject();
                try {
                    content.put("stack", (Object)stackKey);
                }
                catch (JSONException e) {
                    MatrixLog.e((String)TAG, (String)"json content error: %s", (Object[])new Object[]{e});
                }
                ioIssue.setContent(content);
                this.publishIssue(ioIssue);
                MatrixLog.i((String)TAG, (String)"close leak issue publish, key:%s", (Object[])new Object[]{stackKey});
                this.markPublished(stackKey);
            }
            return null;
        }
        return method.invoke(this.originalReporter, args);
    }
}

